/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.maven.sal.api.gen.plugin;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.opendaylight.yangtools.binding.generator.util.BindingGeneratorUtil;
import org.opendaylight.yangtools.sal.binding.generator.impl.BindingGeneratorImpl;
import org.opendaylight.yangtools.sal.java.api.generator.GeneratorJavaFile;
import org.opendaylight.yangtools.sal.java.api.generator.YangModuleInfoTemplate;
import org.opendaylight.yangtools.yang.binding.YangModelBindingProvider;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang2sources.spi.BasicCodeGenerator;
import org.opendaylight.yangtools.yang2sources.spi.BuildContextAware;
import org.opendaylight.yangtools.yang2sources.spi.MavenProjectAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

public final class CodeGeneratorImpl
implements BasicCodeGenerator,
BuildContextAware,
MavenProjectAware {
    private static final Logger LOG = LoggerFactory.getLogger(CodeGeneratorImpl.class);
    private static final String FS = File.separator;
    private BuildContext buildContext;
    private File projectBaseDir;
    private Map<String, String> additionalConfig;
    private MavenProject mavenProject;
    private File resourceBaseDir;
    public static final String DEFAULT_OUTPUT_BASE_DIR_PATH = "target" + File.separator + "generated-sources" + File.separator + "maven-sal-api-gen";

    public Collection<File> generateSources(SchemaContext context, File outputDir, Set<Module> yangModules) throws IOException {
        String persistenSourcesPath;
        File outputBaseDir = outputDir == null ? this.getDefaultOutputBaseDir() : outputDir;
        BindingGeneratorImpl bindingGenerator = new BindingGeneratorImpl(true);
        List types = bindingGenerator.generateTypes(context, yangModules);
        GeneratorJavaFile generator = new GeneratorJavaFile(this.buildContext, (Collection)types);
        File persistentSourcesDir = null;
        if (this.additionalConfig != null && (persistenSourcesPath = this.additionalConfig.get("persistentSourcesDir")) != null) {
            persistentSourcesDir = new File(persistenSourcesPath);
        }
        if (persistentSourcesDir == null) {
            persistentSourcesDir = new File(this.projectBaseDir, "src" + FS + "main" + FS + "java");
        }
        List result = generator.generateToFile(outputBaseDir, persistentSourcesDir);
        result.addAll(this.generateModuleInfos(outputBaseDir, yangModules, context));
        return result;
    }

    private Collection<? extends File> generateModuleInfos(File outputBaseDir, Set<Module> yangModules, SchemaContext context) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        ImmutableSet.Builder bindingProviders = ImmutableSet.builder();
        for (Module module : yangModules) {
            ImmutableSet.Builder currentProvidersBuilder = ImmutableSet.builder();
            Set<File> moduleInfoProviders = this.generateYangModuleInfo(outputBaseDir, module, context, (ImmutableSet.Builder<String>)currentProvidersBuilder);
            ImmutableSet currentProviders = currentProvidersBuilder.build();
            LOG.info("Adding ModuleInfo providers {}", (Object)currentProviders);
            bindingProviders.addAll((Iterable)currentProviders);
            result.addAll(moduleInfoProviders);
        }
        result.add((Object)this.writeMetaInfServices(this.resourceBaseDir, YangModelBindingProvider.class, (ImmutableSet<String>)bindingProviders.build()));
        return result.build();
    }

    private File writeMetaInfServices(File outputBaseDir, Class<YangModelBindingProvider> serviceClass, ImmutableSet<String> services) {
        File metainfServicesFolder = new File(outputBaseDir, "META-INF" + File.separator + "services");
        metainfServicesFolder.mkdirs();
        File serviceFile = new File(metainfServicesFolder, serviceClass.getName());
        String src = Joiner.on((char)'\n').join(services);
        return this.writeFile(serviceFile, src);
    }

    private File getDefaultOutputBaseDir() {
        File outputBaseDir = new File(DEFAULT_OUTPUT_BASE_DIR_PATH);
        CodeGeneratorImpl.setOutputBaseDirAsSourceFolder(outputBaseDir, this.mavenProject);
        LOG.debug("Adding " + outputBaseDir.getPath() + " as compile source root");
        return outputBaseDir;
    }

    private static void setOutputBaseDirAsSourceFolder(File outputBaseDir, MavenProject mavenProject) {
        Preconditions.checkNotNull((Object)mavenProject, (Object)"Maven project needs to be set in this phase");
        mavenProject.addCompileSourceRoot(outputBaseDir.getPath());
    }

    public void setAdditionalConfig(Map<String, String> additionalConfiguration) {
        this.additionalConfig = additionalConfiguration;
    }

    public void setResourceBaseDir(File resourceBaseDir) {
        this.resourceBaseDir = resourceBaseDir;
    }

    public void setMavenProject(MavenProject project) {
        this.mavenProject = project;
        this.projectBaseDir = project.getBasedir();
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = (BuildContext)Preconditions.checkNotNull((Object)buildContext);
    }

    private Set<File> generateYangModuleInfo(File outputBaseDir, Module module, SchemaContext ctx, ImmutableSet.Builder<String> providerSourceSet) {
        ImmutableSet.Builder generatedFiles = ImmutableSet.builder();
        YangModuleInfoTemplate template = new YangModuleInfoTemplate(module, ctx);
        String moduleInfoSource = template.generate();
        if (moduleInfoSource.isEmpty()) {
            throw new IllegalStateException("Generated code should not be empty!");
        }
        String providerSource = template.generateModelProvider();
        File packageDir = GeneratorJavaFile.packageToDirectory((File)outputBaseDir, (String)BindingGeneratorUtil.moduleNamespaceToPackageName((Module)module));
        generatedFiles.add((Object)this.writeJavaSource(packageDir, "$YangModuleInfoImpl", moduleInfoSource));
        generatedFiles.add((Object)this.writeJavaSource(packageDir, "$YangModelBindingProvider", providerSource));
        providerSourceSet.add((Object)template.getModelBindingProviderName());
        return generatedFiles.build();
    }

    private File writeJavaSource(File packageDir, String className, String source) {
        if (!packageDir.exists()) {
            packageDir.mkdirs();
        }
        File file = new File(packageDir, className + ".java");
        this.writeFile(file, source);
        return file;
    }

    private File writeFile(File file, String source) {
        try (OutputStream stream = this.buildContext.newFileOutputStream(file);){
            try (OutputStreamWriter fw = new OutputStreamWriter(stream);
                 BufferedWriter bw = new BufferedWriter(fw);){
                bw.write(source);
            }
            catch (Exception e) {
                LOG.error("Could not write file: {}", (Object)file, (Object)e);
            }
        }
        catch (Exception e) {
            LOG.error("Could not create file: {}", (Object)file, (Object)e);
        }
        return file;
    }
}

