package org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.MachineDef;
import org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>bar</b>
 * <br />(Source path: <i>META-INF/yang/bar.yang</i>):
 * <pre>
 * container beta {
 *     container machine {
 *         container atts {
 *             container types {
 *                 choice machine-type {
 *                     case type-a {
 *                         leaf id {
 *                             type string;
 *                         }
 *                     }
 *                 }
 *             }
 *             augment \(urn:yang:bar)factory\(urn:yang:bar)beta\(urn:yang:bar)machine\(urn:yang:bar)atts {
 *                 description
 *                     "Beta Augmentation";
 *                 status CURRENT;
 *                 container types {
 *                     choice machine-type {
 *                         case type-a {
 *                             leaf id {
 *                                 type string;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 uses machine-ext;
 *             }
 *         }
 *     }
 *     uses machine-def;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>bar/factory/beta</i>
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.BetaBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.BetaBuilder
 */
public interface Beta
    extends
    ChildOf<Factory>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Beta>,
    MachineDef
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:yang:bar","2014-03-21","beta");;


}

