package org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321;
import org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Beta;
import org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory} instances.
 * @see org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory
 */
public class FactoryBuilder {

    private Alpha _alpha;
    private Beta _beta;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory>> augmentation = new HashMap<>();

    public FactoryBuilder() {
    } 

    public FactoryBuilder(Factory base) {
        this._alpha = base.getAlpha();
        this._beta = base.getBeta();
        if (base instanceof FactoryImpl) {
            FactoryImpl _impl = (FactoryImpl) base;
            this.augmentation = new HashMap<>(_impl.augmentation);
        }
    }


    public Alpha getAlpha() {
        return _alpha;
    }
    
    public Beta getBeta() {
        return _beta;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public FactoryBuilder setAlpha(Alpha value) {
        this._alpha = value;
        return this;
    }
    
    public FactoryBuilder setBeta(Beta value) {
        this._beta = value;
        return this;
    }
    
    public FactoryBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Factory build() {
        return new FactoryImpl(this);
    }

    private static final class FactoryImpl implements Factory {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory.class;
        }

        private final Alpha _alpha;
        private final Beta _beta;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory>> augmentation = new HashMap<>();

        private FactoryImpl(FactoryBuilder base) {
            this._alpha = base.getAlpha();
            this._beta = base.getBeta();
                switch (base.augmentation.size()) {
                case 0:
                    this.augmentation = Collections.emptyMap();
                    break;
                    case 1:
                        final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory>> e = base.augmentation.entrySet().iterator().next();
                        this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory>>singletonMap(e.getKey(), e.getValue());       
                    break;
                default :
                    this.augmentation = new HashMap<>(base.augmentation);
                }
        }

        @Override
        public Alpha getAlpha() {
            return _alpha;
        }
        
        @Override
        public Beta getBeta() {
            return _beta;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_alpha == null) ? 0 : _alpha.hashCode());
            result = prime * result + ((_beta == null) ? 0 : _beta.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory other = (org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory)obj;
            if (_alpha == null) {
                if (other.getAlpha() != null) {
                    return false;
                }
            } else if(!_alpha.equals(other.getAlpha())) {
                return false;
            }
            if (_beta == null) {
                if (other.getBeta() != null) {
                    return false;
                }
            } else if(!_beta.equals(other.getBeta())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FactoryImpl otherImpl = (FactoryImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Factory [");
            boolean first = true;
        
            if (_alpha != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_alpha=");
                builder.append(_alpha);
             }
            if (_beta != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_beta=");
                builder.append(_beta);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
