package org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.create.nested.factory.input.Nested;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput} instances.
 * @see org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput
 */
public class CreateNestedFactoryInputBuilder {

    private Nested _nested;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput>> augmentation = new HashMap<>();

    public CreateNestedFactoryInputBuilder() {
    } 

    public CreateNestedFactoryInputBuilder(CreateNestedFactoryInput base) {
        this._nested = base.getNested();
        if (base instanceof CreateNestedFactoryInputImpl) {
            CreateNestedFactoryInputImpl _impl = (CreateNestedFactoryInputImpl) base;
            this.augmentation = new HashMap<>(_impl.augmentation);
        }
    }


    public Nested getNested() {
        return _nested;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public CreateNestedFactoryInputBuilder setNested(Nested value) {
        this._nested = value;
        return this;
    }
    
    public CreateNestedFactoryInputBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public CreateNestedFactoryInput build() {
        return new CreateNestedFactoryInputImpl(this);
    }

    private static final class CreateNestedFactoryInputImpl implements CreateNestedFactoryInput {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput.class;
        }

        private final Nested _nested;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput>> augmentation = new HashMap<>();

        private CreateNestedFactoryInputImpl(CreateNestedFactoryInputBuilder base) {
            this._nested = base.getNested();
                switch (base.augmentation.size()) {
                case 0:
                    this.augmentation = Collections.emptyMap();
                    break;
                    case 1:
                        final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput>> e = base.augmentation.entrySet().iterator().next();
                        this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput>>singletonMap(e.getKey(), e.getValue());       
                    break;
                default :
                    this.augmentation = new HashMap<>(base.augmentation);
                }
        }

        @Override
        public Nested getNested() {
            return _nested;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_nested == null) ? 0 : _nested.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput other = (org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput)obj;
            if (_nested == null) {
                if (other.getNested() != null) {
                    return false;
                }
            } else if(!_nested.equals(other.getNested())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                CreateNestedFactoryInputImpl otherImpl = (CreateNestedFactoryInputImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("CreateNestedFactoryInput [");
            boolean first = true;
        
            if (_nested != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nested=");
                builder.append(_nested);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
