package org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>bar</b>
 * <br />Source path: <i>META-INF/yang/bar.yang</i>):
 * <pre>
 * module bar {
 *     yang-version 1;
 *     namespace "urn:yang:bar";
 *     prefix "bar";
 *     import baz { prefix "baz"; }
 *     revision 2014-03-21 {
 *         description "";
 *     }
 *     container factory {
 *         container alpha {
 *             container machine {
 *                 container atts {
 *                     container types {
 *                         choice machine-type {
 *                             case type-a {
 *                                 leaf id {
 *                                     type string;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     augment \(urn:yang:bar)factory\(urn:yang:bar)alpha\(urn:yang:bar)machine\(urn:yang:bar)atts {
 *                         description
 *                             "Alpha Augmentation";
 *                         status CURRENT;
 *                         container types {
 *                             choice machine-type {
 *                                 case type-a {
 *                                     leaf id {
 *                                         type string;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses machine-ext;
 *                     }
 *                 }
 *             }
 *             uses machine-def;
 *         }
 *         container beta {
 *             container machine {
 *                 container atts {
 *                     container types {
 *                         choice machine-type {
 *                             case type-a {
 *                                 leaf id {
 *                                     type string;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     augment \(urn:yang:bar)factory\(urn:yang:bar)beta\(urn:yang:bar)machine\(urn:yang:bar)atts {
 *                         description
 *                             "Beta Augmentation";
 *                         status CURRENT;
 *                         container types {
 *                             choice machine-type {
 *                                 case type-a {
 *                                     leaf id {
 *                                         type string;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses machine-ext;
 *                     }
 *                 }
 *             }
 *             uses machine-def;
 *         }
 *     }
 *     grouping machine-ext {
 *         container types {
 *             choice machine-type {
 *                 case type-a {
 *                     leaf id {
 *                         type string;
 *                     }
 *                 }
 *             }
 *         }
 *     }
 *     grouping machine-types {
 *         container types {
 *             choice machine-type {
 *             }
 *         }
 *     }
 *     rpc create-factory {
 *         input {
 *             container machine {
 *                 container atts {
 *                     container types {
 *                         choice machine-type {
 *                             case type-a {
 *                                 leaf id {
 *                                     type string;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     augment \(urn:yang:bar)create-factory\(urn:yang:bar)input\(urn:yang:bar)machine\(urn:yang:bar)atts {
 *                         description
 *                             "Create Factory Augmentation";
 *                         status CURRENT;
 *                         container types {
 *                             choice machine-type {
 *                                 case type-a {
 *                                     leaf id {
 *                                         type string;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses machine-ext;
 *                     }
 *                 }
 *             }
 *         }
 *         
 *         status CURRENT;
 *     }
 *     rpc create-nested-factory {
 *         input {
 *             container nested {
 *                 container machine {
 *                     container atts {
 *                         container types {
 *                             choice machine-type {
 *                                 case type-a {
 *                                     leaf id {
 *                                         type string;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         augment \(urn:yang:bar)create-nested-factory\(urn:yang:bar)input\(urn:yang:bar)nested\(urn:yang:bar)machine\(urn:yang:bar)atts {
 *                             description
 *                                 "Create Nested Augmentation";
 *                             status CURRENT;
 *                             container types {
 *                                 choice machine-type {
 *                                     case type-a {
 *                                         leaf id {
 *                                             type string;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             uses machine-ext;
 *                         }
 *                     }
 *                 }
 *                 uses machine-def;
 *             }
 *         }
 *         
 *         status CURRENT;
 *     }
 * }
 * </pre>
 */
public interface BarData
    extends
    DataRoot
{




    Factory getFactory();

}

