package org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types;
import org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.types.MachineType;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types} instances.
 * @see org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types
 */
public class TypesBuilder {

    private MachineType _machineType;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types>> augmentation = new HashMap<>();

    public TypesBuilder() {
    } 

    public TypesBuilder(Types base) {
        this._machineType = base.getMachineType();
        if (base instanceof TypesImpl) {
            TypesImpl _impl = (TypesImpl) base;
            this.augmentation = new HashMap<>(_impl.augmentation);
        }
    }


    public MachineType getMachineType() {
        return _machineType;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public TypesBuilder setMachineType(MachineType value) {
        this._machineType = value;
        return this;
    }
    
    public TypesBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Types build() {
        return new TypesImpl(this);
    }

    private static final class TypesImpl implements Types {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types.class;
        }

        private final MachineType _machineType;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types>> augmentation = new HashMap<>();

        private TypesImpl(TypesBuilder base) {
            this._machineType = base.getMachineType();
                switch (base.augmentation.size()) {
                case 0:
                    this.augmentation = Collections.emptyMap();
                    break;
                    case 1:
                        final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types>> e = base.augmentation.entrySet().iterator().next();
                        this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types>>singletonMap(e.getKey(), e.getValue());       
                    break;
                default :
                    this.augmentation = new HashMap<>(base.augmentation);
                }
        }

        @Override
        public MachineType getMachineType() {
            return _machineType;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_machineType == null) ? 0 : _machineType.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types other = (org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types)obj;
            if (_machineType == null) {
                if (other.getMachineType() != null) {
                    return false;
                }
            } else if(!_machineType.equals(other.getMachineType())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                TypesImpl otherImpl = (TypesImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.types.Types>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Types [");
            boolean first = true;
        
            if (_machineType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_machineType=");
                builder.append(_machineType);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
