package org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA} instances.
 * @see org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA
 */
public class TypeABuilder {

    private java.lang.String _id;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA>> augmentation = new HashMap<>();

    public TypeABuilder() {
    } 
    

    public TypeABuilder(TypeA base) {
        this._id = base.getId();
        if (base instanceof TypeAImpl) {
            TypeAImpl _impl = (TypeAImpl) base;
            this.augmentation = new HashMap<>(_impl.augmentation);
        }
    }


    public java.lang.String getId() {
        return _id;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public TypeABuilder setId(java.lang.String value) {
        this._id = value;
        return this;
    }
    
    public TypeABuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TypeA build() {
        return new TypeAImpl(this);
    }

    private static final class TypeAImpl implements TypeA {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA.class;
        }

        private final java.lang.String _id;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA>> augmentation = new HashMap<>();

        private TypeAImpl(TypeABuilder base) {
            this._id = base.getId();
                switch (base.augmentation.size()) {
                case 0:
                    this.augmentation = Collections.emptyMap();
                    break;
                    case 1:
                        final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA>> e = base.augmentation.entrySet().iterator().next();
                        this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA>>singletonMap(e.getKey(), e.getValue());       
                    break;
                default :
                    this.augmentation = new HashMap<>(base.augmentation);
                }
        }

        @Override
        public java.lang.String getId() {
            return _id;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_id == null) ? 0 : _id.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA other = (org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA)obj;
            if (_id == null) {
                if (other.getId() != null) {
                    return false;
                }
            } else if(!_id.equals(other.getId())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                TypeAImpl otherImpl = (TypeAImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.machine.ext.types.machine.type.TypeA>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("TypeA [");
            boolean first = true;
        
            if (_id != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_id=");
                builder.append(_id);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
