package org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321;
import org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Beta;
import org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha;
import org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.BarData;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>bar</b>
 * <br />(Source path: <i>META-INF/yang/bar.yang</i>):
 * <pre>
 * container factory {
 *     container alpha {
 *         container machine {
 *             container atts {
 *                 container types {
 *                     choice machine-type {
 *                         case type-a {
 *                             leaf id {
 *                                 type string;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 augment \(urn:yang:bar)factory\(urn:yang:bar)alpha\(urn:yang:bar)machine\(urn:yang:bar)atts {
 *                     description
 *                         "Alpha Augmentation";
 *                     status CURRENT;
 *                     container types {
 *                         choice machine-type {
 *                             case type-a {
 *                                 leaf id {
 *                                     type string;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses machine-ext;
 *                 }
 *             }
 *         }
 *         uses machine-def;
 *     }
 *     container beta {
 *         container machine {
 *             container atts {
 *                 container types {
 *                     choice machine-type {
 *                         case type-a {
 *                             leaf id {
 *                                 type string;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 augment \(urn:yang:bar)factory\(urn:yang:bar)beta\(urn:yang:bar)machine\(urn:yang:bar)atts {
 *                     description
 *                         "Beta Augmentation";
 *                     status CURRENT;
 *                     container types {
 *                         choice machine-type {
 *                             case type-a {
 *                                 leaf id {
 *                                     type string;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses machine-ext;
 *                 }
 *             }
 *         }
 *         uses machine-def;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>bar/factory</i>
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.FactoryBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.FactoryBuilder
 */
public interface Factory
    extends
    ChildOf<BarData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.Factory>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:yang:bar","2014-03-21","factory");;

    Alpha getAlpha();
    
    Beta getBeta();

}

