package org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.machine.Atts;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine} instances.
 * @see org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine
 */
public class MachineBuilder {

    private Atts _atts;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine>> augmentation = new HashMap<>();

    public MachineBuilder() {
    } 

    public MachineBuilder(Machine base) {
        this._atts = base.getAtts();
        if (base instanceof MachineImpl) {
            MachineImpl _impl = (MachineImpl) base;
            this.augmentation = new HashMap<>(_impl.augmentation);
        }
    }


    public Atts getAtts() {
        return _atts;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public MachineBuilder setAtts(Atts value) {
        this._atts = value;
        return this;
    }
    
    public MachineBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Machine build() {
        return new MachineImpl(this);
    }

    private static final class MachineImpl implements Machine {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine.class;
        }

        private final Atts _atts;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine>> augmentation = new HashMap<>();

        private MachineImpl(MachineBuilder base) {
            this._atts = base.getAtts();
                switch (base.augmentation.size()) {
                case 0:
                    this.augmentation = Collections.emptyMap();
                    break;
                    case 1:
                        final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine>> e = base.augmentation.entrySet().iterator().next();
                        this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine>>singletonMap(e.getKey(), e.getValue());       
                    break;
                default :
                    this.augmentation = new HashMap<>(base.augmentation);
                }
        }

        @Override
        public Atts getAtts() {
            return _atts;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_atts == null) ? 0 : _atts.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine other = (org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine)obj;
            if (_atts == null) {
                if (other.getAtts() != null) {
                    return false;
                }
            } else if(!_atts.equals(other.getAtts())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                MachineImpl otherImpl = (MachineImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Machine [");
            boolean first = true;
        
            if (_atts != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_atts=");
                builder.append(_atts);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
