package org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory;
import org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.machine.def.Machine;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha} instances.
 * @see org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha
 */
public class AlphaBuilder {

    private Machine _machine;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha>> augmentation = new HashMap<>();

    public AlphaBuilder() {
    } 
    
    public AlphaBuilder(org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.MachineDef arg) {
        this._machine = arg.getMachine();
    }

    public AlphaBuilder(Alpha base) {
        this._machine = base.getMachine();
        if (base instanceof AlphaImpl) {
            AlphaImpl _impl = (AlphaImpl) base;
            this.augmentation = new HashMap<>(_impl.augmentation);
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.MachineDef</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.MachineDef) {
            this._machine = ((org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.MachineDef)arg).getMachine();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.yang.baz.rev140321.MachineDef] \n" +
              "but was: " + arg
            );
        }
    }

    public Machine getMachine() {
        return _machine;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public AlphaBuilder setMachine(Machine value) {
        this._machine = value;
        return this;
    }
    
    public AlphaBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Alpha build() {
        return new AlphaImpl(this);
    }

    private static final class AlphaImpl implements Alpha {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha.class;
        }

        private final Machine _machine;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha>> augmentation = new HashMap<>();

        private AlphaImpl(AlphaBuilder base) {
            this._machine = base.getMachine();
                switch (base.augmentation.size()) {
                case 0:
                    this.augmentation = Collections.emptyMap();
                    break;
                    case 1:
                        final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha>> e = base.augmentation.entrySet().iterator().next();
                        this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha>>singletonMap(e.getKey(), e.getValue());       
                    break;
                default :
                    this.augmentation = new HashMap<>(base.augmentation);
                }
        }

        @Override
        public Machine getMachine() {
            return _machine;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_machine == null) ? 0 : _machine.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha other = (org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha)obj;
            if (_machine == null) {
                if (other.getMachine() != null) {
                    return false;
                }
            } else if(!_machine.equals(other.getMachine())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                AlphaImpl otherImpl = (AlphaImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha>>, Augmentation<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.factory.Alpha>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Alpha [");
            boolean first = true;
        
            if (_machine != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_machine=");
                builder.append(_machine);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
