package org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.create.nested.factory.input.Nested;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>bar</b>
 * <br />(Source path: <i>META-INF/yang/bar.yang</i>):
 * <pre>
 * container input {
 *     container nested {
 *         container machine {
 *             container atts {
 *                 container types {
 *                     choice machine-type {
 *                         case type-a {
 *                             leaf id {
 *                                 type string;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 augment \(urn:yang:bar)create-nested-factory\(urn:yang:bar)input\(urn:yang:bar)nested\(urn:yang:bar)machine\(urn:yang:bar)atts {
 *                     description
 *                         "Create Nested Augmentation";
 *                     status CURRENT;
 *                     container types {
 *                         choice machine-type {
 *                             case type-a {
 *                                 leaf id {
 *                                     type string;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses machine-ext;
 *                 }
 *             }
 *         }
 *         uses machine-def;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>bar/create-nested-factory/input</i>
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInputBuilder
 */
public interface CreateNestedFactoryInput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:yang:bar","2014-03-21","input");;

    Nested getNested();

}

