package org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321;
import java.util.concurrent.Future;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateFactoryInput;
import org.opendaylight.yang.gen.v1.urn.yang.bar.rev140321.CreateNestedFactoryInput;


/**
 * Interface for implementing the following YANG RPCs defined in module <b>bar</b>
 * <br />(Source path: <i>META-INF/yang/bar.yang</i>):
 * <pre>
 * rpc create-factory {
 *     input {
 *         container machine {
 *             container atts {
 *                 container types {
 *                     choice machine-type {
 *                         case type-a {
 *                             leaf id {
 *                                 type string;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 augment \(urn:yang:bar)create-factory\(urn:yang:bar)input\(urn:yang:bar)machine\(urn:yang:bar)atts {
 *                     description
 *                         "Create Factory Augmentation";
 *                     status CURRENT;
 *                     container types {
 *                         choice machine-type {
 *                             case type-a {
 *                                 leaf id {
 *                                     type string;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses machine-ext;
 *                 }
 *             }
 *         }
 *     }
 *     
 *     status CURRENT;
 * }
 * rpc create-nested-factory {
 *     input {
 *         container nested {
 *             container machine {
 *                 container atts {
 *                     container types {
 *                         choice machine-type {
 *                             case type-a {
 *                                 leaf id {
 *                                     type string;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     augment \(urn:yang:bar)create-nested-factory\(urn:yang:bar)input\(urn:yang:bar)nested\(urn:yang:bar)machine\(urn:yang:bar)atts {
 *                         description
 *                             "Create Nested Augmentation";
 *                         status CURRENT;
 *                         container types {
 *                             choice machine-type {
 *                                 case type-a {
 *                                     leaf id {
 *                                         type string;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses machine-ext;
 *                     }
 *                 }
 *             }
 *             uses machine-def;
 *         }
 *     }
 *     
 *     status CURRENT;
 * }
 * </pre>
 */
public interface BarService
    extends
    RpcService
{




    Future<RpcResult<java.lang.Void>> createFactory(CreateFactoryInput input);
    
    Future<RpcResult<java.lang.Void>> createNestedFactory(CreateNestedFactoryInput input);

}

