/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.xtend.lib.Property;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Pure;
import org.opendaylight.yangtools.binding.generator.util.Types;
import org.opendaylight.yangtools.sal.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.sal.binding.model.api.ParameterizedType;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.WildcardType;
import org.opendaylight.yangtools.yang.binding.BindingMapping;
import org.opendaylight.yangtools.yang.binding.YangModelBindingProvider;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class YangModuleInfoTemplate {
    private final Module module;
    private final SchemaContext ctx;
    private final Map<String, String> importMap = new LinkedHashMap<String, String>();
    @Property
    private final String _packageName;
    @Property
    private final String _modelBindingProviderName;

    public YangModuleInfoTemplate(Module module, SchemaContext ctx) {
        String _rootPackageName;
        boolean _notEquals = !Objects.equal((Object)module, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"Module must not be null.");
        this.module = module;
        this.ctx = ctx;
        QNameModule _qNameModule = module.getQNameModule();
        this._packageName = _rootPackageName = BindingMapping.getRootPackageName((QNameModule)_qNameModule);
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = this.getPackageName();
        _builder.append((Object)_packageName, "");
        _builder.append((Object)".");
        _builder.append((Object)"$YangModelBindingProvider", "");
        this._modelBindingProviderName = _builder.toString();
    }

    public String generate() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public final class ");
        _builder.append((Object)"$YangModuleInfoImpl", "");
        _builder.append((Object)" implements ");
        String _importedName = this.importedName(YangModuleInfo.class);
        _builder.append((Object)_importedName, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private static final ");
        String _importedName_1 = this.importedName(YangModuleInfo.class);
        _builder.append((Object)_importedName_1, "    ");
        _builder.append((Object)" INSTANCE = new ");
        _builder.append((Object)"$YangModuleInfoImpl", "    ");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private final ");
        String _importedName_2 = this.importedName(String.class);
        _builder.append((Object)_importedName_2, "    ");
        _builder.append((Object)" name = \"");
        String _name = this.module.getName();
        _builder.append((Object)_name, "    ");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"private final ");
        String _importedName_3 = this.importedName(String.class);
        _builder.append((Object)_importedName_3, "    ");
        _builder.append((Object)" namespace = \"");
        URI _namespace = this.module.getNamespace();
        String _string = _namespace.toString();
        _builder.append((Object)_string, "    ");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"private final ");
        String _importedName_4 = this.importedName(String.class);
        _builder.append((Object)_importedName_4, "    ");
        _builder.append((Object)" revision = \"");
        Date _revision = this.module.getRevision();
        String _format = df.format(_revision);
        _builder.append((Object)_format, "    ");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"private final ");
        String _importedName_5 = this.importedName(String.class);
        _builder.append((Object)_importedName_5, "    ");
        _builder.append((Object)" resourcePath = \"");
        String _sourcePath = this.getSourcePath();
        _builder.append((Object)_sourcePath, "    ");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private final ");
        String _importedName_6 = this.importedName(Set.class);
        _builder.append((Object)_importedName_6, "    ");
        _builder.append((Object)"<YangModuleInfo> importedModules;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static ");
        String _importedName_7 = this.importedName(YangModuleInfo.class);
        _builder.append((Object)_importedName_7, "    ");
        _builder.append((Object)" getInstance() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"return INSTANCE;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _classBody = this.classBody(this.module, "$YangModuleInfoImpl");
        _builder.append((Object)_classBody, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        String body = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"package ");
        String _packageName = this.getPackageName();
        _builder_1.append((Object)_packageName, "");
        _builder_1.append((Object)" ;");
        _builder_1.newLineIfNotEmpty();
        CharSequence _imports = this.imports();
        _builder_1.append((Object)_imports, "");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append((Object)body, "");
        _builder_1.newLineIfNotEmpty();
        return _builder_1.toString();
    }

    public String generateModelProvider() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _packageName = this.getPackageName();
        _builder.append((Object)_packageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public final class ");
        _builder.append((Object)"$YangModelBindingProvider", "");
        _builder.append((Object)" implements ");
        String _name = YangModelBindingProvider.class.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public ");
        String _name_1 = YangModuleInfo.class.getName();
        _builder.append((Object)_name_1, "    ");
        _builder.append((Object)" getModuleInfo() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"return ");
        _builder.append((Object)"$YangModuleInfoImpl", "        ");
        _builder.append((Object)".getInstance();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    private CharSequence classBody(Module m, String className) {
        Set _submodules_1;
        boolean _isEmpty_3;
        boolean _not_3;
        Set _imports_1;
        boolean _isEmpty_2;
        boolean _not_2;
        Set _submodules;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"private ");
        _builder.append((Object)className, "");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        boolean _or = false;
        Set _imports = m.getImports();
        boolean _isEmpty = _imports.isEmpty();
        boolean bl = _not = !_isEmpty;
        _or = _not ? true : (_not_1 = !(_isEmpty_1 = (_submodules = m.getSubmodules()).isEmpty()));
        if (_or) {
            _builder.append((Object)"    ");
            String _importedName = this.importedName(Set.class);
            _builder.append((Object)_importedName, "    ");
            _builder.append((Object)"<");
            String _importedName_1 = this.importedName(YangModuleInfo.class);
            _builder.append((Object)_importedName_1, "    ");
            _builder.append((Object)"> set = new ");
            String _importedName_2 = this.importedName(HashSet.class);
            _builder.append((Object)_importedName_2, "    ");
            _builder.append((Object)"<>();");
            _builder.newLineIfNotEmpty();
        }
        boolean bl2 = _not_2 = !(_isEmpty_2 = (_imports_1 = m.getImports()).isEmpty());
        if (_not_2) {
            Set _imports_2 = m.getImports();
            for (ModuleImport imp : _imports_2) {
                _builder.append((Object)"    ");
                String name = imp.getModuleName();
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                Date rev = imp.getRevision();
                _builder.newLineIfNotEmpty();
                boolean _equals = Objects.equal((Object)rev, null);
                if (_equals) {
                    _builder.append((Object)"    ");
                    Set modules = this.ctx.getModules();
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    TreeMap<Date, Module> sorted = new TreeMap<Date, Module>();
                    _builder.newLineIfNotEmpty();
                    for (Module module : modules) {
                        String _name = module.getName();
                        boolean _equals_1 = _name.equals(name);
                        if (!_equals_1) continue;
                        _builder.append((Object)"    ");
                        Date _revision = module.getRevision();
                        Module _put = sorted.put(_revision, module);
                        _builder.append((Object)_put, "    ");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"    ");
                    _builder.append((Object)"set.add(");
                    Map.Entry _lastEntry = sorted.lastEntry();
                    Module _value = (Module)_lastEntry.getValue();
                    QNameModule _qNameModule = _value.getQNameModule();
                    String _rootPackageName = BindingMapping.getRootPackageName((QNameModule)_qNameModule);
                    _builder.append((Object)_rootPackageName, "    ");
                    _builder.append((Object)".");
                    _builder.append((Object)"$YangModuleInfoImpl", "    ");
                    _builder.append((Object)".getInstance());");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"    ");
                _builder.append((Object)"set.add(");
                Module _findModuleByName = this.ctx.findModuleByName(name, rev);
                QNameModule _qNameModule_1 = _findModuleByName.getQNameModule();
                String _rootPackageName_1 = BindingMapping.getRootPackageName((QNameModule)_qNameModule_1);
                _builder.append((Object)_rootPackageName_1, "    ");
                _builder.append((Object)".");
                _builder.append((Object)"$YangModuleInfoImpl", "    ");
                _builder.append((Object)".getInstance());");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl3 = _not_3 = !(_isEmpty_3 = (_submodules_1 = m.getSubmodules()).isEmpty());
        if (_not_3) {
            Set _submodules_2 = m.getSubmodules();
            for (Module submodule : _submodules_2) {
                _builder.append((Object)"    ");
                _builder.append((Object)"set.add(");
                String _name_1 = submodule.getName();
                String _className = BindingMapping.getClassName((String)_name_1);
                _builder.append((Object)_className, "    ");
                _builder.append((Object)"Info.getInstance());");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean _and = false;
        Set _imports_3 = m.getImports();
        boolean _isEmpty_4 = _imports_3.isEmpty();
        if (!_isEmpty_4) {
            _and = false;
        } else {
            boolean _isEmpty_5;
            Set _submodules_3 = m.getSubmodules();
            _and = _isEmpty_5 = _submodules_3.isEmpty();
        }
        if (_and) {
            _builder.append((Object)"    ");
            _builder.append((Object)"importedModules = ");
            String _importedName_3 = this.importedName(Collections.class);
            _builder.append((Object)_importedName_3, "    ");
            _builder.append((Object)".emptySet();");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append((Object)"    ");
            _builder.append((Object)"importedModules = ");
            String _importedName_4 = this.importedName(ImmutableSet.class);
            _builder.append((Object)_importedName_4, "    ");
            _builder.append((Object)".copyOf(set);");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"    ");
        String _importedName_5 = this.importedName(InputStream.class);
        _builder.append((Object)_importedName_5, "    ");
        _builder.append((Object)" stream = ");
        _builder.append((Object)"$YangModuleInfoImpl", "    ");
        _builder.append((Object)".class.getResourceAsStream(resourcePath);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"if (stream == null) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"throw new IllegalStateException(\"Resource '\" + resourcePath + \"' is missing\");");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"stream.close();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"} catch (");
        String _importedName_6 = this.importedName(IOException.class);
        _builder.append((Object)_importedName_6, "    ");
        _builder.append((Object)" e) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"// Resource leak, but there is nothing we can do");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _importedName_7 = this.importedName(String.class);
        _builder.append((Object)_importedName_7, "");
        _builder.append((Object)" getName() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"return name;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _importedName_8 = this.importedName(String.class);
        _builder.append((Object)_importedName_8, "");
        _builder.append((Object)" getRevision() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"return revision;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _importedName_9 = this.importedName(String.class);
        _builder.append((Object)_importedName_9, "");
        _builder.append((Object)" getNamespace() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"return namespace;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _importedName_10 = this.importedName(InputStream.class);
        _builder.append((Object)_importedName_10, "");
        _builder.append((Object)" getModuleSourceStream() throws IOException {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        String _importedName_11 = this.importedName(InputStream.class);
        _builder.append((Object)_importedName_11, "    ");
        _builder.append((Object)" stream = ");
        _builder.append((Object)"$YangModuleInfoImpl", "    ");
        _builder.append((Object)".class.getResourceAsStream(resourcePath);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"if (stream == null) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"throw new ");
        String _importedName_12 = this.importedName(IOException.class);
        _builder.append((Object)_importedName_12, "        ");
        _builder.append((Object)"(\"Resource \" + resourcePath + \" is missing\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"return stream;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _importedName_13 = this.importedName(Set.class);
        _builder.append((Object)_importedName_13, "");
        _builder.append((Object)"<");
        String _importedName_14 = this.importedName(YangModuleInfo.class);
        _builder.append((Object)_importedName_14, "");
        _builder.append((Object)"> getImportedModules() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"return importedModules;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _importedName_15 = this.importedName(String.class);
        _builder.append((Object)_importedName_15, "");
        _builder.append((Object)" toString() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        String _importedName_16 = this.importedName(StringBuilder.class);
        _builder.append((Object)_importedName_16, "    ");
        _builder.append((Object)" sb = new ");
        String _importedName_17 = this.importedName(StringBuilder.class);
        _builder.append((Object)_importedName_17, "    ");
        _builder.append((Object)"(this.getClass().getCanonicalName());");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"sb.append(\"[\");");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"sb.append(\"name = \" + name);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"sb.append(\", namespace = \" + namespace);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"sb.append(\", revision = \" + revision);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"sb.append(\", resourcePath = \" + resourcePath);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"sb.append(\", imports = \" + importedModules);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"sb.append(\"]\");");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"return sb.toString();");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateSubInfo = this.generateSubInfo(m);
        _builder.append((Object)_generateSubInfo, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public String getSourcePath() {
        String _moduleSourcePath = this.module.getModuleSourcePath();
        String _replace = _moduleSourcePath.replace(File.separatorChar, '/');
        return "/" + _replace;
    }

    private CharSequence imports() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.importMap.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Set<Map.Entry<String, String>> _entrySet = this.importMap.entrySet();
            for (Map.Entry<String, String> entry : _entrySet) {
                QNameModule _qNameModule;
                String _rootPackageName;
                String _value = entry.getValue();
                boolean _notEquals = !Objects.equal((Object)_value, (Object)(_rootPackageName = BindingMapping.getRootPackageName((QNameModule)(_qNameModule = this.module.getQNameModule()))));
                if (!_notEquals) continue;
                _builder.append((Object)"import ");
                String _value_1 = entry.getValue();
                _builder.append((Object)_value_1, "");
                _builder.append((Object)".");
                String _key = entry.getKey();
                _builder.append((Object)_key, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    protected final String importedName(Class<?> cls) {
        String _xblockexpression = null;
        ConcreteType intype = Types.typeForClass(cls);
        this.putTypeIntoImports((Type)intype);
        _xblockexpression = this.getExplicitType((Type)intype);
        return _xblockexpression;
    }

    public final void putTypeIntoImports(Type type) {
        boolean _not;
        boolean _isEmpty;
        String typeName = type.getName();
        String typePackageName = type.getPackageName();
        boolean _or = false;
        boolean _startsWith = typePackageName.startsWith("java.lang");
        _or = _startsWith ? true : (_isEmpty = typePackageName.isEmpty());
        if (_or) {
            return;
        }
        boolean _containsKey = this.importMap.containsKey(typeName);
        boolean bl = _not = !_containsKey;
        if (_not) {
            this.importMap.put(typeName, typePackageName);
        }
        if (type instanceof ParameterizedType) {
            boolean _notEquals;
            Type[] params = ((ParameterizedType)type).getActualTypeArguments();
            boolean bl2 = _notEquals = !Objects.equal((Object)params, null);
            if (_notEquals) {
                for (Type param : params) {
                    this.putTypeIntoImports(param);
                }
            }
        }
    }

    public final String getExplicitType(Type type) {
        String typePackageName = type.getPackageName();
        String typeName = type.getName();
        String importedPackageName = this.importMap.get(typeName);
        StringBuilder builder = null;
        boolean _equals = typePackageName.equals(importedPackageName);
        if (_equals) {
            StringBuilder _stringBuilder;
            String _name = type.getName();
            builder = _stringBuilder = new StringBuilder(_name);
            this.addActualTypeParameters(builder, type);
            String _string = builder.toString();
            boolean _equals_1 = _string.equals("Void");
            if (_equals_1) {
                return "void";
            }
        } else {
            StringBuilder _stringBuilder_1;
            builder = _stringBuilder_1 = new StringBuilder();
            boolean _startsWith = typePackageName.startsWith("java.lang");
            if (_startsWith) {
                String _name_1 = type.getName();
                builder.append(_name_1);
            } else {
                boolean _not;
                boolean _isEmpty = typePackageName.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    String _name_2 = type.getName();
                    String _plus = typePackageName + "." + _name_2;
                    builder.append(_plus);
                } else {
                    String _name_3 = type.getName();
                    builder.append(_name_3);
                }
            }
            ConcreteType _voidType = Types.voidType();
            boolean _equals_2 = type.equals(_voidType);
            if (_equals_2) {
                return "void";
            }
            this.addActualTypeParameters(builder, type);
        }
        return builder.toString();
    }

    public final StringBuilder addActualTypeParameters(StringBuilder builder, Type type) {
        if (type instanceof ParameterizedType) {
            Type[] pTypes = ((ParameterizedType)type).getActualTypeArguments();
            builder.append("<");
            String _parameters = this.getParameters(pTypes);
            builder.append(_parameters);
            builder.append(">");
        }
        return builder;
    }

    public final String getParameters(Type[] pTypes) {
        int _length;
        boolean _equals_1;
        boolean _or = false;
        boolean _equals = Objects.equal((Object)pTypes, null);
        _or = _equals ? true : (_equals_1 = (_length = pTypes.length) == 0);
        if (_or) {
            return "?";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Type pType : pTypes) {
            boolean _equals_2;
            Type t = pTypes[i];
            String separator = ",";
            int _length_1 = pTypes.length;
            int _minus = _length_1 - 1;
            boolean bl = _equals_2 = i == _minus;
            if (_equals_2) {
                separator = "";
            }
            String wildcardParam = "";
            ConcreteType _voidType = Types.voidType();
            boolean _equals_3 = t.equals(_voidType);
            if (_equals_3) {
                builder.append("java.lang.Void" + separator);
                continue;
            }
            if (t instanceof WildcardType) {
                wildcardParam = "? extends ";
            }
            String _explicitType = this.getExplicitType(t);
            String _plus = wildcardParam + _explicitType;
            String _plus_1 = _plus + separator;
            builder.append(_plus_1);
            ++i;
        }
        return builder.toString();
    }

    private CharSequence generateSubInfo(Module module) {
        StringConcatenation _builder = new StringConcatenation();
        Set _submodules = module.getSubmodules();
        for (Module submodule : _submodules) {
            _builder.append((Object)"private static final class ");
            String _name = submodule.getName();
            String _className = BindingMapping.getClassName((String)_name);
            _builder.append((Object)_className, "");
            _builder.append((Object)"Info implements ");
            String _importedName = this.importedName(YangModuleInfo.class);
            _builder.append((Object)_importedName, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"private static final ");
            String _importedName_1 = this.importedName(YangModuleInfo.class);
            _builder.append((Object)_importedName_1, "    ");
            _builder.append((Object)" INSTANCE = new ");
            String _name_1 = submodule.getName();
            String _className_1 = BindingMapping.getClassName((String)_name_1);
            _builder.append((Object)_className_1, "    ");
            _builder.append((Object)"Info();");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"private final ");
            String _importedName_2 = this.importedName(String.class);
            _builder.append((Object)_importedName_2, "    ");
            _builder.append((Object)" name = \"");
            String _name_2 = submodule.getName();
            _builder.append((Object)_name_2, "    ");
            _builder.append((Object)"\";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"private final ");
            String _importedName_3 = this.importedName(String.class);
            _builder.append((Object)_importedName_3, "    ");
            _builder.append((Object)" namespace = \"");
            URI _namespace = submodule.getNamespace();
            String _string = _namespace.toString();
            _builder.append((Object)_string, "    ");
            _builder.append((Object)"\";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"private final ");
            String _importedName_4 = this.importedName(String.class);
            _builder.append((Object)_importedName_4, "    ");
            _builder.append((Object)" revision = \"");
            Date _revision = submodule.getRevision();
            String _format = df.format(_revision);
            _builder.append((Object)_format, "    ");
            _builder.append((Object)"\";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"private final ");
            String _importedName_5 = this.importedName(String.class);
            _builder.append((Object)_importedName_5, "    ");
            _builder.append((Object)" resourcePath = \"/");
            String _moduleSourcePath = submodule.getModuleSourcePath();
            String _replace = _moduleSourcePath.replace(File.separatorChar, '/');
            _builder.append((Object)_replace, "    ");
            _builder.append((Object)"\";");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"private final ");
            String _importedName_6 = this.importedName(Set.class);
            _builder.append((Object)_importedName_6, "    ");
            _builder.append((Object)"<YangModuleInfo> importedModules;");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"public static ");
            String _importedName_7 = this.importedName(YangModuleInfo.class);
            _builder.append((Object)_importedName_7, "    ");
            _builder.append((Object)" getInstance() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        ");
            _builder.append((Object)"return INSTANCE;");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"    ");
            String _name_3 = submodule.getName();
            String _plus = _name_3 + "Info";
            String _className_2 = BindingMapping.getClassName((String)_plus);
            CharSequence _classBody = this.classBody(submodule, _className_2);
            _builder.append((Object)_classBody, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    @Pure
    public String getPackageName() {
        return this._packageName;
    }

    @Pure
    public String getModelBindingProviderName() {
        return this._modelBindingProviderName;
    }
}

