/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.opendaylight.yangtools.sal.binding.model.api.AccessModifier;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.sal.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.java.api.generator.ClassTemplate;

public class UnionBuilderTemplate
extends ClassTemplate {
    public UnionBuilderTemplate(GeneratedTransferObject genType) {
        super(genType);
    }

    @Override
    public CharSequence body() {
        StringConcatenation _builder = new StringConcatenation();
        String _clarification = this.getClarification();
        String _formatDataForJavaDoc = this.formatDataForJavaDoc(this.type, _clarification);
        String _wrapToDocumentation = this.wrapToDocumentation(_formatDataForJavaDoc);
        _builder.append((Object)_wrapToDocumentation, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public class ");
        String _name = this.type.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateMethods = this.generateMethods();
        _builder.append((Object)_generateMethods, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateMethods() {
        StringConcatenation _builder = new StringConcatenation();
        List _methodDefinitions = this.genTO.getMethodDefinitions();
        for (MethodSignature method : _methodDefinitions) {
            boolean _isFinal;
            AccessModifier _accessModifier = method.getAccessModifier();
            String _accessModifier_1 = this.getAccessModifier(_accessModifier);
            _builder.append((Object)_accessModifier_1, "");
            boolean _isStatic = method.isStatic();
            if (_isStatic) {
                _builder.append((Object)"static");
            }
            if (_isFinal = method.isFinal()) {
                _builder.append((Object)" final");
            }
            _builder.append((Object)" ");
            Type _returnType = method.getReturnType();
            String _importedName = this.importedName(_returnType);
            _builder.append((Object)_importedName, "");
            _builder.append((Object)" ");
            String _name = method.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"(");
            List _parameters = method.getParameters();
            CharSequence _generateParameters = this.generateParameters(_parameters);
            _builder.append((Object)_generateParameters, "");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"throw new ");
            String _importedName_1 = this.importedName(UnsupportedOperationException.class);
            _builder.append((Object)_importedName_1, "    ");
            _builder.append((Object)"(\"Not yet implemented\");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    private String getAccessModifier(AccessModifier modifier) {
        if (modifier != null) {
            switch (modifier) {
                case PUBLIC: {
                    return "public ";
                }
                case PROTECTED: {
                    return "protected ";
                }
                case PRIVATE: {
                    return "private ";
                }
            }
            return "";
        }
        return "";
    }

    private String getClarification() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"The purpose of generated class in src/main/java for Union types is to create new instances of unions from a string representation.");
        _builder.newLine();
        _builder.append((Object)"In some cases it is very difficult to automate it since there can be unions such as (uint32 - uint16), or (string - uint32).");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"The reason behind putting it under src/main/java is:");
        _builder.newLine();
        _builder.append((Object)"This class is generated in form of a stub and needs to be finished by the user. This class is generated only once to prevent");
        _builder.newLine();
        _builder.append((Object)"loss of user code.");
        _builder.newLine();
        return _builder.toString();
    }
}

