/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.sal.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.sal.binding.model.api.Type;

final class TypeUtils {
    private static final String VALUE_PROP = "value";

    private TypeUtils() {
        throw new UnsupportedOperationException();
    }

    static ConcreteType getBaseYangType(@Nonnull Type type) {
        if (type instanceof ConcreteType) {
            return (ConcreteType)type;
        }
        Preconditions.checkArgument((boolean)(type instanceof GeneratedTransferObject), (String)"Unsupported type %s", (Object[])new Object[]{type});
        GeneratedTransferObject rootGto = (GeneratedTransferObject)type;
        while (rootGto.getSuperType() != null) {
            rootGto = rootGto.getSuperType();
        }
        for (GeneratedProperty s : rootGto.getProperties()) {
            if (!VALUE_PROP.equals(s.getName())) continue;
            return (ConcreteType)s.getReturnType();
        }
        throw new IllegalArgumentException(String.format("Type %s root %s properties %s do not include \"%s\"", type, rootGto, rootGto.getProperties(), VALUE_PROP));
    }
}

