/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.java.api.generator.TypeUtils;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;

final class LengthGenerator {
    private LengthGenerator() {
        throw new UnsupportedOperationException();
    }

    private static String lengthCheckerName(String member) {
        return "check" + member + "Length";
    }

    private static final Collection<String> createExpressions(Collection<LengthConstraint> constraints) {
        ArrayList<String> ret = new ArrayList<String>(constraints.size());
        for (LengthConstraint l : constraints) {
            StringBuilder sb = new StringBuilder("length >");
            if (l.getMin().longValue() <= Integer.MAX_VALUE) {
                sb.append('=');
            }
            sb.append(' ').append(l.getMin().intValue());
            int max = l.getMax().intValue();
            if (max < Integer.MAX_VALUE) {
                sb.append(" && length <= ").append(max);
            }
            ret.add(sb.toString());
        }
        return ret;
    }

    private static String createLengthString(Collection<LengthConstraint> constraints) {
        ArrayList<Range> ranges = new ArrayList<Range>(constraints.size());
        for (LengthConstraint c : constraints) {
            ranges.add(Range.closed((Comparable)new BigInteger(c.getMin().toString()), (Comparable)new BigInteger(c.getMax().toString())));
        }
        return ((Object)ranges).toString();
    }

    private static String generateArrayLengthChecker(String member, Collection<LengthConstraint> constraints) {
        StringBuilder sb = new StringBuilder();
        Collection<String> expressions = LengthGenerator.createExpressions(constraints);
        sb.append("private static void ").append(LengthGenerator.lengthCheckerName(member)).append("(final byte[] value) {\n");
        if (!expressions.isEmpty()) {
            sb.append("    final int length = value.length;\n");
            for (String exp : expressions) {
                sb.append("    if (").append(exp).append(") {\n");
                sb.append("        return;\n");
                sb.append("    }\n");
            }
            sb.append("    throw new IllegalArgumentException(String.format(\"Invalid length: %s, expected: ").append(LengthGenerator.createLengthString(constraints)).append(".\", java.util.Arrays.toString(value)));\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static String generateStringLengthChecker(String member, Collection<LengthConstraint> constraints) {
        StringBuilder sb = new StringBuilder();
        Collection<String> expressions = LengthGenerator.createExpressions(constraints);
        sb.append("private static void ").append(LengthGenerator.lengthCheckerName(member)).append("(final String value) {\n");
        if (!expressions.isEmpty()) {
            sb.append("    final int length = value.length();\n");
            for (String exp : expressions) {
                sb.append("    if (").append(exp).append(") {\n");
                sb.append("        return;\n");
                sb.append("    }\n");
            }
            sb.append("    throw new IllegalArgumentException(String.format(\"Invalid length: %s, expected: ").append(LengthGenerator.createLengthString(constraints)).append(".\", value));\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    static String generateLengthChecker(String member, Type type, Collection<LengthConstraint> constraints) {
        if (TypeUtils.getBaseYangType(type).getName().contains("[")) {
            return LengthGenerator.generateArrayLengthChecker(member, constraints);
        }
        return LengthGenerator.generateStringLengthChecker(member, constraints);
    }

    static String generateLengthCheckerCall(@Nullable String member, @Nonnull String valueReference) {
        return LengthGenerator.lengthCheckerName(member) + '(' + valueReference + ");\n";
    }
}

