/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.opendaylight.yangtools.sal.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.sal.binding.model.api.Constant;
import org.opendaylight.yangtools.sal.binding.model.api.Enumeration;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.sal.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.java.api.generator.BaseTemplate;
import org.opendaylight.yangtools.sal.java.api.generator.ClassTemplate;
import org.opendaylight.yangtools.sal.java.api.generator.EnumTemplate;
import org.opendaylight.yangtools.sal.java.api.generator.UnionTemplate;

public class InterfaceTemplate
extends BaseTemplate {
    private final List<Constant> consts;
    private final List<MethodSignature> methods;
    private final List<Enumeration> enums;
    private final List<GeneratedType> enclosedGeneratedTypes;

    public InterfaceTemplate(GeneratedType genType) {
        super(genType);
        List _enclosedTypes;
        List _enumerations;
        List _methodDefinitions;
        List _constantDefinitions;
        boolean _equals = Objects.equal((Object)genType, null);
        if (_equals) {
            throw new IllegalArgumentException("Generated type reference cannot be NULL!");
        }
        this.consts = _constantDefinitions = genType.getConstantDefinitions();
        this.methods = _methodDefinitions = genType.getMethodDefinitions();
        this.enums = _enumerations = genType.getEnumerations();
        this.enclosedGeneratedTypes = _enclosedTypes = genType.getEnclosedTypes();
    }

    @Override
    public CharSequence body() {
        StringConcatenation _builder = new StringConcatenation();
        String _formatDataForJavaDoc = this.formatDataForJavaDoc(this.type);
        String _wrapToDocumentation = this.wrapToDocumentation(_formatDataForJavaDoc);
        _builder.append((Object)_wrapToDocumentation, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public interface ");
        String _name = this.type.getName();
        _builder.append((Object)_name, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        CharSequence _superInterfaces = this.superInterfaces();
        _builder.append((Object)_superInterfaces, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateInnerClasses = this.generateInnerClasses();
        _builder.append((Object)_generateInnerClasses, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateEnums = this.generateEnums();
        _builder.append((Object)_generateEnums, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateConstants = this.generateConstants();
        _builder.append((Object)_generateConstants, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateMethods = this.generateMethods();
        _builder.append((Object)_generateMethods, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateAnnotations(List<AnnotationType> annotations) {
        boolean _isEmpty;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal(annotations, null);
        _and = !_notEquals ? false : (_not = !(_isEmpty = annotations.isEmpty()));
        if (_and) {
            for (AnnotationType annotation : annotations) {
                List _parameters_1;
                boolean _isEmpty_1;
                boolean _not_1;
                boolean _notEquals_1;
                _builder.append((Object)"@");
                String _importedName = this.importedName((Type)annotation);
                _builder.append((Object)_importedName, "");
                _builder.newLineIfNotEmpty();
                boolean _and_1 = false;
                List _parameters = annotation.getParameters();
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_parameters, null);
                _and_1 = !_notEquals_1 ? false : (_not_1 = !(_isEmpty_1 = (_parameters_1 = annotation.getParameters()).isEmpty()));
                if (!_and_1) continue;
                _builder.append((Object)"(");
                _builder.newLine();
                List _parameters_2 = annotation.getParameters();
                boolean _hasElements = false;
                for (AnnotationType.Parameter param : _parameters_2) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)",", "");
                    }
                    String _name = param.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)"=");
                    String _value = param.getValue();
                    _builder.append((Object)_value, "");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)")");
                _builder.newLine();
            }
        }
        return _builder;
    }

    private CharSequence superInterfaces() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        List _implements = this.type.getImplements();
        boolean _isEmpty = _implements.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)"extends");
            _builder.newLine();
            List _implements_1 = this.type.getImplements();
            boolean _hasElements = false;
            for (Type type : _implements_1) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "");
                }
                String _importedName = this.importedName(type);
                _builder.append((Object)_importedName, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence generateInnerClasses() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.enclosedGeneratedTypes.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (GeneratedType innerClass : this.enclosedGeneratedTypes) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n", "");
                }
                if (!(innerClass instanceof GeneratedTransferObject)) continue;
                boolean _isUnionType = ((GeneratedTransferObject)innerClass).isUnionType();
                if (_isUnionType) {
                    UnionTemplate unionTemplate = new UnionTemplate((GeneratedTransferObject)innerClass);
                    _builder.newLineIfNotEmpty();
                    CharSequence _generateAsInnerClass = unionTemplate.generateAsInnerClass();
                    _builder.append((Object)_generateAsInnerClass, "");
                    _builder.newLineIfNotEmpty();
                    this.importMap.putAll(unionTemplate.importMap);
                    _builder.newLineIfNotEmpty();
                } else {
                    ClassTemplate classTemplate = new ClassTemplate((GeneratedTransferObject)innerClass);
                    _builder.newLineIfNotEmpty();
                    CharSequence _generateAsInnerClass_1 = classTemplate.generateAsInnerClass();
                    _builder.append((Object)_generateAsInnerClass_1, "");
                    _builder.newLineIfNotEmpty();
                    this.importMap.putAll(classTemplate.importMap);
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
            }
        }
        return _builder;
    }

    private CharSequence generateEnums() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.enums.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (Enumeration e : this.enums) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n", "");
                }
                EnumTemplate enumTemplate = new EnumTemplate(e);
                _builder.newLineIfNotEmpty();
                CharSequence _generateAsInnerClass = enumTemplate.generateAsInnerClass();
                _builder.append((Object)_generateAsInnerClass, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence generateConstants() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.consts.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            for (Constant c : this.consts) {
                String _name = c.getName();
                boolean _notEquals = !Objects.equal((Object)_name, (Object)"PATTERN_CONSTANTS");
                if (!_notEquals) continue;
                _builder.append((Object)"public static final ");
                Type _type = c.getType();
                String _importedName = this.importedName(_type);
                _builder.append((Object)_importedName, "");
                _builder.append((Object)" ");
                String _name_1 = c.getName();
                _builder.append((Object)_name_1, "");
                _builder.append((Object)" = ");
                Object _value = c.getValue();
                _builder.append(_value, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence generateMethods() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.methods.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (MethodSignature m : this.methods) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n", "");
                }
                String _comment = m.getComment();
                CharSequence _asJavadoc = this.asJavadoc(_comment);
                _builder.append((Object)_asJavadoc, "");
                _builder.newLineIfNotEmpty();
                List _annotations = m.getAnnotations();
                CharSequence _generateAnnotations = this.generateAnnotations(_annotations);
                _builder.append((Object)_generateAnnotations, "");
                _builder.newLineIfNotEmpty();
                Type _returnType = m.getReturnType();
                String _importedName = this.importedName(_returnType);
                _builder.append((Object)_importedName, "");
                _builder.append((Object)" ");
                String _name = m.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"(");
                List _parameters = m.getParameters();
                CharSequence _generateParameters = this.generateParameters(_parameters);
                _builder.append((Object)_generateParameters, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }
}

