/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.binding.generator.util.Types;
import org.opendaylight.yangtools.sal.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.sal.binding.model.api.Constant;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.sal.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.sal.binding.model.api.ParameterizedType;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.WildcardType;

public final class GeneratorUtil {
    private GeneratorUtil() {
        throw new UnsupportedOperationException();
    }

    public static Map<String, String> createImports(GeneratedType genType) {
        GeneratedTransferObject genTO;
        List properties;
        List methods;
        if (genType == null) {
            throw new IllegalArgumentException("Generated Type cannot be NULL!");
        }
        LinkedHashMap<String, String> imports = new LinkedHashMap<String, String>();
        List childGeneratedTypes = genType.getEnclosedTypes();
        if (!childGeneratedTypes.isEmpty()) {
            for (GeneratedType genTypeChild : childGeneratedTypes) {
                imports.putAll(GeneratorUtil.createImports(genTypeChild));
            }
        }
        if (genType instanceof GeneratedTransferObject && GeneratorUtil.isConstantInTO("PATTERN_CONSTANTS", (GeneratedTransferObject)genType)) {
            GeneratorUtil.putTypeIntoImports(genType, (Type)Types.typeForClass(Pattern.class), imports);
            GeneratorUtil.putTypeIntoImports(genType, (Type)Types.typeForClass(Arrays.class), imports);
            GeneratorUtil.putTypeIntoImports(genType, (Type)Types.typeForClass(ArrayList.class), imports);
        }
        if ((methods = genType.getMethodDefinitions()) != null) {
            for (MethodSignature method : methods) {
                Type methodReturnType = method.getReturnType();
                GeneratorUtil.putTypeIntoImports(genType, methodReturnType, imports);
                for (MethodSignature.Parameter methodParam : method.getParameters()) {
                    GeneratorUtil.putTypeIntoImports(genType, methodParam.getType(), imports);
                }
                for (AnnotationType at : method.getAnnotations()) {
                    GeneratorUtil.putTypeIntoImports(genType, (Type)at, imports);
                }
            }
        }
        if (genType instanceof GeneratedTransferObject && (properties = (genTO = (GeneratedTransferObject)genType).getProperties()) != null) {
            for (GeneratedProperty property : properties) {
                Type propertyType = property.getReturnType();
                GeneratorUtil.putTypeIntoImports(genType, propertyType, imports);
            }
        }
        return imports;
    }

    public static void putTypeIntoImports(GeneratedType parentGenType, Type type, Map<String, String> imports) {
        ParameterizedType paramType;
        Type[] params;
        Preconditions.checkArgument((parentGenType != null ? 1 : 0) != 0, (Object)"Parent Generated Type parameter MUST be specified and cannot be NULL!");
        Preconditions.checkArgument((parentGenType.getName() != null ? 1 : 0) != 0, (Object)"Parent Generated Type name cannot be NULL!");
        Preconditions.checkArgument((parentGenType.getPackageName() != null ? 1 : 0) != 0, (Object)"Parent Generated Type cannot have Package Name referenced as NULL!");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type parameter MUST be specified and cannot be NULL!");
        Preconditions.checkArgument((type.getName() != null ? 1 : 0) != 0, (Object)"Type name cannot be NULL!");
        Preconditions.checkArgument((type.getPackageName() != null ? 1 : 0) != 0, (Object)"Type cannot have Package Name referenced as NULL!");
        String typeName = type.getName();
        String typePackageName = type.getPackageName();
        String parentTypeName = parentGenType.getName();
        if (typeName.equals(parentTypeName) || typePackageName.startsWith("java.lang") || typePackageName.isEmpty()) {
            return;
        }
        if (!imports.containsKey(typeName)) {
            imports.put(typeName, typePackageName);
        }
        if (type instanceof ParameterizedType && (params = (paramType = (ParameterizedType)type).getActualTypeArguments()) != null) {
            for (Type param : params) {
                GeneratorUtil.putTypeIntoImports(parentGenType, param, imports);
            }
        }
    }

    public static boolean isConstantInTO(String constName, GeneratedTransferObject genTO) {
        if (constName == null || genTO == null) {
            throw new IllegalArgumentException();
        }
        List consts = genTO.getConstantDefinitions();
        for (Constant cons : consts) {
            if (!cons.getName().equals(constName)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> createChildImports(GeneratedType genType) {
        LinkedHashMap<String, String> childImports = new LinkedHashMap<String, String>();
        List childGeneratedTypes = genType.getEnclosedTypes();
        if (!childGeneratedTypes.isEmpty()) {
            for (GeneratedType genTypeChild : childGeneratedTypes) {
                GeneratorUtil.createChildImports(genTypeChild);
                childImports.put(genTypeChild.getName(), genTypeChild.getPackageName());
            }
        }
        return childImports;
    }

    public static String getExplicitType(GeneratedType parentGenType, Type type, Map<String, String> imports) {
        StringBuilder builder;
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type parameter MUST be specified and cannot be NULL!");
        Preconditions.checkArgument((type.getName() != null ? 1 : 0) != 0, (Object)"Type name cannot be NULL!");
        Preconditions.checkArgument((type.getPackageName() != null ? 1 : 0) != 0, (Object)"Type cannot have Package Name referenced as NULL!");
        Preconditions.checkArgument((imports != null ? 1 : 0) != 0, (Object)"Imports Map cannot be NULL!");
        String typePackageName = type.getPackageName();
        String typeName = type.getName();
        String importedPackageName = imports.get(typeName);
        if (typePackageName.equals(importedPackageName)) {
            builder = new StringBuilder(type.getName());
            GeneratorUtil.addActualTypeParameters(builder, type, parentGenType, imports);
            if (builder.toString().equals("Void")) {
                return "void";
            }
        } else {
            builder = new StringBuilder();
            if (!typePackageName.isEmpty()) {
                builder.append(typePackageName + "." + type.getName());
            } else {
                builder.append(type.getName());
            }
            if (type.equals(Types.voidType())) {
                return "void";
            }
            GeneratorUtil.addActualTypeParameters(builder, type, parentGenType, imports);
        }
        return builder.toString();
    }

    private static StringBuilder addActualTypeParameters(StringBuilder builder, Type type, GeneratedType parentGenType, Map<String, String> imports) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type[] pTypes = pType.getActualTypeArguments();
            builder.append("<");
            builder.append(GeneratorUtil.getParameters(parentGenType, pTypes, imports));
            builder.append(">");
        }
        return builder;
    }

    private static String getParameters(GeneratedType parentGenType, Type[] pTypes, Map<String, String> availableImports) {
        if (pTypes == null || pTypes.length == 0) {
            return "?";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < pTypes.length; ++i) {
            Type t = pTypes[i];
            String separator = ",";
            if (i == pTypes.length - 1) {
                separator = "";
            }
            String wildcardParam = "";
            if (t.equals(Types.voidType())) {
                builder.append("java.lang.Void" + separator);
                continue;
            }
            if (t instanceof WildcardType) {
                wildcardParam = "? extends ";
            }
            builder.append(wildcardParam + GeneratorUtil.getExplicitType(parentGenType, t, availableImports) + separator);
        }
        return builder.toString();
    }

    public static GeneratedTransferObject getTopParrentTransportObject(GeneratedTransferObject childTransportObject) {
        if (childTransportObject == null) {
            throw new IllegalArgumentException("Parameter childTransportObject can't be null.");
        }
        if (childTransportObject.getSuperType() == null) {
            return childTransportObject;
        }
        return GeneratorUtil.getTopParrentTransportObject(childTransportObject.getSuperType());
    }

    public static List<GeneratedProperty> resolveReadOnlyPropertiesFromTO(List<GeneratedProperty> properties) {
        ArrayList<GeneratedProperty> readOnlyProperties = new ArrayList<GeneratedProperty>();
        if (properties != null) {
            for (GeneratedProperty property : properties) {
                if (!property.isReadOnly()) continue;
                readOnlyProperties.add(property);
            }
        }
        return readOnlyProperties;
    }

    public static List<GeneratedProperty> getPropertiesOfAllParents(GeneratedTransferObject genTO) {
        ArrayList<GeneratedProperty> propertiesOfAllParents = new ArrayList<GeneratedProperty>();
        if (genTO.getSuperType() != null) {
            List allPropertiesOfTO = genTO.getSuperType().getProperties();
            List<GeneratedProperty> readOnlyPropertiesOfTO = GeneratorUtil.resolveReadOnlyPropertiesFromTO(allPropertiesOfTO);
            propertiesOfAllParents.addAll(readOnlyPropertiesOfTO);
            propertiesOfAllParents.addAll(GeneratorUtil.getPropertiesOfAllParents(genTO.getSuperType()));
        }
        return propertiesOfAllParents;
    }
}

