/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opendaylight.yangtools.sal.binding.model.api.CodeGenerator;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.java.api.generator.BuilderGenerator;
import org.opendaylight.yangtools.sal.java.api.generator.EnumGenerator;
import org.opendaylight.yangtools.sal.java.api.generator.InterfaceGenerator;
import org.opendaylight.yangtools.sal.java.api.generator.TOGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

public final class GeneratorJavaFile {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorJavaFile.class);
    private final List<CodeGenerator> generators = new ArrayList<CodeGenerator>();
    private final Collection<? extends Type> types;
    private final BuildContext buildContext;

    public GeneratorJavaFile(BuildContext buildContext, Collection<? extends Type> types) {
        this.buildContext = (BuildContext)Preconditions.checkNotNull((Object)buildContext);
        this.types = (Collection)Preconditions.checkNotNull(types);
        this.generators.add(new InterfaceGenerator());
        this.generators.add(new TOGenerator());
        this.generators.add(new EnumGenerator());
        this.generators.add(new BuilderGenerator());
    }

    public GeneratorJavaFile(Collection<? extends Type> types) {
        this((BuildContext)new DefaultBuildContext(), types);
    }

    public List<File> generateToFile(File generatedSourcesDirectory) throws IOException {
        return this.generateToFile(generatedSourcesDirectory, generatedSourcesDirectory);
    }

    public List<File> generateToFile(File generatedSourcesDirectory, File persistenSourcesDirectory) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        for (Type type : this.types) {
            if (type == null) continue;
            for (CodeGenerator generator : this.generators) {
                File generatedJavaFile = null;
                if (type instanceof GeneratedTransferObject && ((GeneratedTransferObject)type).isUnionTypeBuilder()) {
                    File packageDir = GeneratorJavaFile.packageToDirectory(persistenSourcesDirectory, type.getPackageName());
                    File file = new File(packageDir, generator.getUnitName(type) + ".java");
                    if (!file.exists()) {
                        generatedJavaFile = this.generateTypeToJavaFile(persistenSourcesDirectory, type, generator);
                    }
                } else {
                    generatedJavaFile = this.generateTypeToJavaFile(generatedSourcesDirectory, type, generator);
                }
                if (generatedJavaFile == null) continue;
                result.add(generatedJavaFile);
            }
        }
        return result;
    }

    private File generateTypeToJavaFile(File parentDir, Type type, CodeGenerator generator) throws IOException {
        if (parentDir == null) {
            LOG.warn("Parent Directory not specified, files will be generated accordingly to generated Type package path.");
        }
        if (type == null) {
            LOG.error("Cannot generate Type into Java File because Generated Type is NULL!");
            throw new IllegalArgumentException("Generated Type Cannot be NULL!");
        }
        if (generator == null) {
            LOG.error("Cannot generate Type into Java File because Code Generator instance is NULL!");
            throw new IllegalArgumentException("Code Generator Cannot be NULL!");
        }
        File packageDir = GeneratorJavaFile.packageToDirectory(parentDir, type.getPackageName());
        if (!packageDir.exists()) {
            packageDir.mkdirs();
        }
        if (generator.isAcceptable(type)) {
            String generatedCode = generator.generate(type);
            if (generatedCode.isEmpty()) {
                throw new IllegalStateException("Generated code should not be empty!");
            }
            File file = new File(packageDir, generator.getUnitName(type) + ".java");
            if (file.exists()) {
                LOG.warn("Naming conflict for type '{}': file with same name already exists and will not be generated.", (Object)type.getFullyQualifiedName());
                return null;
            }
            try (OutputStream stream = this.buildContext.newFileOutputStream(file);){
                try (OutputStreamWriter fw = new OutputStreamWriter(stream);
                     BufferedWriter bw = new BufferedWriter(fw);){
                    bw.write(generatedCode);
                }
                catch (IOException e) {
                    LOG.error("Failed to write generate output into {}", (Object)file.getPath(), (Object)e);
                    throw e;
                }
            }
            return file;
        }
        return null;
    }

    public static File packageToDirectory(File parentDirectory, String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("Package Name cannot be NULL!");
        }
        String[] subDirNames = packageName.split("\\.");
        StringBuilder dirPathBuilder = new StringBuilder();
        dirPathBuilder.append(subDirNames[0]);
        for (int i = 1; i < subDirNames.length; ++i) {
            dirPathBuilder.append(File.separator);
            dirPathBuilder.append(subDirNames[i]);
        }
        return new File(parentDirectory, dirPathBuilder.toString());
    }
}

