/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.opendaylight.yangtools.sal.binding.model.api.Enumeration;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.sal.java.api.generator.BaseTemplate;

public class EnumTemplate
extends BaseTemplate {
    private final Enumeration enums;

    public EnumTemplate(Enumeration enums) {
        super((GeneratedType)enums);
        this.enums = enums;
    }

    public CharSequence generateAsInnerClass() {
        return this.body();
    }

    public CharSequence writeEnumItem(String name, int value, String description) {
        StringConcatenation _builder = new StringConcatenation();
        String _formatToParagraph = this.formatToParagraph(description);
        CharSequence _asJavadoc = this.asJavadoc(_formatToParagraph);
        _builder.append((Object)_asJavadoc, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)name, "");
        _builder.append((Object)"(");
        _builder.append((Object)value, "");
        _builder.append((Object)")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Override
    public CharSequence body() {
        StringConcatenation _builder = new StringConcatenation();
        String _formatDataForJavaDoc = this.formatDataForJavaDoc((GeneratedType)this.enums);
        String _wrapToDocumentation = this.wrapToDocumentation(_formatDataForJavaDoc);
        _builder.append((Object)_wrapToDocumentation, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public enum ");
        String _name = this.enums.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        CharSequence _writeEnumeration = this.writeEnumeration(this.enums);
        _builder.append((Object)_writeEnumeration, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"int value;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private static final java.util.Map<java.lang.Integer, ");
        String _name_1 = this.enums.getName();
        _builder.append((Object)_name_1, "    ");
        _builder.append((Object)"> VALUE_MAP;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"static {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, ");
        String _name_2 = this.enums.getName();
        _builder.append((Object)_name_2, "        ");
        _builder.append((Object)"> b = com.google.common.collect.ImmutableMap.builder();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"for (");
        String _name_3 = this.enums.getName();
        _builder.append((Object)_name_3, "        ");
        _builder.append((Object)" enumItem : ");
        String _name_4 = this.enums.getName();
        _builder.append((Object)_name_4, "        ");
        _builder.append((Object)".values())");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"b.put(enumItem.value, enumItem);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"VALUE_MAP = b.build();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private ");
        String _name_5 = this.enums.getName();
        _builder.append((Object)_name_5, "    ");
        _builder.append((Object)"(int value) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"this.value = value;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @return integer value");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public int getIntValue() {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return value;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @param valueArg");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @return corresponding ");
        String _name_6 = this.enums.getName();
        _builder.append((Object)_name_6, "     ");
        _builder.append((Object)" item");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static ");
        String _name_7 = this.enums.getName();
        _builder.append((Object)_name_7, "    ");
        _builder.append((Object)" forValue(int valueArg) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"return VALUE_MAP.get(valueArg);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence writeEnumeration(Enumeration enumeration) {
        StringConcatenation _builder = new StringConcatenation();
        List _values = enumeration.getValues();
        boolean _hasElements = false;
        for (Enumeration.Pair v : _values) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",\n", "");
            }
            String _name = v.getName();
            Integer _value = v.getValue();
            String _description = v.getDescription();
            CharSequence _writeEnumItem = this.writeEnumItem(_name, _value, _description);
            _builder.append((Object)_writeEnumItem, "");
        }
        if (_hasElements) {
            _builder.append((Object)";", "");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }
}

