/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.io.BaseEncoding;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.opendaylight.yangtools.sal.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.sal.binding.model.api.Constant;
import org.opendaylight.yangtools.sal.binding.model.api.Enumeration;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.sal.binding.model.api.Restrictions;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.java.api.generator.AbstractRangeGenerator;
import org.opendaylight.yangtools.sal.java.api.generator.BaseTemplate;
import org.opendaylight.yangtools.sal.java.api.generator.EnumTemplate;
import org.opendaylight.yangtools.sal.java.api.generator.GeneratorUtil;
import org.opendaylight.yangtools.sal.java.api.generator.LengthGenerator;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;

public class ClassTemplate
extends BaseTemplate {
    protected final List<GeneratedProperty> properties;
    protected final List<GeneratedProperty> finalProperties;
    protected final List<GeneratedProperty> parentProperties;
    protected final Iterable<GeneratedProperty> allProperties;
    protected final Restrictions restrictions;
    protected final List<Enumeration> enums;
    protected final List<Constant> consts;
    protected final List<GeneratedType> enclosedGeneratedTypes;
    protected final GeneratedTransferObject genTO;
    private final AbstractRangeGenerator<?> rangeGenerator;

    public ClassTemplate(GeneratedTransferObject genType) {
        super((GeneratedType)genType);
        List _rangeConstraints;
        boolean _isNullOrEmpty;
        boolean _not;
        boolean _notEquals;
        List _enclosedTypes;
        List _constantDefinitions;
        List _enumerations;
        Restrictions _restrictions;
        List _properties;
        this.genTO = genType;
        this.properties = _properties = genType.getProperties();
        List _properties_1 = this.genTO.getProperties();
        List<GeneratedProperty> _resolveReadOnlyPropertiesFromTO = GeneratorUtil.resolveReadOnlyPropertiesFromTO(_properties_1);
        this.finalProperties = _resolveReadOnlyPropertiesFromTO;
        List<GeneratedProperty> _propertiesOfAllParents = GeneratorUtil.getPropertiesOfAllParents(this.genTO);
        this.parentProperties = _propertiesOfAllParents;
        this.restrictions = _restrictions = genType.getRestrictions();
        ArrayList<GeneratedProperty> sorted = new ArrayList<GeneratedProperty>();
        sorted.addAll(this.properties);
        sorted.addAll(this.parentProperties);
        Comparator<GeneratedProperty> _function = new Comparator<GeneratedProperty>(){

            @Override
            public int compare(GeneratedProperty p1, GeneratedProperty p2) {
                String _name = p1.getName();
                String _name_1 = p2.getName();
                return _name.compareTo(_name_1);
            }
        };
        Collections.sort(sorted, _function);
        this.allProperties = sorted;
        this.enums = _enumerations = genType.getEnumerations();
        this.consts = _constantDefinitions = genType.getConstantDefinitions();
        this.enclosedGeneratedTypes = _enclosedTypes = genType.getEnclosedTypes();
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal((Object)this.restrictions, null);
        _and = !_notEquals ? false : (_not = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)(_rangeConstraints = this.restrictions.getRangeConstraints()))));
        if (_and) {
            GeneratedProperty _findProperty = this.findProperty(genType, "value");
            Type _returnType = _findProperty.getReturnType();
            AbstractRangeGenerator<?> _forType = AbstractRangeGenerator.forType(_returnType);
            this.rangeGenerator = _forType;
            Preconditions.checkNotNull(this.rangeGenerator);
        } else {
            this.rangeGenerator = null;
        }
    }

    public CharSequence generateAsInnerClass() {
        return this.generateBody(true);
    }

    @Override
    protected CharSequence body() {
        return this.generateBody(false);
    }

    protected CharSequence generateBody(boolean isInnerClass) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _formatDataForJavaDoc = this.formatDataForJavaDoc(this.type);
        String _wrapToDocumentation = this.wrapToDocumentation(_formatDataForJavaDoc);
        _builder.append((Object)_wrapToDocumentation, "");
        _builder.newLineIfNotEmpty();
        CharSequence _generateClassDeclaration = this.generateClassDeclaration(isInnerClass);
        _builder.append((Object)_generateClassDeclaration, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        CharSequence _suidDeclaration = this.suidDeclaration();
        _builder.append((Object)_suidDeclaration, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        CharSequence _innerClassesDeclarations = this.innerClassesDeclarations();
        _builder.append((Object)_innerClassesDeclarations, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        CharSequence _enumDeclarations = this.enumDeclarations();
        _builder.append((Object)_enumDeclarations, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        CharSequence _constantsDeclarations = this.constantsDeclarations();
        _builder.append((Object)_constantsDeclarations, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        CharSequence _generateFields = this.generateFields();
        _builder.append((Object)_generateFields, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean bl = _notEquals = !Objects.equal((Object)this.restrictions, null);
        if (_notEquals) {
            List _rangeConstraints;
            boolean _isNullOrEmpty_1;
            boolean _not_1;
            boolean _not;
            List _lengthConstraints = this.restrictions.getLengthConstraints();
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)_lengthConstraints);
            boolean bl2 = _not = !_isNullOrEmpty;
            if (_not) {
                _builder.append((Object)"    ");
                GeneratedProperty _findProperty = this.findProperty(this.genTO, "value");
                Type _returnType = _findProperty.getReturnType();
                List _lengthConstraints_1 = this.restrictions.getLengthConstraints();
                String _generateLengthChecker = LengthGenerator.generateLengthChecker("_value", _returnType, _lengthConstraints_1);
                _builder.append((Object)_generateLengthChecker, "    ");
                _builder.newLineIfNotEmpty();
            }
            boolean bl3 = _not_1 = !(_isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)(_rangeConstraints = this.restrictions.getRangeConstraints())));
            if (_not_1) {
                _builder.append((Object)"    ");
                List _rangeConstraints_1 = this.restrictions.getRangeConstraints();
                String _generateRangeChecker = this.rangeGenerator.generateRangeChecker("_value", _rangeConstraints_1);
                _builder.append((Object)_generateRangeChecker, "    ");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _constructors = this.constructors();
        _builder.append((Object)_constructors, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _defaultInstance = this.defaultInstance();
        _builder.append((Object)_defaultInstance, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _hasElements = false;
        for (GeneratedProperty field : this.properties) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"\n", "    ");
            }
            _builder.append((Object)"    ");
            CharSequence _terMethod = this.getterMethod(field);
            _builder.append((Object)_terMethod, "    ");
            _builder.newLineIfNotEmpty();
            boolean _isReadOnly = field.isReadOnly();
            boolean _not_2 = !_isReadOnly;
            if (!_not_2) continue;
            _builder.append((Object)"    ");
            CharSequence _setterMethod = this.setterMethod(field);
            _builder.append((Object)_setterMethod, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _and = false;
        boolean _isTypedef = this.genTO.isTypedef();
        if (!_isTypedef) {
            _and = false;
        } else {
            TypeDefinition _baseType = this.genTO.getBaseType();
            _and = _baseType instanceof BitsTypeDefinition;
        }
        if (_and) {
            _builder.append((Object)"    ");
            CharSequence _generateGetValueForBitsTypeDef = this.generateGetValueForBitsTypeDef();
            _builder.append((Object)_generateGetValueForBitsTypeDef, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateHashCode = this.generateHashCode();
        _builder.append((Object)_generateHashCode, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateEquals = this.generateEquals();
        _builder.append((Object)_generateEquals, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        List _toStringIdentifiers = this.genTO.getToStringIdentifiers();
        CharSequence _generateToString = this.generateToString(_toStringIdentifiers);
        _builder.append((Object)_generateToString, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateLengthMethod = this.generateLengthMethod();
        _builder.append((Object)_generateLengthMethod, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateRangeMethod = this.generateRangeMethod();
        _builder.append((Object)_generateRangeMethod, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateGetValueForBitsTypeDef() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"public boolean[] getValue() {");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"return new boolean[]{");
        _builder.newLine();
        List _properties = this.genTO.getProperties();
        boolean _hasElements = false;
        for (GeneratedProperty property : _properties) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "    ");
            }
            _builder.append((Object)"    ");
            CharSequence _fieldName = this.fieldName(property);
            _builder.append((Object)_fieldName, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"    ");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    @Deprecated
    private CharSequence generateLengthMethod() {
        List _lengthConstraints;
        boolean _isEmpty;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal((Object)this.restrictions, null);
        _and = !_notEquals ? false : (_not = !(_isEmpty = (_lengthConstraints = this.restrictions.getLengthConstraints()).isEmpty()));
        if (_and) {
            List _lengthConstraints_1 = this.restrictions.getLengthConstraints();
            Iterator _iterator = _lengthConstraints_1.iterator();
            LengthConstraint _next = (LengthConstraint)_iterator.next();
            Number _min = _next.getMin();
            Class<?> numberClass = _min.getClass();
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @deprecated This method is slated for removal in a future release. See BUG-1485 for details.");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"@Deprecated");
            _builder.newLine();
            _builder.append((Object)"public static ");
            String _importedName = this.importedName(List.class);
            _builder.append((Object)_importedName, "");
            _builder.append((Object)"<");
            String _importedName_1 = this.importedName(Range.class);
            _builder.append((Object)_importedName_1, "");
            _builder.append((Object)"<");
            String _importedNumber = this.importedNumber(numberClass);
            _builder.append((Object)_importedNumber, "");
            _builder.append((Object)">> length() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            String _importedName_2 = this.importedName(List.class);
            _builder.append((Object)_importedName_2, "    ");
            _builder.append((Object)"<");
            String _importedName_3 = this.importedName(Range.class);
            _builder.append((Object)_importedName_3, "    ");
            _builder.append((Object)"<");
            String _importedName_4 = this.importedName(numberClass);
            _builder.append((Object)_importedName_4, "    ");
            _builder.append((Object)">> ret = new java.util.ArrayList<>(");
            List _lengthConstraints_2 = this.restrictions.getLengthConstraints();
            int _size = _lengthConstraints_2.size();
            _builder.append((Object)_size, "    ");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            List _lengthConstraints_3 = this.restrictions.getLengthConstraints();
            for (LengthConstraint r : _lengthConstraints_3) {
                _builder.append((Object)"    ");
                _builder.append((Object)"ret.add(");
                String _importedName_5 = this.importedName(Range.class);
                _builder.append((Object)_importedName_5, "    ");
                _builder.append((Object)".closed(");
                Number _min_1 = r.getMin();
                String _numericValue = this.numericValue(numberClass, _min_1);
                _builder.append((Object)_numericValue, "    ");
                _builder.append((Object)", ");
                Number _max = r.getMax();
                String _numericValue_1 = this.numericValue(numberClass, _max);
                _builder.append((Object)_numericValue_1, "    ");
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"return ret;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    @Deprecated
    private CharSequence rangeBody(List<RangeConstraint> restrictions, Class<? extends Number> numberClass) {
        StringConcatenation _builder = new StringConcatenation();
        String _importedName = this.importedName(List.class);
        _builder.append((Object)_importedName, "");
        _builder.append((Object)"<");
        String _importedName_1 = this.importedName(Range.class);
        _builder.append((Object)_importedName_1, "");
        _builder.append((Object)"<");
        String _importedName_2 = this.importedName(numberClass);
        _builder.append((Object)_importedName_2, "");
        _builder.append((Object)">> ret = new java.util.ArrayList<>(");
        int _size = restrictions.size();
        _builder.append((Object)_size, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        for (RangeConstraint r : restrictions) {
            _builder.append((Object)"ret.add(");
            String _importedName_3 = this.importedName(Range.class);
            _builder.append((Object)_importedName_3, "");
            _builder.append((Object)".closed(");
            Number _min = r.getMin();
            String _numericValue = this.numericValue(numberClass, _min);
            _builder.append((Object)_numericValue, "");
            _builder.append((Object)", ");
            Number _max = r.getMax();
            String _numericValue_1 = this.numericValue(numberClass, _max);
            _builder.append((Object)_numericValue_1, "");
            _builder.append((Object)"));");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    @Deprecated
    private CharSequence generateRangeMethod() {
        List _rangeConstraints;
        boolean _isEmpty;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal((Object)this.restrictions, null);
        _and = !_notEquals ? false : (_not = !(_isEmpty = (_rangeConstraints = this.restrictions.getRangeConstraints()).isEmpty()));
        if (_and) {
            Iterator<GeneratedProperty> _iterator = this.allProperties.iterator();
            GeneratedProperty _next = _iterator.next();
            Type returnType = _next.getReturnType();
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @deprecated This method is slated for removal in a future release. See BUG-1485 for details.");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"@Deprecated");
            _builder.newLine();
            _builder.append((Object)"public static ");
            String _importedName = this.importedName(List.class);
            _builder.append((Object)_importedName, "");
            _builder.append((Object)"<");
            String _importedName_1 = this.importedName(Range.class);
            _builder.append((Object)_importedName_1, "");
            _builder.append((Object)"<");
            String _importedNumber = this.importedNumber(returnType);
            _builder.append((Object)_importedNumber, "");
            _builder.append((Object)">> range() {");
            _builder.newLineIfNotEmpty();
            String _fullyQualifiedName = returnType.getFullyQualifiedName();
            String _canonicalName = BigDecimal.class.getCanonicalName();
            boolean _equals = _fullyQualifiedName.equals(_canonicalName);
            if (_equals) {
                List _rangeConstraints_1 = this.restrictions.getRangeConstraints();
                CharSequence _rangeBody = this.rangeBody(_rangeConstraints_1, BigDecimal.class);
                _builder.append((Object)_rangeBody, "");
                _builder.newLineIfNotEmpty();
            } else {
                List _rangeConstraints_2 = this.restrictions.getRangeConstraints();
                CharSequence _rangeBody_1 = this.rangeBody(_rangeConstraints_2, BigInteger.class);
                _builder.append((Object)_rangeBody_1, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"return ret;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence innerClassesDeclarations() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.enclosedGeneratedTypes.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (GeneratedType innerClass : this.enclosedGeneratedTypes) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n", "");
                }
                if (!(innerClass instanceof GeneratedTransferObject)) continue;
                ClassTemplate classTemplate = new ClassTemplate((GeneratedTransferObject)innerClass);
                _builder.newLineIfNotEmpty();
                CharSequence _generateAsInnerClass = classTemplate.generateAsInnerClass();
                _builder.append((Object)_generateAsInnerClass, "");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
            }
        }
        return _builder;
    }

    protected CharSequence constructors() {
        boolean _isEmpty_2;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isUnionType = this.genTO.isUnionType();
        if (_isUnionType) {
            CharSequence _genUnionConstructor = this.genUnionConstructor();
            _builder.append((Object)_genUnionConstructor, "");
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _allValuesConstructor = this.allValuesConstructor();
            _builder.append((Object)_allValuesConstructor, "");
            _builder.newLineIfNotEmpty();
        }
        boolean _isEmpty = IterableExtensions.isEmpty(this.allProperties);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            CharSequence _copyConstructor = this.copyConstructor();
            _builder.append((Object)_copyConstructor, "");
            _builder.newLineIfNotEmpty();
        }
        boolean _and = false;
        boolean _isEmpty_1 = this.properties.isEmpty();
        _and = !_isEmpty_1 ? false : (_not_1 = !(_isEmpty_2 = this.parentProperties.isEmpty()));
        if (_and) {
            CharSequence _parentConstructor = this.parentConstructor();
            _builder.append((Object)_parentConstructor, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence allValuesConstructor() {
        int _size_1;
        boolean _equals_3;
        boolean _isEmpty_2;
        boolean _not_1;
        boolean _equals_2;
        int _size;
        boolean _equals;
        boolean _isEmpty;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        boolean _isTypedef = this.genTO.isTypedef();
        _and_2 = !_isTypedef ? false : (_not = !(_isEmpty = IterableExtensions.isEmpty(this.allProperties)));
        _and_1 = !_and_2 ? false : (_equals = (_size = IterableExtensions.size(this.allProperties)) == 1);
        if (!_and_1) {
            _and = false;
        } else {
            boolean _equals_1;
            GeneratedProperty _get = ((GeneratedProperty[])Conversions.unwrapArray(this.allProperties, GeneratedProperty.class))[0];
            String _name = _get.getName();
            _and = _equals_1 = _name.equals("value");
        }
        if (_and) {
            _builder.append((Object)"@");
            String _importedName = this.importedName(ConstructorProperties.class);
            _builder.append((Object)_importedName, "");
            _builder.append((Object)"(\"value\")");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"public ");
        String _name_1 = this.type.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"(");
        CharSequence _asArgumentsDeclaration = this.asArgumentsDeclaration(this.allProperties);
        _builder.append((Object)_asArgumentsDeclaration, "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty_1 = this.parentProperties.isEmpty();
        boolean bl = _equals_2 = false == _isEmpty_1;
        if (_equals_2) {
            _builder.append((Object)"    ");
            _builder.append((Object)"super(");
            CharSequence _asArguments = this.asArguments(this.parentProperties);
            _builder.append((Object)_asArguments, "    ");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        for (GeneratedProperty p : this.allProperties) {
            _builder.append((Object)"    ");
            CharSequence _fieldName = this.fieldName(p);
            String _string = _fieldName.toString();
            Type _returnType = p.getReturnType();
            CharSequence _generateRestrictions = this.generateRestrictions((Type)this.type, _string, _returnType);
            _builder.append((Object)_generateRestrictions, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _and_3 = false;
        boolean _and_4 = false;
        boolean _and_5 = false;
        boolean _isTypedef_1 = this.genTO.isTypedef();
        _and_5 = !_isTypedef_1 ? false : (_not_1 = !(_isEmpty_2 = IterableExtensions.isEmpty(this.allProperties)));
        _and_4 = !_and_5 ? false : (_equals_3 = (_size_1 = IterableExtensions.size(this.allProperties)) == 1);
        if (!_and_4) {
            _and_3 = false;
        } else {
            boolean _equals_4;
            GeneratedProperty _get_1 = ((GeneratedProperty[])Conversions.unwrapArray(this.allProperties, GeneratedProperty.class))[0];
            String _name_2 = _get_1.getName();
            _and_3 = _equals_4 = _name_2.equals("value");
        }
        if (_and_3) {
            _builder.newLine();
            _builder.append((Object)"    ");
            String _importedName_1 = this.importedName(Preconditions.class);
            _builder.append((Object)_importedName_1, "    ");
            _builder.append((Object)".checkNotNull(_value, \"Supplied value may not be null\");");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            for (Constant c : this.consts) {
                boolean _and_6 = false;
                String _name_3 = c.getName();
                boolean _equals_5 = Objects.equal((Object)_name_3, (Object)"PATTERN_CONSTANTS");
                if (!_equals_5) {
                    _and_6 = false;
                } else {
                    Object _value = c.getValue();
                    _and_6 = _value instanceof List;
                }
                if (!_and_6) continue;
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"for (Pattern p : patterns) {");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                String _importedName_2 = this.importedName(Preconditions.class);
                _builder.append((Object)_importedName_2, "            ");
                _builder.append((Object)".checkArgument(p.matcher(_value).matches(), \"Supplied value \\\"%s\\\" does not match required pattern \\\"%s\\\"\", _value, p);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        _builder.newLine();
        for (GeneratedProperty p_1 : this.properties) {
            Type _returnType_1 = p_1.getReturnType();
            String _importedName_3 = this.importedName(_returnType_1);
            boolean _contains = _importedName_3.contains("[]");
            if (_contains) {
                int _size_2;
                boolean _equals_6;
                boolean _isEmpty_3;
                boolean _not_2;
                boolean _and_7 = false;
                boolean _and_8 = false;
                boolean _and_9 = false;
                boolean _isTypedef_2 = this.genTO.isTypedef();
                _and_9 = !_isTypedef_2 ? false : (_not_2 = !(_isEmpty_3 = IterableExtensions.isEmpty(this.allProperties)));
                _and_8 = !_and_9 ? false : (_equals_6 = (_size_2 = IterableExtensions.size(this.allProperties)) == 1);
                if (!_and_8) {
                    _and_7 = false;
                } else {
                    boolean _equals_7;
                    GeneratedProperty _get_2 = ((GeneratedProperty[])Conversions.unwrapArray(this.allProperties, GeneratedProperty.class))[0];
                    String _name_4 = _get_2.getName();
                    _and_7 = _equals_7 = _name_4.equals("value");
                }
                if (_and_7) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"this.");
                    CharSequence _fieldName_1 = this.fieldName(p_1);
                    _builder.append((Object)_fieldName_1, "    ");
                    _builder.append((Object)" = ");
                    CharSequence _fieldName_2 = this.fieldName(p_1);
                    _builder.append((Object)_fieldName_2, "    ");
                    _builder.append((Object)".clone();");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"    ");
                _builder.append((Object)"this.");
                CharSequence _fieldName_3 = this.fieldName(p_1);
                _builder.append((Object)_fieldName_3, "    ");
                _builder.append((Object)" = ");
                CharSequence _fieldName_4 = this.fieldName(p_1);
                _builder.append((Object)_fieldName_4, "    ");
                _builder.append((Object)" == null ? null : ");
                CharSequence _fieldName_5 = this.fieldName(p_1);
                _builder.append((Object)_fieldName_5, "    ");
                _builder.append((Object)".clone();");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"this.");
            CharSequence _fieldName_6 = this.fieldName(p_1);
            _builder.append((Object)_fieldName_6, "    ");
            _builder.append((Object)" = ");
            CharSequence _fieldName_7 = this.fieldName(p_1);
            _builder.append((Object)_fieldName_7, "    ");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence genUnionConstructor() {
        StringConcatenation _builder = new StringConcatenation();
        for (GeneratedProperty p : this.allProperties) {
            ArrayList<GeneratedProperty> other = new ArrayList<GeneratedProperty>(this.properties);
            _builder.newLineIfNotEmpty();
            boolean _remove = other.remove(p);
            if (!_remove) continue;
            CharSequence _genConstructor = this.genConstructor(p, (GeneratedProperty[])Conversions.unwrapArray(other, GeneratedProperty.class));
            _builder.append((Object)_genConstructor, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        return _builder;
    }

    protected CharSequence genConstructor(GeneratedProperty property, GeneratedProperty ... other) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public ");
        String _name = this.type.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        Type _returnType = property.getReturnType();
        String _importedName = this.importedName(_returnType);
        String _plus = _importedName + " ";
        String _name_1 = property.getName();
        String _plus_1 = _plus + _name_1;
        _builder.append((Object)_plus_1, "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = this.parentProperties.isEmpty();
        boolean bl = _equals = false == _isEmpty;
        if (_equals) {
            _builder.append((Object)"    ");
            _builder.append((Object)"super(");
            CharSequence _asArguments = this.asArguments(this.parentProperties);
            _builder.append((Object)_asArguments, "    ");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _fieldName = this.fieldName(property);
        String _string = _fieldName.toString();
        Type _returnType_1 = property.getReturnType();
        CharSequence _generateRestrictions = this.generateRestrictions((Type)this.type, _string, _returnType_1);
        _builder.append((Object)_generateRestrictions, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"this.");
        CharSequence _fieldName_1 = this.fieldName(property);
        _builder.append((Object)_fieldName_1, "    ");
        _builder.append((Object)" = ");
        String _name_2 = property.getName();
        _builder.append((Object)_name_2, "    ");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        for (GeneratedProperty p : other) {
            _builder.append((Object)"    ");
            _builder.append((Object)"this.");
            CharSequence _fieldName_2 = this.fieldName(p);
            _builder.append((Object)_fieldName_2, "    ");
            _builder.append((Object)" = null;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private static String paramValue(Type returnType, String paramName) {
        if (returnType instanceof ConcreteType) {
            return paramName;
        }
        return paramName + ".getValue()";
    }

    private CharSequence generateRestrictions(Type type, String paramName, Type returnType) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        Restrictions restrictions = this.getRestrictions(type);
        _builder.newLineIfNotEmpty();
        boolean bl = _tripleNotEquals = restrictions != null;
        if (_tripleNotEquals) {
            List _rangeConstraints;
            boolean _isEmpty_1;
            boolean _not_1;
            boolean _not;
            boolean _or = false;
            List _lengthConstraints = restrictions.getLengthConstraints();
            boolean _isEmpty = _lengthConstraints.isEmpty();
            boolean bl2 = _not = !_isEmpty;
            _or = _not ? true : (_not_1 = !(_isEmpty_1 = (_rangeConstraints = restrictions.getRangeConstraints()).isEmpty()));
            if (_or) {
                List _rangeConstraints_1;
                boolean _isEmpty_3;
                boolean _not_3;
                boolean _not_2;
                _builder.append((Object)"if (");
                _builder.append((Object)paramName, "");
                _builder.append((Object)" != null) {");
                _builder.newLineIfNotEmpty();
                List _lengthConstraints_1 = restrictions.getLengthConstraints();
                boolean _isEmpty_2 = _lengthConstraints_1.isEmpty();
                boolean bl3 = _not_2 = !_isEmpty_2;
                if (_not_2) {
                    _builder.append((Object)"    ");
                    String _paramValue = ClassTemplate.paramValue(returnType, paramName);
                    String _generateLengthCheckerCall = LengthGenerator.generateLengthCheckerCall(paramName, _paramValue);
                    _builder.append((Object)_generateLengthCheckerCall, "    ");
                    _builder.newLineIfNotEmpty();
                }
                boolean bl4 = _not_3 = !(_isEmpty_3 = (_rangeConstraints_1 = restrictions.getRangeConstraints()).isEmpty());
                if (_not_3) {
                    _builder.append((Object)"    ");
                    String _paramValue_1 = ClassTemplate.paramValue(returnType, paramName);
                    String _generateRangeCheckerCall = this.rangeGenerator.generateRangeCheckerCall(paramName, _paramValue_1);
                    _builder.append((Object)_generateRangeCheckerCall, "    ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        return _builder;
    }

    protected CharSequence copyConstructor() {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Creates a copy from Source Object.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param source Source object");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _name = this.type.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        String _name_1 = this.type.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" source) {");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = this.parentProperties.isEmpty();
        boolean bl = _equals = false == _isEmpty;
        if (_equals) {
            _builder.append((Object)"    ");
            _builder.append((Object)"super(source);");
            _builder.newLine();
        }
        for (GeneratedProperty p : this.properties) {
            _builder.append((Object)"    ");
            _builder.append((Object)"this.");
            CharSequence _fieldName = this.fieldName(p);
            _builder.append((Object)_fieldName, "    ");
            _builder.append((Object)" = source.");
            CharSequence _fieldName_1 = this.fieldName(p);
            _builder.append((Object)_fieldName_1, "    ");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence parentConstructor() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Creates a new instance from ");
        GeneratedTransferObject _superType = this.genTO.getSuperType();
        String _importedName = this.importedName((Type)_superType);
        _builder.append((Object)_importedName, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param source Source object");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _name = this.type.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        GeneratedTransferObject _superType_1 = this.genTO.getSuperType();
        String _importedName_1 = this.importedName((Type)_superType_1);
        _builder.append((Object)_importedName_1, "");
        _builder.append((Object)" source) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"super(source);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence defaultInstance() {
        boolean _isUnionType;
        boolean _not_1;
        boolean _isEmpty;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean _and_1 = false;
        boolean _isTypedef = this.genTO.isTypedef();
        _and_1 = !_isTypedef ? false : (_not = !(_isEmpty = IterableExtensions.isEmpty(this.allProperties)));
        _and = !_and_1 ? false : (_not_1 = !(_isUnionType = this.genTO.isUnionType()));
        if (_and) {
            boolean _not_2;
            GeneratedProperty prop = ((GeneratedProperty[])Conversions.unwrapArray(this.allProperties, GeneratedProperty.class))[0];
            _builder.newLineIfNotEmpty();
            Type _returnType = prop.getReturnType();
            String _fullyQualifiedName = _returnType.getFullyQualifiedName();
            boolean _equals = "org.opendaylight.yangtools.yang.binding.InstanceIdentifier".equals(_fullyQualifiedName);
            boolean bl = _not_2 = !_equals;
            if (_not_2) {
                _builder.append((Object)"public static ");
                String _name = this.genTO.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)" getDefaultInstance(String defaultValue) {");
                _builder.newLineIfNotEmpty();
                Type _returnType_1 = prop.getReturnType();
                String _name_1 = _returnType_1.getName();
                boolean _equals_1 = "byte[]".equals(_name_1);
                if (_equals_1) {
                    _builder.append((Object)"    ");
                    String _importedName = this.importedName(BaseEncoding.class);
                    _builder.append((Object)_importedName, "    ");
                    _builder.append((Object)" baseEncoding = ");
                    String _importedName_1 = this.importedName(BaseEncoding.class);
                    _builder.append((Object)_importedName_1, "    ");
                    _builder.append((Object)".base64();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"return new ");
                    String _name_2 = this.genTO.getName();
                    _builder.append((Object)_name_2, "    ");
                    _builder.append((Object)"(baseEncoding.decode(defaultValue));");
                    _builder.newLineIfNotEmpty();
                } else {
                    Type _returnType_2 = prop.getReturnType();
                    String _fullyQualifiedName_1 = _returnType_2.getFullyQualifiedName();
                    boolean _equals_2 = "java.lang.String".equals(_fullyQualifiedName_1);
                    if (_equals_2) {
                        _builder.append((Object)"    ");
                        _builder.append((Object)"return new ");
                        String _name_3 = this.genTO.getName();
                        _builder.append((Object)_name_3, "    ");
                        _builder.append((Object)"(defaultValue);");
                        _builder.newLineIfNotEmpty();
                    } else {
                        boolean _greaterThan;
                        int _size = IterableExtensions.size(this.allProperties);
                        boolean bl2 = _greaterThan = _size > 1;
                        if (_greaterThan) {
                            _builder.append((Object)"    ");
                            CharSequence _bitsArgs = this.bitsArgs();
                            _builder.append((Object)_bitsArgs, "    ");
                            _builder.newLineIfNotEmpty();
                        } else {
                            Type _returnType_3 = prop.getReturnType();
                            String _fullyQualifiedName_2 = _returnType_3.getFullyQualifiedName();
                            boolean _equals_3 = "java.lang.Boolean".equals(_fullyQualifiedName_2);
                            if (_equals_3) {
                                _builder.append((Object)"    ");
                                _builder.append((Object)"return new ");
                                String _name_4 = this.genTO.getName();
                                _builder.append((Object)_name_4, "    ");
                                _builder.append((Object)"(Boolean.valueOf(defaultValue));");
                                _builder.newLineIfNotEmpty();
                            } else {
                                Type _returnType_4 = prop.getReturnType();
                                String _fullyQualifiedName_3 = _returnType_4.getFullyQualifiedName();
                                boolean _equals_4 = "java.lang.Byte".equals(_fullyQualifiedName_3);
                                if (_equals_4) {
                                    _builder.append((Object)"    ");
                                    _builder.append((Object)"return new ");
                                    String _name_5 = this.genTO.getName();
                                    _builder.append((Object)_name_5, "    ");
                                    _builder.append((Object)"(Byte.valueOf(defaultValue));");
                                    _builder.newLineIfNotEmpty();
                                } else {
                                    Type _returnType_5 = prop.getReturnType();
                                    String _fullyQualifiedName_4 = _returnType_5.getFullyQualifiedName();
                                    boolean _equals_5 = "java.lang.Short".equals(_fullyQualifiedName_4);
                                    if (_equals_5) {
                                        _builder.append((Object)"    ");
                                        _builder.append((Object)"return new ");
                                        String _name_6 = this.genTO.getName();
                                        _builder.append((Object)_name_6, "    ");
                                        _builder.append((Object)"(Short.valueOf(defaultValue));");
                                        _builder.newLineIfNotEmpty();
                                    } else {
                                        Type _returnType_6 = prop.getReturnType();
                                        String _fullyQualifiedName_5 = _returnType_6.getFullyQualifiedName();
                                        boolean _equals_6 = "java.lang.Integer".equals(_fullyQualifiedName_5);
                                        if (_equals_6) {
                                            _builder.append((Object)"    ");
                                            _builder.append((Object)"return new ");
                                            String _name_7 = this.genTO.getName();
                                            _builder.append((Object)_name_7, "    ");
                                            _builder.append((Object)"(Integer.valueOf(defaultValue));");
                                            _builder.newLineIfNotEmpty();
                                        } else {
                                            Type _returnType_7 = prop.getReturnType();
                                            String _fullyQualifiedName_6 = _returnType_7.getFullyQualifiedName();
                                            boolean _equals_7 = "java.lang.Long".equals(_fullyQualifiedName_6);
                                            if (_equals_7) {
                                                _builder.append((Object)"    ");
                                                _builder.append((Object)"return new ");
                                                String _name_8 = this.genTO.getName();
                                                _builder.append((Object)_name_8, "    ");
                                                _builder.append((Object)"(Long.valueOf(defaultValue));");
                                                _builder.newLineIfNotEmpty();
                                            } else {
                                                _builder.append((Object)"    ");
                                                _builder.append((Object)"return new ");
                                                String _name_9 = this.genTO.getName();
                                                _builder.append((Object)_name_9, "    ");
                                                _builder.append((Object)"(new ");
                                                Type _returnType_8 = prop.getReturnType();
                                                String _importedName_2 = this.importedName(_returnType_8);
                                                _builder.append((Object)_importedName_2, "    ");
                                                _builder.append((Object)"(defaultValue));");
                                                _builder.newLineIfNotEmpty();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        return _builder;
    }

    protected CharSequence bitsArgs() {
        StringConcatenation _builder = new StringConcatenation();
        String _importedName = this.importedName(List.class);
        _builder.append((Object)_importedName, "");
        _builder.append((Object)"<");
        String _importedName_1 = this.importedName(String.class);
        _builder.append((Object)_importedName_1, "");
        _builder.append((Object)"> properties = ");
        String _importedName_2 = this.importedName(Lists.class);
        _builder.append((Object)_importedName_2, "");
        _builder.append((Object)".newArrayList(");
        CharSequence _propsAsArgs = this.propsAsArgs(this.allProperties);
        _builder.append((Object)_propsAsArgs, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"if (!properties.contains(defaultValue)) {");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"throw new ");
        String _importedName_3 = this.importedName(IllegalArgumentException.class);
        _builder.append((Object)_importedName_3, "    ");
        _builder.append((Object)"(\"invalid default parameter\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"int i = 0;");
        _builder.newLine();
        _builder.append((Object)"return new ");
        String _name = this.genTO.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        _builder.newLineIfNotEmpty();
        boolean _hasElements = false;
        for (GeneratedProperty prop : this.allProperties) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            _builder.append((Object)"properties.get(i++).equals(defaultValue) ? ");
            String _importedName_4 = this.importedName(Boolean.class);
            _builder.append((Object)_importedName_4, "");
            _builder.append((Object)".TRUE : null");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)");");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence propsAsArgs(Iterable<GeneratedProperty> properties) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (GeneratedProperty prop : properties) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            _builder.append((Object)"\"");
            String _name = prop.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"\"");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateClassDeclaration(boolean isInnerClass) {
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public");
        if (isInnerClass) {
            _builder.append((Object)" static final ", "");
        } else {
            boolean _isAbstract = this.type.isAbstract();
            if (_isAbstract) {
                _builder.append((Object)" abstract ", "");
            } else {
                _builder.append((Object)" ", "");
            }
        }
        _builder.append((Object)"class ");
        String _name = this.type.getName();
        _builder.append((Object)_name, "");
        GeneratedTransferObject _superType = this.genTO.getSuperType();
        boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
        if (_notEquals) {
            _builder.append((Object)" extends ", "");
            GeneratedTransferObject _superType_1 = this.genTO.getSuperType();
            String _importedName = this.importedName((Type)_superType_1);
            _builder.append((Object)_importedName, "");
        }
        _builder.newLineIfNotEmpty();
        List _implements = this.type.getImplements();
        boolean _isEmpty = _implements.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)" implements ", "");
            List _implements_1 = this.type.getImplements();
            boolean _hasElements = false;
            for (Type type : _implements_1) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _importedName_1 = this.importedName(type);
                _builder.append((Object)_importedName_1, "");
            }
        }
        return _builder;
    }

    protected CharSequence enumDeclarations() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.enums.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (Enumeration e : this.enums) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n", "");
                }
                EnumTemplate enumTemplate = new EnumTemplate(e);
                _builder.newLineIfNotEmpty();
                CharSequence _generateAsInnerClass = enumTemplate.generateAsInnerClass();
                _builder.append((Object)_generateAsInnerClass, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    protected CharSequence suidDeclaration() {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        GeneratedProperty _sUID = this.genTO.getSUID();
        boolean bl = _notEquals = !Objects.equal((Object)_sUID, null);
        if (_notEquals) {
            _builder.append((Object)"private static final long serialVersionUID = ");
            GeneratedProperty _sUID_1 = this.genTO.getSUID();
            String _value = _sUID_1.getValue();
            _builder.append((Object)_value, "");
            _builder.append((Object)"L;");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence constantsDeclarations() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.consts.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            for (Constant c : this.consts) {
                String _name = c.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)"PATTERN_CONSTANTS");
                if (_equals) {
                    Object cValue = c.getValue();
                    _builder.newLineIfNotEmpty();
                    if (!(cValue instanceof List)) continue;
                    _builder.append((Object)"private static final ");
                    String _importedName = this.importedName(Pattern.class);
                    _builder.append((Object)_importedName, "");
                    _builder.append((Object)"[] ");
                    _builder.append((Object)"patterns", "");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"public static final ");
                    String _importedName_1 = this.importedName(List.class);
                    _builder.append((Object)_importedName_1, "");
                    _builder.append((Object)"<String> ");
                    _builder.append((Object)"PATTERN_CONSTANTS", "");
                    _builder.append((Object)" = ");
                    String _importedName_2 = this.importedName(ImmutableList.class);
                    _builder.append((Object)_importedName_2, "");
                    _builder.append((Object)".of(");
                    boolean _hasElements = false;
                    for (Object v : (List)cValue) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        if (!(v instanceof String)) continue;
                        _builder.append((Object)"\"");
                        _builder.append((Object)((String)v), "");
                        _builder.append((Object)"\"");
                    }
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    CharSequence _generateStaticInicializationBlock = this.generateStaticInicializationBlock();
                    _builder.append((Object)_generateStaticInicializationBlock, "");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"public static final ");
                Type _type = c.getType();
                String _importedName_3 = this.importedName(_type);
                _builder.append((Object)_importedName_3, "");
                _builder.append((Object)" ");
                String _name_1 = c.getName();
                _builder.append((Object)_name_1, "");
                _builder.append((Object)" = ");
                Object _value = c.getValue();
                _builder.append(_value, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    protected CharSequence generateStaticInicializationBlock() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"static {");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"final ");
        String _importedName = this.importedName(Pattern.class);
        _builder.append((Object)_importedName, "    ");
        _builder.append((Object)" a[] = new ");
        String _importedName_1 = this.importedName(Pattern.class);
        _builder.append((Object)_importedName_1, "    ");
        _builder.append((Object)"[");
        _builder.append((Object)"PATTERN_CONSTANTS", "    ");
        _builder.append((Object)".size()];");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"int i = 0;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"for (String regEx : ");
        _builder.append((Object)"PATTERN_CONSTANTS", "    ");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"a[i++] = Pattern.compile(regEx);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"patterns", "    ");
        _builder.append((Object)" = a;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateFields() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.properties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            for (GeneratedProperty f : this.properties) {
                _builder.append((Object)"private");
                boolean _isReadOnly = f.isReadOnly();
                if (_isReadOnly) {
                    _builder.append((Object)" final");
                }
                _builder.append((Object)" ");
                Type _returnType = f.getReturnType();
                String _importedName = this.importedName(_returnType);
                _builder.append((Object)_importedName, "");
                _builder.append((Object)" ");
                CharSequence _fieldName = this.fieldName(f);
                _builder.append((Object)_fieldName, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    protected CharSequence generateHashCode() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        List _hashCodeIdentifiers = this.genTO.getHashCodeIdentifiers();
        boolean _isEmpty = _hashCodeIdentifiers.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"public int hashCode() {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"final int prime = 31;");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"int result = 1;");
            _builder.newLine();
            List _hashCodeIdentifiers_1 = this.genTO.getHashCodeIdentifiers();
            for (GeneratedProperty property : _hashCodeIdentifiers_1) {
                Type _returnType = property.getReturnType();
                String _name = _returnType.getName();
                boolean _contains = _name.contains("[");
                if (_contains) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"result = prime * result + ((");
                    CharSequence _fieldName = this.fieldName(property);
                    _builder.append((Object)_fieldName, "    ");
                    _builder.append((Object)" == null) ? 0 : ");
                    String _importedName = this.importedName(Arrays.class);
                    _builder.append((Object)_importedName, "    ");
                    _builder.append((Object)".hashCode(");
                    CharSequence _fieldName_1 = this.fieldName(property);
                    _builder.append((Object)_fieldName_1, "    ");
                    _builder.append((Object)"));");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"    ");
                _builder.append((Object)"result = prime * result + ((");
                CharSequence _fieldName_2 = this.fieldName(property);
                _builder.append((Object)_fieldName_2, "    ");
                _builder.append((Object)" == null) ? 0 : ");
                CharSequence _fieldName_3 = this.fieldName(property);
                _builder.append((Object)_fieldName_3, "    ");
                _builder.append((Object)".hashCode());");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"return result;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateEquals() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        List _equalsIdentifiers = this.genTO.getEqualsIdentifiers();
        boolean _isEmpty = _equalsIdentifiers.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"public boolean equals(java.lang.Object obj) {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"if (this == obj) {");
            _builder.newLine();
            _builder.append((Object)"        ");
            _builder.append((Object)"return true;");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"if (obj == null) {");
            _builder.newLine();
            _builder.append((Object)"        ");
            _builder.append((Object)"return false;");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"if (getClass() != obj.getClass()) {");
            _builder.newLine();
            _builder.append((Object)"        ");
            _builder.append((Object)"return false;");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"    ");
            String _name = this.type.getName();
            _builder.append((Object)_name, "    ");
            _builder.append((Object)" other = (");
            String _name_1 = this.type.getName();
            _builder.append((Object)_name_1, "    ");
            _builder.append((Object)") obj;");
            _builder.newLineIfNotEmpty();
            List _equalsIdentifiers_1 = this.genTO.getEqualsIdentifiers();
            for (GeneratedProperty property : _equalsIdentifiers_1) {
                _builder.append((Object)"    ");
                CharSequence fieldName = this.fieldName(property);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"if (");
                _builder.append((Object)fieldName, "    ");
                _builder.append((Object)" == null) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"if (other.");
                _builder.append((Object)fieldName, "        ");
                _builder.append((Object)" != null) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"        ");
                _builder.append((Object)"return false;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                Type _returnType = property.getReturnType();
                String _name_2 = _returnType.getName();
                boolean _contains = _name_2.contains("[");
                if (_contains) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"} else if(!");
                    String _importedName = this.importedName(Arrays.class);
                    _builder.append((Object)_importedName, "    ");
                    _builder.append((Object)".equals(");
                    _builder.append((Object)fieldName, "    ");
                    _builder.append((Object)", other.");
                    _builder.append((Object)fieldName, "    ");
                    _builder.append((Object)")) {");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"} else if(!");
                    _builder.append((Object)fieldName, "    ");
                    _builder.append((Object)".equals(other.");
                    _builder.append((Object)fieldName, "    ");
                    _builder.append((Object)")) {");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"return false;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"return true;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public GeneratedProperty getPropByName(String name) {
        for (GeneratedProperty prop : this.allProperties) {
            String _name = prop.getName();
            boolean _equals = _name.equals(name);
            if (!_equals) continue;
            return prop;
        }
        return null;
    }
}

