/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Range;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.opendaylight.yangtools.binding.generator.util.ReferencedTypeImpl;
import org.opendaylight.yangtools.binding.generator.util.Types;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.GeneratedTOBuilderImpl;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.sal.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.sal.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.sal.binding.model.api.ParameterizedType;
import org.opendaylight.yangtools.sal.binding.model.api.Restrictions;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.yangtools.sal.java.api.generator.AbstractRangeGenerator;
import org.opendaylight.yangtools.sal.java.api.generator.AlphabeticallyTypeMemberComparator;
import org.opendaylight.yangtools.sal.java.api.generator.BaseTemplate;
import org.opendaylight.yangtools.sal.java.api.generator.LengthGenerator;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;

public class BuilderTemplate
extends BaseTemplate {
    private static final String GET_AUGMENTATION_METHOD_NAME = "getAugmentation";
    private static final String BUILDER = "Builder";
    private static final String BUILDERFOR = Builder.class.getSimpleName();
    private static final String IMPL = "Impl";
    private GeneratedProperty augmentField;
    private final Set<GeneratedProperty> properties;
    private static final AlphabeticallyTypeMemberComparator<MethodSignature> METHOD_COMPARATOR = new AlphabeticallyTypeMemberComparator();

    public BuilderTemplate(GeneratedType genType) {
        super(genType);
        Set<MethodSignature> _createMethods = this.createMethods();
        Set<GeneratedProperty> _propertiesFromMethods = this.propertiesFromMethods(_createMethods);
        this.properties = _propertiesFromMethods;
        String _simpleName = Builder.class.getSimpleName();
        Package _package = Builder.class.getPackage();
        String _name = _package.getName();
        this.importMap.put(_simpleName, _name);
    }

    private Set<MethodSignature> createMethods() {
        LinkedHashSet<MethodSignature> methods = new LinkedHashSet<MethodSignature>();
        List _methodDefinitions = this.type.getMethodDefinitions();
        methods.addAll(_methodDefinitions);
        List _implements = this.type.getImplements();
        this.collectImplementedMethods(methods, _implements);
        ImmutableSortedSet.Builder _orderedBy = ImmutableSortedSet.orderedBy(METHOD_COMPARATOR);
        ImmutableSortedSet.Builder _addAll = _orderedBy.addAll(methods);
        ImmutableSortedSet sortedMethods = _addAll.build();
        return sortedMethods;
    }

    private void collectImplementedMethods(Set<MethodSignature> methods, List<Type> implementedIfcs) {
        boolean _isEmpty;
        boolean _or = false;
        boolean _equals = Objects.equal(implementedIfcs, null);
        _or = _equals ? true : (_isEmpty = implementedIfcs.isEmpty());
        if (_or) {
            return;
        }
        for (Type implementedIfc : implementedIfcs) {
            Method[] _methods;
            String _name;
            boolean _and = false;
            if (!(implementedIfc instanceof GeneratedType)) {
                _and = false;
            } else {
                boolean bl = _and = !(implementedIfc instanceof GeneratedTransferObject);
            }
            if (_and) {
                GeneratedType ifc = (GeneratedType)implementedIfc;
                List _methodDefinitions = ifc.getMethodDefinitions();
                methods.addAll(_methodDefinitions);
                List _implements = ifc.getImplements();
                this.collectImplementedMethods(methods, _implements);
                continue;
            }
            String _fullyQualifiedName = implementedIfc.getFullyQualifiedName();
            boolean _equals_1 = Objects.equal((Object)_fullyQualifiedName, (Object)(_name = Augmentable.class.getName()));
            if (!_equals_1) continue;
            for (Method m : _methods = Augmentable.class.getMethods()) {
                GeneratedProperty _propertyFromGetter;
                String _name_1 = m.getName();
                boolean _equals_2 = Objects.equal((Object)_name_1, (Object)GET_AUGMENTATION_METHOD_NAME);
                if (!_equals_2) continue;
                Class<?> _returnType = m.getReturnType();
                String fullyQualifiedName = _returnType.getName();
                String pkg = this.getPackage(fullyQualifiedName);
                String name = this.getName(fullyQualifiedName);
                GeneratedTOBuilderImpl tmpGenTO = new GeneratedTOBuilderImpl(pkg, name);
                ReferencedTypeImpl refType = new ReferencedTypeImpl(pkg, name);
                String _packageName = this.type.getPackageName();
                String _name_2 = this.type.getName();
                ReferencedTypeImpl generic = new ReferencedTypeImpl(_packageName, _name_2);
                ParameterizedType parametrizedReturnType = Types.parameterizedTypeFor((Type)refType, (Type[])new Type[]{generic});
                String _name_3 = m.getName();
                MethodSignatureBuilder _addMethod = tmpGenTO.addMethod(_name_3);
                _addMethod.setReturnType((Type)parametrizedReturnType);
                GeneratedTransferObject _instance = tmpGenTO.toInstance();
                List _methodDefinitions_1 = _instance.getMethodDefinitions();
                MethodSignature _first = (MethodSignature)this.first(_methodDefinitions_1);
                this.augmentField = _propertyFromGetter = this.propertyFromGetter(_first);
            }
        }
    }

    private <E> E first(List<E> elements) {
        return elements.get(0);
    }

    private String getPackage(String fullyQualifiedName) {
        int lastDotIndex = fullyQualifiedName.lastIndexOf(".");
        String _xifexpression = null;
        _xifexpression = lastDotIndex == -1 ? "" : fullyQualifiedName.substring(0, lastDotIndex);
        return _xifexpression;
    }

    private String getName(String fullyQualifiedName) {
        int lastDotIndex = fullyQualifiedName.lastIndexOf(".");
        String _xifexpression = null;
        _xifexpression = lastDotIndex == -1 ? fullyQualifiedName : fullyQualifiedName.substring(lastDotIndex + 1);
        return _xifexpression;
    }

    private Set<GeneratedProperty> propertiesFromMethods(Collection<MethodSignature> methods) {
        boolean _isEmpty;
        boolean _or = false;
        boolean _equals = Objects.equal(methods, null);
        _or = _equals ? true : (_isEmpty = methods.isEmpty());
        if (_or) {
            return Collections.emptySet();
        }
        LinkedHashSet<GeneratedProperty> result = new LinkedHashSet<GeneratedProperty>();
        for (MethodSignature m : methods) {
            GeneratedProperty createdField = this.propertyFromGetter(m);
            boolean _notEquals = !Objects.equal((Object)createdField, null);
            if (!_notEquals) continue;
            result.add(createdField);
        }
        return result;
    }

    private GeneratedProperty propertyFromGetter(MethodSignature method) {
        String _name_2;
        boolean _startsWith;
        boolean _or = false;
        boolean _or_1 = false;
        boolean _or_2 = false;
        boolean _equals = Objects.equal((Object)method, null);
        if (_equals) {
            _or_2 = true;
        } else {
            boolean _equals_1;
            String _name = method.getName();
            _or_2 = _equals_1 = Objects.equal((Object)_name, null);
        }
        if (_or_2) {
            _or_1 = true;
        } else {
            boolean _isEmpty;
            String _name_1 = method.getName();
            _or_1 = _isEmpty = _name_1.isEmpty();
        }
        if (_or_1) {
            _or = true;
        } else {
            boolean _equals_2;
            Type _returnType = method.getReturnType();
            _or = _equals_2 = Objects.equal((Object)_returnType, null);
        }
        if (_or) {
            throw new IllegalArgumentException("Method, method name, method return type reference cannot be NULL or empty!");
        }
        String prefix = "get";
        Type _returnType_1 = method.getReturnType();
        boolean _equals_3 = Types.BOOLEAN.equals(_returnType_1);
        if (_equals_3) {
            prefix = "is";
        }
        if (_startsWith = (_name_2 = method.getName()).startsWith(prefix)) {
            String _name_3 = method.getName();
            int _length = prefix.length();
            String _substring = _name_3.substring(_length);
            String fieldName = StringExtensions.toFirstLower((String)_substring);
            GeneratedTOBuilderImpl tmpGenTO = new GeneratedTOBuilderImpl("foo", "foo");
            GeneratedPropertyBuilder _addProperty = tmpGenTO.addProperty(fieldName);
            Type _returnType_2 = method.getReturnType();
            _addProperty.setReturnType(_returnType_2);
            GeneratedTransferObject _instance = tmpGenTO.toInstance();
            List _properties = _instance.getProperties();
            return (GeneratedProperty)this.first(_properties);
        }
        return null;
    }

    @Override
    public CharSequence body() {
        StringConcatenation _builder = new StringConcatenation();
        String _formatDataForJavaDoc = this.formatDataForJavaDoc(this.type);
        String _wrapToDocumentation = this.wrapToDocumentation(_formatDataForJavaDoc);
        _builder.append((Object)_wrapToDocumentation, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public class ");
        String _name = this.type.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)BUILDER, "");
        _builder.append((Object)" implements ");
        _builder.append((Object)BUILDERFOR, "");
        _builder.append((Object)" <");
        String _importedName = this.importedName((Type)this.type);
        _builder.append((Object)_importedName, "");
        _builder.append((Object)"> {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateFields = this.generateFields(false);
        _builder.append((Object)_generateFields, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateAugmentField = this.generateAugmentField(false);
        _builder.append((Object)_generateAugmentField, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateConstructorsFromIfcs = this.generateConstructorsFromIfcs((Type)this.type);
        _builder.append((Object)_generateConstructorsFromIfcs, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateCopyConstructor = this.generateCopyConstructor(false);
        _builder.append((Object)_generateCopyConstructor, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateMethodFieldsFrom = this.generateMethodFieldsFrom((Type)this.type);
        _builder.append((Object)_generateMethodFieldsFrom, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateGetters = this.generateGetters(false);
        _builder.append((Object)_generateGetters, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateSetters = this.generateSetters();
        _builder.append((Object)_generateSetters, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public ");
        String _name_1 = this.type.getName();
        _builder.append((Object)_name_1, "    ");
        _builder.append((Object)" build() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"return new ");
        String _name_2 = this.type.getName();
        _builder.append((Object)_name_2, "        ");
        _builder.append((Object)IMPL, "        ");
        _builder.append((Object)"(this);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private static final class ");
        String _name_3 = this.type.getName();
        _builder.append((Object)_name_3, "    ");
        _builder.append((Object)IMPL, "    ");
        _builder.append((Object)" implements ");
        String _name_4 = this.type.getName();
        _builder.append((Object)_name_4, "    ");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"        ");
        CharSequence _implementedInterfaceGetter = this.implementedInterfaceGetter();
        _builder.append((Object)_implementedInterfaceGetter, "        ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"        ");
        CharSequence _generateFields_1 = this.generateFields(true);
        _builder.append((Object)_generateFields_1, "        ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"        ");
        CharSequence _generateAugmentField_1 = this.generateAugmentField(true);
        _builder.append((Object)_generateAugmentField_1, "        ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"        ");
        CharSequence _generateCopyConstructor_1 = this.generateCopyConstructor(true);
        _builder.append((Object)_generateCopyConstructor_1, "        ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"        ");
        CharSequence _generateGetters_1 = this.generateGetters(true);
        _builder.append((Object)_generateGetters_1, "        ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"        ");
        CharSequence _generateHashCode = this.generateHashCode();
        _builder.append((Object)_generateHashCode, "        ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"        ");
        CharSequence _generateEquals = this.generateEquals();
        _builder.append((Object)_generateEquals, "        ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"        ");
        CharSequence _generateToString = this.generateToString(this.properties);
        _builder.append((Object)_generateToString, "        ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateConstructorsFromIfcs(Type type) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public ");
        String _name = type.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)BUILDER, "");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        boolean _and = false;
        if (!(type instanceof GeneratedType)) {
            _and = false;
        } else {
            boolean bl = _and = !(type instanceof GeneratedTransferObject);
        }
        if (_and) {
            GeneratedType ifc = (GeneratedType)type;
            _builder.newLineIfNotEmpty();
            List _implements = ifc.getImplements();
            for (Type impl : _implements) {
                Object _generateConstructorFromIfc = this.generateConstructorFromIfc(impl);
                _builder.append(_generateConstructorFromIfc, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private Object generateConstructorFromIfc(Type impl) {
        StringConcatenation _builder = new StringConcatenation();
        if (impl instanceof GeneratedType) {
            boolean _not;
            List _methodDefinitions = ((GeneratedType)impl).getMethodDefinitions();
            boolean _isEmpty = _methodDefinitions.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"public ");
                String _name = this.type.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)BUILDER, "");
                _builder.append((Object)"(");
                String _fullyQualifiedName = ((GeneratedType)impl).getFullyQualifiedName();
                _builder.append((Object)_fullyQualifiedName, "");
                _builder.append((Object)" arg) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                Object _printConstructorPropertySetter = this.printConstructorPropertySetter(impl);
                _builder.append(_printConstructorPropertySetter, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            }
            List _implements = ((GeneratedType)impl).getImplements();
            for (Type implTypeImplement : _implements) {
                Object _generateConstructorFromIfc = this.generateConstructorFromIfc(implTypeImplement);
                _builder.append(_generateConstructorFromIfc, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private Object printConstructorPropertySetter(Type implementedIfc) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        if (!(implementedIfc instanceof GeneratedType)) {
            _and = false;
        } else {
            boolean bl = _and = !(implementedIfc instanceof GeneratedTransferObject);
        }
        if (_and) {
            GeneratedType ifc = (GeneratedType)implementedIfc;
            _builder.newLineIfNotEmpty();
            List _methodDefinitions = ifc.getMethodDefinitions();
            for (MethodSignature getter : _methodDefinitions) {
                _builder.append((Object)"this._");
                String _propertyNameFromGetter = this.propertyNameFromGetter(getter);
                _builder.append((Object)_propertyNameFromGetter, "");
                _builder.append((Object)" = arg.");
                String _name = getter.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
            }
            List _implements = ifc.getImplements();
            for (Type impl : _implements) {
                Object _printConstructorPropertySetter = this.printConstructorPropertySetter(impl);
                _builder.append(_printConstructorPropertySetter, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence generateMethodFieldsFrom(Type type) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        if (!(type instanceof GeneratedType)) {
            _and = false;
        } else {
            boolean bl = _and = !(type instanceof GeneratedTransferObject);
        }
        if (_and) {
            GeneratedType ifc = (GeneratedType)type;
            _builder.newLineIfNotEmpty();
            boolean _hasImplementsFromUses = this.hasImplementsFromUses(ifc);
            if (_hasImplementsFromUses) {
                List<Type> done = this.getBaseIfcs(ifc);
                _builder.newLineIfNotEmpty();
                CharSequence _generateMethodFieldsFromComment = this.generateMethodFieldsFromComment(ifc);
                _builder.append((Object)_generateMethodFieldsFromComment, "");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"public void fieldsFrom(");
                String _importedName = this.importedName(DataObject.class);
                _builder.append((Object)_importedName, "");
                _builder.append((Object)" arg) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"boolean isValidArg = false;");
                _builder.newLine();
                Set<Type> _allIfcs = this.getAllIfcs((Type)ifc);
                for (Type impl : _allIfcs) {
                    _builder.append((Object)"    ");
                    CharSequence _generateIfCheck = this.generateIfCheck(impl, done);
                    _builder.append((Object)_generateIfCheck, "    ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"    ");
                _builder.append((Object)"if (!isValidArg) {");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"throw new IllegalArgumentException(");
                _builder.newLine();
                _builder.append((Object)"          ");
                _builder.append((Object)"\"expected one of: ");
                Set<Type> _allIfcs_1 = this.getAllIfcs((Type)ifc);
                List<String> _listOfNames = this.toListOfNames(_allIfcs_1);
                _builder.append(_listOfNames, "          ");
                _builder.append((Object)" \\n\" +");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"          ");
                _builder.append((Object)"\"but was: \" + arg");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)");");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        return _builder;
    }

    private CharSequence generateMethodFieldsFromComment(GeneratedType type) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*Set fields from given grouping argument. Valid argument is instance of one of following types:");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* <ul>");
        _builder.newLine();
        Set<Type> _allIfcs = this.getAllIfcs((Type)type);
        for (Type impl : _allIfcs) {
            _builder.append((Object)" ");
            _builder.append((Object)"* <li>");
            String _fullyQualifiedName = impl.getFullyQualifiedName();
            _builder.append((Object)_fullyQualifiedName, " ");
            _builder.append((Object)"</li>");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)" ");
        _builder.append((Object)"* </ul>");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param arg grouping object");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @throws IllegalArgumentException if given argument is none of valid types");
        _builder.newLine();
        _builder.append((Object)"*/");
        _builder.newLine();
        return _builder;
    }

    public boolean hasImplementsFromUses(GeneratedType type) {
        int i = 0;
        Set<Type> _allIfcs = this.getAllIfcs((Type)type);
        for (Type impl : _allIfcs) {
            List _methodDefinitions;
            boolean _isEmpty;
            boolean _not;
            boolean _and = false;
            _and = !(impl instanceof GeneratedType) ? false : (_not = !(_isEmpty = (_methodDefinitions = ((GeneratedType)impl).getMethodDefinitions()).isEmpty()));
            if (!_and) continue;
            ++i;
        }
        return i > 0;
    }

    private CharSequence generateIfCheck(Type impl, List<Type> done) {
        List _methodDefinitions;
        boolean _isEmpty;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        _and = !(impl instanceof GeneratedType) ? false : (_not = !(_isEmpty = (_methodDefinitions = ((GeneratedType)impl).getMethodDefinitions()).isEmpty()));
        if (_and) {
            GeneratedType implType = (GeneratedType)impl;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"if (arg instanceof ");
            String _fullyQualifiedName = implType.getFullyQualifiedName();
            _builder.append((Object)_fullyQualifiedName, "");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            CharSequence _printPropertySetter = this.printPropertySetter((Type)implType);
            _builder.append((Object)_printPropertySetter, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"isValidArg = true;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence printPropertySetter(Type implementedIfc) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        if (!(implementedIfc instanceof GeneratedType)) {
            _and = false;
        } else {
            boolean bl = _and = !(implementedIfc instanceof GeneratedTransferObject);
        }
        if (_and) {
            GeneratedType ifc = (GeneratedType)implementedIfc;
            _builder.newLineIfNotEmpty();
            List _methodDefinitions = ifc.getMethodDefinitions();
            for (MethodSignature getter : _methodDefinitions) {
                _builder.append((Object)"this._");
                String _propertyNameFromGetter = this.propertyNameFromGetter(getter);
                _builder.append((Object)_propertyNameFromGetter, "");
                _builder.append((Object)" = ((");
                String _fullyQualifiedName = implementedIfc.getFullyQualifiedName();
                _builder.append((Object)_fullyQualifiedName, "");
                _builder.append((Object)")arg).");
                String _name = getter.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private List<Type> getBaseIfcs(GeneratedType type) {
        ArrayList<Type> baseIfcs = new ArrayList<Type>();
        List _implements = type.getImplements();
        for (Type ifc : _implements) {
            List _methodDefinitions;
            boolean _isEmpty;
            boolean _not;
            boolean _and = false;
            _and = !(ifc instanceof GeneratedType) ? false : (_not = !(_isEmpty = (_methodDefinitions = ((GeneratedType)ifc).getMethodDefinitions()).isEmpty()));
            if (!_and) continue;
            baseIfcs.add(ifc);
        }
        return baseIfcs;
    }

    private Set<Type> getAllIfcs(Type type) {
        HashSet<Type> baseIfcs = new HashSet<Type>();
        boolean _and = false;
        if (!(type instanceof GeneratedType)) {
            _and = false;
        } else {
            boolean bl = _and = !(type instanceof GeneratedTransferObject);
        }
        if (_and) {
            GeneratedType ifc = (GeneratedType)type;
            List _implements = ifc.getImplements();
            for (Type impl : _implements) {
                List _methodDefinitions;
                boolean _isEmpty;
                boolean _not;
                boolean _and_1 = false;
                _and_1 = !(impl instanceof GeneratedType) ? false : (_not = !(_isEmpty = (_methodDefinitions = ((GeneratedType)impl).getMethodDefinitions()).isEmpty()));
                if (_and_1) {
                    baseIfcs.add(impl);
                }
                Set<Type> _allIfcs = this.getAllIfcs(impl);
                baseIfcs.addAll(_allIfcs);
            }
        }
        return baseIfcs;
    }

    private List<String> toListOfNames(Collection<Type> types) {
        ArrayList<String> names = new ArrayList<String>();
        for (Type type : types) {
            String _fullyQualifiedName = type.getFullyQualifiedName();
            names.add(_fullyQualifiedName);
        }
        return names;
    }

    private CharSequence generateFields(boolean _final) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _tripleNotEquals = this.properties != null;
        if (_tripleNotEquals) {
            for (GeneratedProperty f : this.properties) {
                List _lengthConstraints;
                boolean _isEmpty;
                boolean _not;
                boolean _notEquals;
                _builder.append((Object)"private");
                if (_final) {
                    _builder.append((Object)" final");
                }
                _builder.append((Object)" ");
                Type _returnType = f.getReturnType();
                String _importedName = this.importedName(_returnType);
                _builder.append((Object)_importedName, "");
                _builder.append((Object)" ");
                CharSequence _fieldName = this.fieldName(f);
                _builder.append((Object)_fieldName, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                Type _returnType_1 = f.getReturnType();
                Restrictions restrictions = this.getRestrictions(_returnType_1);
                _builder.newLineIfNotEmpty();
                boolean _and = false;
                boolean _and_1 = false;
                _and_1 = _final ? false : (_notEquals = !Objects.equal((Object)restrictions, null));
                _and = !_and_1 ? false : (_not = !(_isEmpty = (_lengthConstraints = restrictions.getLengthConstraints()).isEmpty()));
                if (!_and) continue;
                CharSequence _fieldName_1 = this.fieldName(f);
                String _string = _fieldName_1.toString();
                Type _returnType_2 = f.getReturnType();
                List _lengthConstraints_1 = restrictions.getLengthConstraints();
                String _generateLengthChecker = LengthGenerator.generateLengthChecker(_string, _returnType_2, _lengthConstraints_1);
                _builder.append((Object)_generateLengthChecker, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence generateAugmentField(boolean isPrivate) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equal((Object)this.augmentField, null);
        if (_notEquals) {
            if (isPrivate) {
                _builder.append((Object)"private ");
            }
            String _importedName = this.importedName(Map.class);
            _builder.append((Object)_importedName, "");
            _builder.append((Object)"<");
            String _importedName_1 = this.importedName(Class.class);
            _builder.append((Object)_importedName_1, "");
            _builder.append((Object)"<? extends ");
            Type _returnType = this.augmentField.getReturnType();
            String _importedName_2 = this.importedName(_returnType);
            _builder.append((Object)_importedName_2, "");
            _builder.append((Object)">, ");
            Type _returnType_1 = this.augmentField.getReturnType();
            String _importedName_3 = this.importedName(_returnType_1);
            _builder.append((Object)_importedName_3, "");
            _builder.append((Object)"> ");
            String _name = this.augmentField.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)" = ");
            String _importedName_4 = this.importedName(Collections.class);
            _builder.append((Object)_importedName_4, "");
            _builder.append((Object)".emptyMap();");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence generateSetters() {
        boolean _notEquals_2;
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (GeneratedProperty field : this.properties) {
            boolean _notEquals_1;
            boolean _notEquals;
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"\n", "");
            }
            Type _returnType = field.getReturnType();
            Restrictions restrictions = this.getRestrictions(_returnType);
            _builder.newLineIfNotEmpty();
            boolean bl = _notEquals = !Objects.equal((Object)restrictions, null);
            if (_notEquals) {
                boolean _not;
                List _rangeConstraints = restrictions.getRangeConstraints();
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)_rangeConstraints);
                boolean bl2 = _not = !_isNullOrEmpty;
                if (_not) {
                    Type _returnType_1 = field.getReturnType();
                    AbstractRangeGenerator<?> rangeGenerator = AbstractRangeGenerator.forType(_returnType_1);
                    _builder.newLineIfNotEmpty();
                    String _name = field.getName();
                    String _firstUpper = StringExtensions.toFirstUpper((String)_name);
                    List _rangeConstraints_1 = restrictions.getRangeConstraints();
                    String _generateRangeChecker = rangeGenerator.generateRangeChecker(_firstUpper, _rangeConstraints_1);
                    _builder.append((Object)_generateRangeChecker, "");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                }
            }
            _builder.append((Object)"public ");
            String _name_1 = this.type.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)BUILDER, "");
            _builder.append((Object)" set");
            String _name_2 = field.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_2);
            _builder.append((Object)_firstUpper_1, "");
            _builder.append((Object)"(");
            Type _returnType_2 = field.getReturnType();
            String _importedName = this.importedName(_returnType_2);
            _builder.append((Object)_importedName, "");
            _builder.append((Object)" value) {");
            _builder.newLineIfNotEmpty();
            boolean bl3 = _notEquals_1 = !Objects.equal((Object)restrictions, null);
            if (_notEquals_1) {
                boolean _not_1;
                _builder.append((Object)"    ");
                _builder.append((Object)"if (value != null) {");
                _builder.newLine();
                List _rangeConstraints_2 = restrictions.getRangeConstraints();
                boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)_rangeConstraints_2);
                boolean bl4 = _not_1 = !_isNullOrEmpty_1;
                if (_not_1) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    Type _returnType_3 = field.getReturnType();
                    AbstractRangeGenerator<?> rangeGenerator_1 = AbstractRangeGenerator.forType(_returnType_3);
                    _builder.newLineIfNotEmpty();
                    Type _returnType_4 = field.getReturnType();
                    if (_returnType_4 instanceof ConcreteType) {
                        _builder.append((Object)"    ");
                        _builder.append((Object)"    ");
                        String _name_3 = field.getName();
                        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
                        String _generateRangeCheckerCall = rangeGenerator_1.generateRangeCheckerCall(_firstUpper_2, "value");
                        _builder.append((Object)_generateRangeCheckerCall, "        ");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"    ");
                        _builder.append((Object)"    ");
                        String _name_4 = field.getName();
                        String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_4);
                        String _generateRangeCheckerCall_1 = rangeGenerator_1.generateRangeCheckerCall(_firstUpper_3, "value.getValue()");
                        _builder.append((Object)_generateRangeCheckerCall_1, "        ");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                CharSequence _generateRestrictions = this.generateRestrictions(field, "value");
                _builder.append((Object)_generateRestrictions, "        ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"this.");
            CharSequence _fieldName = this.fieldName(field);
            _builder.append((Object)_fieldName, "    ");
            _builder.append((Object)" = value;");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"return this;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
            CharSequence _fieldName_1 = this.fieldName(field);
            String _plus = _fieldName_1 + "_length";
            Type _returnType_5 = field.getReturnType();
            CharSequence _generateLengthMethod = this.generateLengthMethod(_plus, _returnType_5);
            _builder.append((Object)_generateLengthMethod, "");
            _builder.newLineIfNotEmpty();
            CharSequence _fieldName_2 = this.fieldName(field);
            String range = _fieldName_2 + "_range";
            _builder.newLineIfNotEmpty();
            Type _returnType_6 = field.getReturnType();
            CharSequence _generateRangeMethod = this.generateRangeMethod(range, restrictions, _returnType_6);
            _builder.append((Object)_generateRangeMethod, "");
            _builder.newLineIfNotEmpty();
        }
        boolean bl = _notEquals_2 = !Objects.equal((Object)this.augmentField, null);
        if (_notEquals_2) {
            _builder.newLine();
            _builder.append((Object)"public ");
            String _name_5 = this.type.getName();
            _builder.append((Object)_name_5, "");
            _builder.append((Object)BUILDER, "");
            _builder.append((Object)" add");
            String _name_6 = this.augmentField.getName();
            String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_6);
            _builder.append((Object)_firstUpper_4, "");
            _builder.append((Object)"(");
            String _importedName_1 = this.importedName(Class.class);
            _builder.append((Object)_importedName_1, "");
            _builder.append((Object)"<? extends ");
            Type _returnType_7 = this.augmentField.getReturnType();
            String _importedName_2 = this.importedName(_returnType_7);
            _builder.append((Object)_importedName_2, "");
            _builder.append((Object)"> augmentationType, ");
            Type _returnType_8 = this.augmentField.getReturnType();
            String _importedName_3 = this.importedName(_returnType_8);
            _builder.append((Object)_importedName_3, "");
            _builder.append((Object)" augmentation) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"if (augmentation == null) {");
            _builder.newLine();
            _builder.append((Object)"        ");
            _builder.append((Object)"return remove");
            String _name_7 = this.augmentField.getName();
            String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_7);
            _builder.append((Object)_firstUpper_5, "        ");
            _builder.append((Object)"(augmentationType);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"if (!(this.");
            String _name_8 = this.augmentField.getName();
            _builder.append((Object)_name_8, "    ");
            _builder.append((Object)" instanceof ");
            String _importedName_4 = this.importedName(HashMap.class);
            _builder.append((Object)_importedName_4, "    ");
            _builder.append((Object)")) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        ");
            _builder.append((Object)"this.");
            String _name_9 = this.augmentField.getName();
            _builder.append((Object)_name_9, "        ");
            _builder.append((Object)" = new ");
            String _importedName_5 = this.importedName(HashMap.class);
            _builder.append((Object)_importedName_5, "        ");
            _builder.append((Object)"<>();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"this.");
            String _name_10 = this.augmentField.getName();
            _builder.append((Object)_name_10, "    ");
            _builder.append((Object)".put(augmentationType, augmentation);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"return this;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"public ");
            String _name_11 = this.type.getName();
            _builder.append((Object)_name_11, "");
            _builder.append((Object)BUILDER, "");
            _builder.append((Object)" remove");
            String _name_12 = this.augmentField.getName();
            String _firstUpper_6 = StringExtensions.toFirstUpper((String)_name_12);
            _builder.append((Object)_firstUpper_6, "");
            _builder.append((Object)"(");
            String _importedName_6 = this.importedName(Class.class);
            _builder.append((Object)_importedName_6, "");
            _builder.append((Object)"<? extends ");
            Type _returnType_9 = this.augmentField.getReturnType();
            String _importedName_7 = this.importedName(_returnType_9);
            _builder.append((Object)_importedName_7, "");
            _builder.append((Object)"> augmentationType) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"if (this.");
            String _name_13 = this.augmentField.getName();
            _builder.append((Object)_name_13, "    ");
            _builder.append((Object)" instanceof ");
            String _importedName_8 = this.importedName(HashMap.class);
            _builder.append((Object)_importedName_8, "    ");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        ");
            _builder.append((Object)"this.");
            String _name_14 = this.augmentField.getName();
            _builder.append((Object)_name_14, "        ");
            _builder.append((Object)".remove(augmentationType);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"return this;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence generateRestrictions(GeneratedProperty field, String paramName) {
        List _lengthConstraints;
        boolean _isEmpty;
        boolean _not;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        Type type = field.getReturnType();
        _builder.newLineIfNotEmpty();
        Restrictions restrictions = this.getRestrictions(type);
        _builder.newLineIfNotEmpty();
        boolean _and = false;
        boolean bl = _tripleNotEquals = restrictions != null;
        _and = !_tripleNotEquals ? false : (_not = !(_isEmpty = (_lengthConstraints = restrictions.getLengthConstraints()).isEmpty()));
        if (_and) {
            if (type instanceof ConcreteType) {
                CharSequence _fieldName = this.fieldName(field);
                String _string = _fieldName.toString();
                String _generateLengthCheckerCall = LengthGenerator.generateLengthCheckerCall(_string, paramName);
                _builder.append((Object)_generateLengthCheckerCall, "");
                _builder.newLineIfNotEmpty();
            } else {
                CharSequence _fieldName_1 = this.fieldName(field);
                String _string_1 = _fieldName_1.toString();
                String _generateLengthCheckerCall_1 = LengthGenerator.generateLengthCheckerCall(_string_1, paramName + ".getValue()");
                _builder.append((Object)_generateLengthCheckerCall_1, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    @Deprecated
    private CharSequence generateLengthMethod(String methodName, Type type) {
        List _lengthConstraints;
        boolean _isEmpty;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        Restrictions restrictions = this.getRestrictions(type);
        _builder.newLineIfNotEmpty();
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal((Object)restrictions, null);
        _and = !_notEquals ? false : (_not = !(_isEmpty = (_lengthConstraints = restrictions.getLengthConstraints()).isEmpty()));
        if (_and) {
            List _lengthConstraints_1 = restrictions.getLengthConstraints();
            Iterator _iterator = _lengthConstraints_1.iterator();
            LengthConstraint _next = (LengthConstraint)_iterator.next();
            Number _min = _next.getMin();
            Class<?> numberClass = _min.getClass();
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @deprecated This method is slated for removal in a future release. See BUG-1485 for details.");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"@Deprecated");
            _builder.newLine();
            _builder.append((Object)"public static ");
            String _importedName = this.importedName(List.class);
            _builder.append((Object)_importedName, "");
            _builder.append((Object)"<");
            String _importedName_1 = this.importedName(Range.class);
            _builder.append((Object)_importedName_1, "");
            _builder.append((Object)"<");
            String _importedNumber = this.importedNumber(numberClass);
            _builder.append((Object)_importedNumber, "");
            _builder.append((Object)">> ");
            _builder.append((Object)methodName, "");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            boolean _equals = numberClass.equals(BigDecimal.class);
            if (_equals) {
                _builder.append((Object)"    ");
                CharSequence _lengthBody = this.lengthBody(restrictions, numberClass);
                _builder.append((Object)_lengthBody, "    ");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"    ");
                CharSequence _lengthBody_1 = this.lengthBody(restrictions, BigInteger.class);
                _builder.append((Object)_lengthBody_1, "    ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    @Deprecated
    private CharSequence lengthBody(Restrictions restrictions, Class<? extends Number> numberClass) {
        StringConcatenation _builder = new StringConcatenation();
        String _importedName = this.importedName(List.class);
        _builder.append((Object)_importedName, "");
        _builder.append((Object)"<");
        String _importedName_1 = this.importedName(Range.class);
        _builder.append((Object)_importedName_1, "");
        _builder.append((Object)"<");
        String _importedName_2 = this.importedName(numberClass);
        _builder.append((Object)_importedName_2, "");
        _builder.append((Object)">> ret = new ");
        String _importedName_3 = this.importedName(ArrayList.class);
        _builder.append((Object)_importedName_3, "");
        _builder.append((Object)"<>(");
        List _lengthConstraints = restrictions.getLengthConstraints();
        int _size = _lengthConstraints.size();
        _builder.append((Object)_size, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        List _lengthConstraints_1 = restrictions.getLengthConstraints();
        for (LengthConstraint r : _lengthConstraints_1) {
            _builder.append((Object)"ret.add(");
            String _importedName_4 = this.importedName(Range.class);
            _builder.append((Object)_importedName_4, "");
            _builder.append((Object)".closed(");
            Number _min = r.getMin();
            String _numericValue = this.numericValue(numberClass, _min);
            _builder.append((Object)_numericValue, "");
            _builder.append((Object)", ");
            Number _max = r.getMax();
            String _numericValue_1 = this.numericValue(numberClass, _max);
            _builder.append((Object)_numericValue_1, "");
            _builder.append((Object)"));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"return ret;");
        _builder.newLine();
        return _builder;
    }

    @Deprecated
    private CharSequence generateRangeMethod(String methodName, Restrictions restrictions, Type returnType) {
        List _rangeConstraints;
        boolean _isEmpty;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal((Object)restrictions, null);
        _and = !_notEquals ? false : (_not = !(_isEmpty = (_rangeConstraints = restrictions.getRangeConstraints()).isEmpty()));
        if (_and) {
            String number = this.importedNumber(returnType);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @deprecated This method is slated for removal in a future release. See BUG-1485 for details.");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"@Deprecated");
            _builder.newLine();
            _builder.append((Object)"public static ");
            String _importedName = this.importedName(List.class);
            _builder.append((Object)_importedName, "");
            _builder.append((Object)"<");
            String _importedName_1 = this.importedName(Range.class);
            _builder.append((Object)_importedName_1, "");
            _builder.append((Object)"<");
            _builder.append((Object)number, "");
            _builder.append((Object)">> ");
            _builder.append((Object)methodName, "");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            String _fullyQualifiedName = returnType.getFullyQualifiedName();
            String _canonicalName = BigDecimal.class.getCanonicalName();
            boolean _equals = _fullyQualifiedName.equals(_canonicalName);
            if (_equals) {
                _builder.append((Object)"    ");
                List _rangeConstraints_1 = restrictions.getRangeConstraints();
                CharSequence _rangeBody = this.rangeBody(_rangeConstraints_1, BigDecimal.class);
                _builder.append((Object)_rangeBody, "    ");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"    ");
                List _rangeConstraints_2 = restrictions.getRangeConstraints();
                CharSequence _rangeBody_1 = this.rangeBody(_rangeConstraints_2, BigInteger.class);
                _builder.append((Object)_rangeBody_1, "    ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    @Deprecated
    private CharSequence rangeBody(List<RangeConstraint> restrictions, Class<? extends Number> numberClass) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"final ");
        String _importedName = this.importedName(List.class);
        _builder.append((Object)_importedName, "");
        _builder.append((Object)"<");
        String _importedName_1 = this.importedName(Range.class);
        _builder.append((Object)_importedName_1, "");
        _builder.append((Object)"<");
        String _importedName_2 = this.importedName(numberClass);
        _builder.append((Object)_importedName_2, "");
        _builder.append((Object)">> ret = new java.util.ArrayList<>(");
        int _size = restrictions.size();
        _builder.append((Object)_size, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        for (RangeConstraint r : restrictions) {
            _builder.append((Object)"ret.add(");
            String _importedName_3 = this.importedName(Range.class);
            _builder.append((Object)_importedName_3, "");
            _builder.append((Object)".closed(");
            Number _min = r.getMin();
            String _numericValue = this.numericValue(numberClass, _min);
            _builder.append((Object)_numericValue, "");
            _builder.append((Object)", ");
            Number _max = r.getMax();
            String _numericValue_1 = this.numericValue(numberClass, _max);
            _builder.append((Object)_numericValue_1, "");
            _builder.append((Object)"));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"return ret;");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateCopyConstructor(boolean impl) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        if (impl) {
            _builder.append((Object)"private");
        } else {
            _builder.append((Object)"public");
        }
        _builder.append((Object)" ");
        String _name = this.type.getName();
        _builder.append((Object)_name, "");
        if (impl) {
            _builder.append((Object)IMPL, "");
        } else {
            _builder.append((Object)BUILDER, "");
        }
        _builder.append((Object)"(");
        String _name_1 = this.type.getName();
        _builder.append((Object)_name_1, "");
        if (impl) {
            _builder.append((Object)BUILDER, "");
        }
        _builder.append((Object)" base) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        ArrayList<GeneratedProperty> allProps = new ArrayList<GeneratedProperty>(this.properties);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        ConcreteType _typeForClass = Types.typeForClass(Identifiable.class);
        ParameterizedType _parameterizedTypeFor = Types.parameterizedTypeFor((Type)_typeForClass, (Type[])new Type[]{this.type});
        boolean isList = this.implementsIfc(this.type, (Type)_parameterizedTypeFor);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        Type keyType = this.getKey(this.type);
        _builder.newLineIfNotEmpty();
        boolean _and = false;
        _and = !isList ? false : (_notEquals = !Objects.equal((Object)keyType, null));
        if (_and) {
            _builder.append((Object)"    ");
            List _properties = ((GeneratedTransferObject)keyType).getProperties();
            ArrayList keyProps = new ArrayList(_properties);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            Comparator<GeneratedProperty> _function = new Comparator<GeneratedProperty>(){

                @Override
                public int compare(GeneratedProperty p1, GeneratedProperty p2) {
                    String _name = p1.getName();
                    String _name_1 = p2.getName();
                    return _name.compareTo(_name_1);
                }
            };
            Collections.sort(keyProps, _function);
            _builder.newLineIfNotEmpty();
            for (GeneratedProperty field : keyProps) {
                _builder.append((Object)"    ");
                String _name_2 = field.getName();
                this.removeProperty(allProps, _name_2);
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"    ");
            this.removeProperty(allProps, "key");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"if (base.getKey() == null) {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"this._key = new ");
            String _importedName = this.importedName(keyType);
            _builder.append((Object)_importedName, "        ");
            _builder.append((Object)"(");
            _builder.newLineIfNotEmpty();
            boolean _hasElements = false;
            for (GeneratedProperty keyProp : keyProps) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "            ");
                }
                _builder.append((Object)"    ");
                _builder.append((Object)"        ");
                _builder.append((Object)"base.");
                String _terMethodName = this.getterMethodName(keyProp);
                _builder.append((Object)_terMethodName, "            ");
                _builder.append((Object)"()");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)");");
            _builder.newLine();
            for (GeneratedProperty field_1 : keyProps) {
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"this.");
                CharSequence _fieldName = this.fieldName(field_1);
                _builder.append((Object)_fieldName, "        ");
                _builder.append((Object)" = base.");
                String _terMethodName_1 = this.getterMethodName(field_1);
                _builder.append((Object)_terMethodName_1, "        ");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"} else {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"this._key = base.getKey();");
            _builder.newLine();
            for (GeneratedProperty field_2 : keyProps) {
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"this.");
                CharSequence _fieldName_1 = this.fieldName(field_2);
                _builder.append((Object)_fieldName_1, "        ");
                _builder.append((Object)" = _key.");
                String _terMethodName_2 = this.getterMethodName(field_2);
                _builder.append((Object)_terMethodName_2, "        ");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        for (GeneratedProperty field_3 : allProps) {
            _builder.append((Object)"    ");
            _builder.append((Object)"this.");
            CharSequence _fieldName_2 = this.fieldName(field_3);
            _builder.append((Object)_fieldName_2, "    ");
            _builder.append((Object)" = base.");
            String _terMethodName_3 = this.getterMethodName(field_3);
            _builder.append((Object)_terMethodName_3, "    ");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
        }
        boolean bl = _notEquals_1 = !Objects.equal((Object)this.augmentField, null);
        if (_notEquals_1) {
            if (impl) {
                _builder.append((Object)"    ");
                _builder.append((Object)"switch (base.");
                String _name_3 = this.augmentField.getName();
                _builder.append((Object)_name_3, "    ");
                _builder.append((Object)".size()) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"case 0:");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"this.");
                String _name_4 = this.augmentField.getName();
                _builder.append((Object)_name_4, "        ");
                _builder.append((Object)" = ");
                String _importedName_1 = this.importedName(Collections.class);
                _builder.append((Object)_importedName_1, "        ");
                _builder.append((Object)".emptyMap();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"case 1:");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"final ");
                String _importedName_2 = this.importedName(Map.class);
                _builder.append((Object)_importedName_2, "        ");
                _builder.append((Object)".Entry<");
                String _importedName_3 = this.importedName(Class.class);
                _builder.append((Object)_importedName_3, "        ");
                _builder.append((Object)"<? extends ");
                Type _returnType = this.augmentField.getReturnType();
                String _importedName_4 = this.importedName(_returnType);
                _builder.append((Object)_importedName_4, "        ");
                _builder.append((Object)">, ");
                Type _returnType_1 = this.augmentField.getReturnType();
                String _importedName_5 = this.importedName(_returnType_1);
                _builder.append((Object)_importedName_5, "        ");
                _builder.append((Object)"> e = base.");
                String _name_5 = this.augmentField.getName();
                _builder.append((Object)_name_5, "        ");
                _builder.append((Object)".entrySet().iterator().next();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"this.");
                String _name_6 = this.augmentField.getName();
                _builder.append((Object)_name_6, "        ");
                _builder.append((Object)" = ");
                String _importedName_6 = this.importedName(Collections.class);
                _builder.append((Object)_importedName_6, "        ");
                _builder.append((Object)".<");
                String _importedName_7 = this.importedName(Class.class);
                _builder.append((Object)_importedName_7, "        ");
                _builder.append((Object)"<? extends ");
                Type _returnType_2 = this.augmentField.getReturnType();
                String _importedName_8 = this.importedName(_returnType_2);
                _builder.append((Object)_importedName_8, "        ");
                _builder.append((Object)">, ");
                Type _returnType_3 = this.augmentField.getReturnType();
                String _importedName_9 = this.importedName(_returnType_3);
                _builder.append((Object)_importedName_9, "        ");
                _builder.append((Object)">singletonMap(e.getKey(), e.getValue());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"default :");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"this.");
                String _name_7 = this.augmentField.getName();
                _builder.append((Object)_name_7, "        ");
                _builder.append((Object)" = new ");
                String _importedName_10 = this.importedName(HashMap.class);
                _builder.append((Object)_importedName_10, "        ");
                _builder.append((Object)"<>(base.");
                String _name_8 = this.augmentField.getName();
                _builder.append((Object)_name_8, "        ");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
            } else {
                _builder.append((Object)"    ");
                _builder.append((Object)"if (base instanceof ");
                String _name_9 = this.type.getName();
                _builder.append((Object)_name_9, "    ");
                _builder.append((Object)IMPL, "    ");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                String _name_10 = this.type.getName();
                _builder.append((Object)_name_10, "        ");
                _builder.append((Object)IMPL, "        ");
                _builder.append((Object)" impl = (");
                String _name_11 = this.type.getName();
                _builder.append((Object)_name_11, "        ");
                _builder.append((Object)IMPL, "        ");
                _builder.append((Object)") base;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"if (!impl.");
                String _name_12 = this.augmentField.getName();
                _builder.append((Object)_name_12, "        ");
                _builder.append((Object)".isEmpty()) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"        ");
                _builder.append((Object)"this.");
                String _name_13 = this.augmentField.getName();
                _builder.append((Object)_name_13, "            ");
                _builder.append((Object)" = new ");
                String _importedName_11 = this.importedName(HashMap.class);
                _builder.append((Object)_importedName_11, "            ");
                _builder.append((Object)"<>(impl.");
                String _name_14 = this.augmentField.getName();
                _builder.append((Object)_name_14, "            ");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"} else if (base instanceof ");
                String _importedName_12 = this.importedName(AugmentationHolder.class);
                _builder.append((Object)_importedName_12, "    ");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"@SuppressWarnings(\"unchecked\")");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                String _importedName_13 = this.importedName(AugmentationHolder.class);
                _builder.append((Object)_importedName_13, "        ");
                _builder.append((Object)"<");
                String _importedName_14 = this.importedName((Type)this.type);
                _builder.append((Object)_importedName_14, "        ");
                _builder.append((Object)"> casted =(");
                String _importedName_15 = this.importedName(AugmentationHolder.class);
                _builder.append((Object)_importedName_15, "        ");
                _builder.append((Object)"<");
                String _importedName_16 = this.importedName((Type)this.type);
                _builder.append((Object)_importedName_16, "        ");
                _builder.append((Object)">) base;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"if (!casted.augmentations().isEmpty()) {");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"        ");
                _builder.append((Object)"this.");
                String _name_15 = this.augmentField.getName();
                _builder.append((Object)_name_15, "            ");
                _builder.append((Object)" = new ");
                String _importedName_17 = this.importedName(HashMap.class);
                _builder.append((Object)_importedName_17, "            ");
                _builder.append((Object)"<>(casted.augmentations());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private boolean implementsIfc(GeneratedType type, Type impl) {
        List _implements = type.getImplements();
        for (Type ifc : _implements) {
            boolean _equals = ifc.equals(impl);
            if (!_equals) continue;
            return true;
        }
        return false;
    }

    private Type getKey(GeneratedType type) {
        List _methodDefinitions = type.getMethodDefinitions();
        for (MethodSignature m : _methodDefinitions) {
            String _name = m.getName();
            boolean _equals = "getKey".equals(_name);
            if (!_equals) continue;
            return m.getReturnType();
        }
        return null;
    }

    private void removeProperty(Collection<GeneratedProperty> props, String name) {
        boolean _notEquals;
        GeneratedProperty toRemove = null;
        for (GeneratedProperty p : props) {
            String _name = p.getName();
            boolean _equals = _name.equals(name);
            if (!_equals) continue;
            toRemove = p;
        }
        boolean bl = _notEquals = !Objects.equal(toRemove, null);
        if (_notEquals) {
            props.remove(toRemove);
        }
    }

    private CharSequence generateGetters(boolean addOverride) {
        boolean _notEquals;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.properties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (GeneratedProperty field : this.properties) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n", "");
                }
                if (addOverride) {
                    _builder.append((Object)"@Override");
                }
                _builder.newLineIfNotEmpty();
                CharSequence _terMethod = this.getterMethod(field);
                _builder.append((Object)_terMethod, "");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl2 = _notEquals = !Objects.equal((Object)this.augmentField, null);
        if (_notEquals) {
            _builder.newLine();
            _builder.append((Object)"@SuppressWarnings(\"unchecked\")");
            _builder.newLine();
            if (addOverride) {
                _builder.append((Object)"@Override");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"public <E extends ");
            Type _returnType = this.augmentField.getReturnType();
            String _importedName = this.importedName(_returnType);
            _builder.append((Object)_importedName, "");
            _builder.append((Object)"> E get");
            String _name = this.augmentField.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name);
            _builder.append((Object)_firstUpper, "");
            _builder.append((Object)"(");
            String _importedName_1 = this.importedName(Class.class);
            _builder.append((Object)_importedName_1, "");
            _builder.append((Object)"<E> augmentationType) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"if (augmentationType == null) {");
            _builder.newLine();
            _builder.append((Object)"        ");
            _builder.append((Object)"throw new IllegalArgumentException(\"Augmentation Type reference cannot be NULL!\");");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"return (E) ");
            String _name_1 = this.augmentField.getName();
            _builder.append((Object)_name_1, "    ");
            _builder.append((Object)".get(augmentationType);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateHashCode() {
        boolean _notEquals;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _or = false;
        boolean _isEmpty = this.properties.isEmpty();
        boolean bl = _not = !_isEmpty;
        _or = _not ? true : (_notEquals = !Objects.equal((Object)this.augmentField, null));
        if (_or) {
            boolean _notEquals_1;
            _builder.append((Object)"private int hash = 0;");
            _builder.newLine();
            _builder.append((Object)"private volatile boolean hashValid = false;");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"public int hashCode() {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"if (hashValid) {");
            _builder.newLine();
            _builder.append((Object)"        ");
            _builder.append((Object)"return hash;");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"final int prime = 31;");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"int result = 1;");
            _builder.newLine();
            for (GeneratedProperty property : this.properties) {
                Type _returnType = property.getReturnType();
                String _name = _returnType.getName();
                boolean _contains = _name.contains("[");
                if (_contains) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"result = prime * result + ((");
                    CharSequence _fieldName = this.fieldName(property);
                    _builder.append((Object)_fieldName, "    ");
                    _builder.append((Object)" == null) ? 0 : ");
                    String _importedName = this.importedName(Arrays.class);
                    _builder.append((Object)_importedName, "    ");
                    _builder.append((Object)".hashCode(");
                    CharSequence _fieldName_1 = this.fieldName(property);
                    _builder.append((Object)_fieldName_1, "    ");
                    _builder.append((Object)"));");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"    ");
                _builder.append((Object)"result = prime * result + ((");
                CharSequence _fieldName_2 = this.fieldName(property);
                _builder.append((Object)_fieldName_2, "    ");
                _builder.append((Object)" == null) ? 0 : ");
                CharSequence _fieldName_3 = this.fieldName(property);
                _builder.append((Object)_fieldName_3, "    ");
                _builder.append((Object)".hashCode());");
                _builder.newLineIfNotEmpty();
            }
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)this.augmentField, null);
            if (_notEquals_1) {
                _builder.append((Object)"    ");
                _builder.append((Object)"result = prime * result + ((");
                String _name_1 = this.augmentField.getName();
                _builder.append((Object)_name_1, "    ");
                _builder.append((Object)" == null) ? 0 : ");
                String _name_2 = this.augmentField.getName();
                _builder.append((Object)_name_2, "    ");
                _builder.append((Object)".hashCode());");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"hash = result;");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"hashValid = true;");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"return result;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateEquals() {
        boolean _notEquals;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _or = false;
        boolean _isEmpty = this.properties.isEmpty();
        boolean bl = _not = !_isEmpty;
        _or = _not ? true : (_notEquals = !Objects.equal((Object)this.augmentField, null));
        if (_or) {
            boolean _notEquals_1;
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"public boolean equals(");
            String _importedName = this.importedName(Object.class);
            _builder.append((Object)_importedName, "");
            _builder.append((Object)" obj) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"if (this == obj) {");
            _builder.newLine();
            _builder.append((Object)"        ");
            _builder.append((Object)"return true;");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"if (!(obj instanceof ");
            String _importedName_1 = this.importedName(DataObject.class);
            _builder.append((Object)_importedName_1, "    ");
            _builder.append((Object)")) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        ");
            _builder.append((Object)"return false;");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"if (!");
            String _importedName_2 = this.importedName((Type)this.type);
            _builder.append((Object)_importedName_2, "    ");
            _builder.append((Object)".class.equals(((");
            String _importedName_3 = this.importedName(DataObject.class);
            _builder.append((Object)_importedName_3, "    ");
            _builder.append((Object)")obj).getImplementedInterface())) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        ");
            _builder.append((Object)"return false;");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"    ");
            String _importedName_4 = this.importedName((Type)this.type);
            _builder.append((Object)_importedName_4, "    ");
            _builder.append((Object)" other = (");
            String _importedName_5 = this.importedName((Type)this.type);
            _builder.append((Object)_importedName_5, "    ");
            _builder.append((Object)")obj;");
            _builder.newLineIfNotEmpty();
            for (GeneratedProperty property : this.properties) {
                _builder.append((Object)"    ");
                CharSequence fieldName = this.fieldName(property);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"if (");
                _builder.append((Object)fieldName, "    ");
                _builder.append((Object)" == null) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"if (other.");
                String _terMethodName = this.getterMethodName(property);
                _builder.append((Object)_terMethodName, "        ");
                _builder.append((Object)"() != null) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"        ");
                _builder.append((Object)"return false;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                Type _returnType = property.getReturnType();
                String _name = _returnType.getName();
                boolean _contains = _name.contains("[");
                if (_contains) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"} else if(!");
                    String _importedName_6 = this.importedName(Arrays.class);
                    _builder.append((Object)_importedName_6, "    ");
                    _builder.append((Object)".equals(");
                    _builder.append((Object)fieldName, "    ");
                    _builder.append((Object)", other.");
                    String _terMethodName_1 = this.getterMethodName(property);
                    _builder.append((Object)_terMethodName_1, "    ");
                    _builder.append((Object)"())) {");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"} else if(!");
                    _builder.append((Object)fieldName, "    ");
                    _builder.append((Object)".equals(other.");
                    String _terMethodName_2 = this.getterMethodName(property);
                    _builder.append((Object)_terMethodName_2, "    ");
                    _builder.append((Object)"())) {");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"return false;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)this.augmentField, null);
            if (_notEquals_1) {
                _builder.append((Object)"    ");
                _builder.append((Object)"if (getClass() == obj.getClass()) {");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"// Simple case: we are comparing against self");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                String _name_1 = this.type.getName();
                _builder.append((Object)_name_1, "        ");
                _builder.append((Object)IMPL, "        ");
                _builder.append((Object)" otherImpl = (");
                String _name_2 = this.type.getName();
                _builder.append((Object)_name_2, "        ");
                _builder.append((Object)IMPL, "        ");
                _builder.append((Object)") obj;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                String fieldName_1 = this.augmentField.getName();
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"if (");
                _builder.append((Object)fieldName_1, "        ");
                _builder.append((Object)" == null) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"        ");
                _builder.append((Object)"if (otherImpl.");
                _builder.append((Object)fieldName_1, "            ");
                _builder.append((Object)" != null) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"            ");
                _builder.append((Object)"return false;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"        ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"} else if(!");
                _builder.append((Object)fieldName_1, "        ");
                _builder.append((Object)".equals(otherImpl.");
                _builder.append((Object)fieldName_1, "        ");
                _builder.append((Object)")) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"        ");
                _builder.append((Object)"return false;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"} else {");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"// Hard case: compare our augments with presence there...");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"for (");
                String _importedName_7 = this.importedName(Map.class);
                _builder.append((Object)_importedName_7, "        ");
                _builder.append((Object)".Entry<");
                String _importedName_8 = this.importedName(Class.class);
                _builder.append((Object)_importedName_8, "        ");
                _builder.append((Object)"<? extends ");
                Type _returnType_1 = this.augmentField.getReturnType();
                String _importedName_9 = this.importedName(_returnType_1);
                _builder.append((Object)_importedName_9, "        ");
                _builder.append((Object)">, ");
                Type _returnType_2 = this.augmentField.getReturnType();
                String _importedName_10 = this.importedName(_returnType_2);
                _builder.append((Object)_importedName_10, "        ");
                _builder.append((Object)"> e : ");
                String _name_3 = this.augmentField.getName();
                _builder.append((Object)_name_3, "        ");
                _builder.append((Object)".entrySet()) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"        ");
                _builder.append((Object)"if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"            ");
                _builder.append((Object)"return false;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"        ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"// .. and give the other one the chance to do the same");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"if (!obj.equals(this)) {");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"        ");
                _builder.append((Object)"return false;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"return true;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    @Override
    public CharSequence generateToString(Collection<GeneratedProperty> properties) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _tripleEquals = properties == null;
        boolean bl = _not = !_tripleEquals;
        if (_not) {
            boolean _notEquals;
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"public ");
            String _importedName = this.importedName(String.class);
            _builder.append((Object)_importedName, "");
            _builder.append((Object)" toString() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            String _importedName_1 = this.importedName(StringBuilder.class);
            _builder.append((Object)_importedName_1, "    ");
            _builder.append((Object)" builder = new ");
            String _importedName_2 = this.importedName(StringBuilder.class);
            _builder.append((Object)_importedName_2, "    ");
            _builder.append((Object)" (\"");
            String _name = this.type.getName();
            _builder.append((Object)_name, "    ");
            _builder.append((Object)" [\");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"boolean first = true;");
            _builder.newLine();
            _builder.newLine();
            for (GeneratedProperty property : properties) {
                _builder.append((Object)"    ");
                _builder.append((Object)"if (");
                CharSequence _fieldName = this.fieldName(property);
                _builder.append((Object)_fieldName, "    ");
                _builder.append((Object)" != null) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"if (first) {");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"        ");
                _builder.append((Object)"first = false;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"} else {");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"        ");
                _builder.append((Object)"builder.append(\", \");");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"builder.append(\"");
                CharSequence _fieldName_1 = this.fieldName(property);
                _builder.append((Object)_fieldName_1, "        ");
                _builder.append((Object)"=\");");
                _builder.newLineIfNotEmpty();
                Type _returnType = property.getReturnType();
                String _name_1 = _returnType.getName();
                boolean _contains = _name_1.contains("[");
                if (_contains) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    _builder.append((Object)"builder.append(");
                    String _importedName_3 = this.importedName(Arrays.class);
                    _builder.append((Object)_importedName_3, "        ");
                    _builder.append((Object)".toString(");
                    CharSequence _fieldName_2 = this.fieldName(property);
                    _builder.append((Object)_fieldName_2, "        ");
                    _builder.append((Object)"));");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    _builder.append((Object)"builder.append(");
                    CharSequence _fieldName_3 = this.fieldName(property);
                    _builder.append((Object)_fieldName_3, "        ");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"    ");
                _builder.append((Object)" ");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            boolean bl2 = _notEquals = !Objects.equal((Object)this.augmentField, null);
            if (_notEquals) {
                _builder.append((Object)"    ");
                _builder.append((Object)"if (first) {");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"first = false;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"} else {");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"builder.append(\", \");");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"builder.append(\"");
                String _name_2 = this.augmentField.getName();
                _builder.append((Object)_name_2, "    ");
                _builder.append((Object)"=\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"builder.append(");
                String _name_3 = this.augmentField.getName();
                _builder.append((Object)_name_3, "    ");
                _builder.append((Object)".values());");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"return builder.append(']').toString();");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence implementedInterfaceGetter() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public ");
        String _importedName = this.importedName(Class.class);
        _builder.append((Object)_importedName, "");
        _builder.append((Object)"<");
        String _importedName_1 = this.importedName((Type)this.type);
        _builder.append((Object)_importedName_1, "");
        _builder.append((Object)"> getImplementedInterface() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"return ");
        String _importedName_2 = this.importedName((Type)this.type);
        _builder.append((Object)_importedName_2, "    ");
        _builder.append((Object)".class;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private String createDescription(GeneratedType type) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Class that builds {@link ");
        String _importedName = this.importedName((Type)type);
        _builder.append((Object)_importedName, "");
        _builder.append((Object)"} instances.");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"@see ");
        String _importedName_1 = this.importedName((Type)type);
        _builder.append((Object)_importedName_1, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    @Override
    protected String formatDataForJavaDoc(GeneratedType type) {
        boolean _not;
        String typeDescription = this.createDescription(type);
        StringConcatenation _builder = new StringConcatenation();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)typeDescription);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append((Object)typeDescription, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }
}

