/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import org.opendaylight.yangtools.sal.binding.model.api.CodeGenerator;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.java.api.generator.BuilderTemplate;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public final class BuilderGenerator
implements CodeGenerator {
    public static final String BUILDER = "Builder";

    public boolean isAcceptable(Type type) {
        if (type instanceof GeneratedType && !(type instanceof GeneratedTransferObject)) {
            for (Type t : ((GeneratedType)type).getImplements()) {
                if (t.getFullyQualifiedName().equals(Augmentable.class.getName())) {
                    return true;
                }
                if (!t.getFullyQualifiedName().equals(Augmentation.class.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public String generate(Type type) {
        if (type instanceof GeneratedType && !(type instanceof GeneratedTransferObject)) {
            GeneratedType genType = (GeneratedType)type;
            BuilderTemplate template = new BuilderTemplate(genType);
            return template.generate();
        }
        return "";
    }

    public String getUnitName(Type type) {
        return type.getName() + BUILDER;
    }
}

