/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import java.math.BigInteger;
import org.opendaylight.yangtools.sal.java.api.generator.AbstractBigRangeGenerator;

final class BigIntegerRangeGenerator
extends AbstractBigRangeGenerator<BigInteger> {
    BigIntegerRangeGenerator() {
        super(BigInteger.class);
    }

    @Override
    protected String format(BigInteger value) {
        if (BigInteger.ZERO.equals(value)) {
            return "java.math.BigInteger.ZERO";
        }
        if (BigInteger.ONE.equals(value)) {
            return "java.math.BigInteger.ONE";
        }
        if (BigInteger.TEN.equals(value)) {
            return "java.math.BigInteger.TEN";
        }
        long l = value.longValue();
        if (value.equals(BigInteger.valueOf(l))) {
            return "java.math.BigInteger.valueOf(" + l + "L)";
        }
        return "new java.math.BigInteger(\"" + value.toString() + "\")";
    }

    @Override
    protected BigInteger convert(Number value) {
        return BigInteger.valueOf(value.longValue());
    }
}

