/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.opendaylight.yangtools.sal.java.api.generator.AbstractBigRangeGenerator;

final class BigDecimalRangeGenerator
extends AbstractBigRangeGenerator<BigDecimal> {
    BigDecimalRangeGenerator() {
        super(BigDecimal.class);
    }

    @Override
    protected String format(BigDecimal value) {
        if (BigDecimal.ZERO.equals(value)) {
            return "java.math.BigDecimal.ZERO";
        }
        if (BigDecimal.ONE.equals(value)) {
            return "java.math.BigDecimal.ONE";
        }
        if (BigDecimal.TEN.equals(value)) {
            return "java.math.BigDecimal.TEN";
        }
        return "new java.math.BigDecimal(\"" + value + "\")";
    }

    @Override
    protected BigDecimal convert(Number value) {
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Byte) {
            return new BigDecimal(value.intValue());
        }
        if (value instanceof Short) {
            return new BigDecimal(value.intValue());
        }
        if (value instanceof Integer) {
            return new BigDecimal(value.intValue());
        }
        return BigDecimal.valueOf(value.longValue());
    }
}

