/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.opendaylight.yangtools.binding.generator.util.Types;
import org.opendaylight.yangtools.sal.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.sal.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.sal.binding.model.api.Restrictions;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.java.api.generator.GeneratorUtil;

public abstract class BaseTemplate {
    protected final GeneratedType type;
    protected final Map<String, String> importMap;
    private static final char NEW_LINE = '\n';
    private static final CharMatcher NL_MATCHER = CharMatcher.is((char)'\n');
    private static final CharMatcher TAB_MATCHER = CharMatcher.is((char)'\t');
    private static final Pattern SPACES_PATTERN = Pattern.compile(" +");
    private static final Splitter NL_SPLITTER = Splitter.on((CharMatcher)NL_MATCHER);
    private static final CharMatcher AMP_MATCHER = CharMatcher.is((char)'&');
    private static final CharMatcher GT_MATCHER = CharMatcher.is((char)'>');
    private static final CharMatcher LT_MATCHER = CharMatcher.is((char)'<');

    public BaseTemplate(GeneratedType _type) {
        boolean _equals = Objects.equal((Object)_type, null);
        if (_equals) {
            throw new IllegalArgumentException("Generated type reference cannot be NULL!");
        }
        this.type = _type;
        HashMap<String, String> _hashMap = new HashMap<String, String>();
        this.importMap = _hashMap;
    }

    public CharSequence packageDefinition() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _packageName = this.type.getPackageName();
        _builder.append((Object)_packageName, "");
        _builder.append((Object)";");
        return _builder;
    }

    public final String generate() {
        String _xblockexpression = null;
        CharSequence _body = this.body();
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageDefinition = this.packageDefinition();
        _builder.append((Object)_packageDefinition, "");
        _builder.newLineIfNotEmpty();
        CharSequence _imports = this.imports();
        _builder.append((Object)_imports, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)_body, "");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    protected CharSequence imports() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.importMap.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Set<Map.Entry<String, String>> _entrySet = this.importMap.entrySet();
            for (Map.Entry<String, String> entry : _entrySet) {
                String _value = entry.getValue();
                boolean _hasSamePackage = this.hasSamePackage(_value);
                boolean _not_1 = !_hasSamePackage;
                if (!_not_1) continue;
                _builder.append((Object)"import ");
                String _value_1 = entry.getValue();
                _builder.append((Object)_value_1, "");
                _builder.append((Object)".");
                String _key = entry.getKey();
                _builder.append((Object)_key, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        return _builder;
    }

    private final boolean hasSamePackage(String importedTypePackageName) {
        String _packageName = this.type.getPackageName();
        return _packageName.equals(importedTypePackageName);
    }

    protected abstract CharSequence body();

    protected final CharSequence fieldName(GeneratedProperty property) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"_");
        String _name = property.getName();
        _builder.append((Object)_name, "");
        return _builder;
    }

    protected final String propertyNameFromGetter(MethodSignature getter) {
        int prefix = 0;
        String _name = getter.getName();
        boolean _startsWith = _name.startsWith("is");
        if (_startsWith) {
            prefix = 2;
        } else {
            String _name_1 = getter.getName();
            boolean _startsWith_1 = _name_1.startsWith("get");
            if (_startsWith_1) {
                prefix = 3;
            } else {
                throw new IllegalArgumentException("Not a getter");
            }
        }
        String _name_2 = getter.getName();
        String _substring = _name_2.substring(prefix);
        return StringExtensions.toFirstLower((String)_substring);
    }

    protected final CharSequence getterMethod(GeneratedProperty field) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public ");
        Type _returnType = field.getReturnType();
        String _importedName = this.importedName(_returnType);
        _builder.append((Object)_importedName, "");
        _builder.append((Object)" ");
        String _terMethodName = this.getterMethodName(field);
        _builder.append((Object)_terMethodName, "");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        Type _returnType_1 = field.getReturnType();
        String _importedName_1 = this.importedName(_returnType_1);
        boolean _contains = _importedName_1.contains("[]");
        if (_contains) {
            _builder.append((Object)"    ");
            _builder.append((Object)"return ");
            CharSequence _fieldName = this.fieldName(field);
            _builder.append((Object)_fieldName, "    ");
            _builder.append((Object)" == null ? null : ");
            CharSequence _fieldName_1 = this.fieldName(field);
            _builder.append((Object)_fieldName_1, "    ");
            _builder.append((Object)".clone();");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append((Object)"    ");
            _builder.append((Object)"return ");
            CharSequence _fieldName_2 = this.fieldName(field);
            _builder.append((Object)_fieldName_2, "    ");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected final String getterMethodName(GeneratedProperty field) {
        String _xifexpression = null;
        Type _returnType = field.getReturnType();
        boolean _equals = _returnType.equals(Types.BOOLEAN);
        _xifexpression = _equals ? "is" : "get";
        String prefix = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)prefix, "");
        String _name = field.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        return _builder.toString();
    }

    protected final CharSequence setterMethod(GeneratedProperty field) {
        StringConcatenation _builder = new StringConcatenation();
        Type _returnType = field.getReturnType();
        String returnType = this.importedName(_returnType);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public ");
        String _name = this.type.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" set");
        String _name_1 = field.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"(");
        _builder.append((Object)returnType, "");
        _builder.append((Object)" value) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"this.");
        CharSequence _fieldName = this.fieldName(field);
        _builder.append((Object)_fieldName, "    ");
        _builder.append((Object)" = value;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected final String importedName(Type intype) {
        String _xblockexpression = null;
        GeneratorUtil.putTypeIntoImports(this.type, intype, this.importMap);
        _xblockexpression = GeneratorUtil.getExplicitType(this.type, intype, this.importMap);
        return _xblockexpression;
    }

    protected final String importedName(Class<?> cls) {
        ConcreteType _typeForClass = Types.typeForClass(cls);
        return this.importedName((Type)_typeForClass);
    }

    protected final CharSequence asArgumentsDeclaration(Iterable<GeneratedProperty> parameters) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = IterableExtensions.isEmpty(parameters);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (GeneratedProperty parameter : parameters) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                Type _returnType = parameter.getReturnType();
                String _importedName = this.importedName(_returnType);
                _builder.append((Object)_importedName, "");
                _builder.append((Object)" ");
                CharSequence _fieldName = this.fieldName(parameter);
                _builder.append((Object)_fieldName, "");
            }
        }
        return _builder;
    }

    protected final CharSequence asArguments(Iterable<GeneratedProperty> parameters) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = IterableExtensions.isEmpty(parameters);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (GeneratedProperty parameter : parameters) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _fieldName = this.fieldName(parameter);
                _builder.append((Object)_fieldName, "");
            }
        }
        return _builder;
    }

    protected CharSequence asJavadoc(String comment) {
        String _formatToParagraph;
        String _trim;
        boolean _equals = Objects.equal((Object)comment, null);
        if (_equals) {
            return "";
        }
        String txt = comment;
        txt = _trim = comment.trim();
        txt = _formatToParagraph = this.formatToParagraph(txt);
        StringConcatenation _builder = new StringConcatenation();
        String _wrapToDocumentation = this.wrapToDocumentation(txt);
        _builder.append((Object)_wrapToDocumentation, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public String wrapToDocumentation(String text) {
        boolean _isEmpty = text.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringBuilder sb = new StringBuilder("/**");
        sb.append('\n');
        Iterable _split = NL_SPLITTER.split((CharSequence)text);
        for (String t : _split) {
            boolean _not;
            sb.append(" *");
            boolean _isEmpty_1 = t.isEmpty();
            boolean bl = _not = !_isEmpty_1;
            if (_not) {
                sb.append(" ");
                sb.append(t);
            }
            sb.append('\n');
        }
        sb.append(" */");
        return sb.toString();
    }

    protected String formatDataForJavaDoc(GeneratedType type) {
        boolean _not;
        String _description = type.getDescription();
        String typeDescription = this.encodeJavadocSymbols(_description);
        StringConcatenation _builder = new StringConcatenation();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)typeDescription);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append((Object)typeDescription, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    public String encodeJavadocSymbols(String description) {
        String _replaceFrom_2;
        String _replaceFrom_1;
        String _replaceFrom;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)description);
        if (_isNullOrEmpty) {
            return description;
        }
        String ret = description.replace("*/", "&#42;&#47;");
        ret = _replaceFrom = AMP_MATCHER.replaceFrom((CharSequence)ret, (CharSequence)"&amp;");
        ret = _replaceFrom_1 = GT_MATCHER.replaceFrom((CharSequence)ret, (CharSequence)"&gt;");
        ret = _replaceFrom_2 = LT_MATCHER.replaceFrom((CharSequence)ret, (CharSequence)"&lt;");
        return ret;
    }

    protected String formatDataForJavaDoc(GeneratedType type, String additionalComment) {
        boolean _not;
        StringBuilder typeDescription = new StringBuilder();
        String _description = type.getDescription();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_description);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _description_1 = type.getDescription();
            typeDescription.append(_description_1);
            typeDescription.append('\n');
            typeDescription.append('\n');
            typeDescription.append('\n');
            typeDescription.append(additionalComment);
        } else {
            typeDescription.append(additionalComment);
        }
        StringConcatenation _builder = new StringConcatenation();
        String _string = typeDescription.toString();
        _builder.append((Object)_string, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String asLink(String text) {
        boolean _endsWith_2;
        boolean _endsWith_1;
        StringBuilder sb = new StringBuilder();
        String tempText = text;
        char lastChar = ' ';
        boolean badEnding = false;
        boolean _or = false;
        boolean _or_1 = false;
        boolean _endsWith = text.endsWith(".");
        _or_1 = _endsWith ? true : (_endsWith_1 = text.endsWith(":"));
        _or = _or_1 ? true : (_endsWith_2 = text.endsWith(","));
        if (_or) {
            char _charAt;
            String _substring;
            int _length = text.length();
            int _minus = _length - 1;
            tempText = _substring = text.substring(0, _minus);
            int _length_1 = text.length();
            int _minus_1 = _length_1 - 1;
            lastChar = _charAt = text.charAt(_minus_1);
            badEnding = true;
        }
        sb.append("<a href = \"");
        sb.append(tempText);
        sb.append("\">");
        sb.append(tempText);
        sb.append("</a>");
        if (badEnding) {
            sb.append(lastChar);
        }
        return sb.toString();
    }

    protected String formatToParagraph(String text) {
        String _replaceAll;
        String _removeFrom_1;
        String _removeFrom;
        String _encodeJavadocSymbols;
        boolean _isEmpty;
        boolean _or = false;
        boolean _equals = Objects.equal((Object)text, null);
        _or = _equals ? true : (_isEmpty = text.isEmpty());
        if (_or) {
            return text;
        }
        String formattedText = text;
        StringBuilder sb = new StringBuilder();
        StringBuilder lineBuilder = new StringBuilder();
        boolean isFirstElementOnNewLineEmptyChar = false;
        formattedText = _encodeJavadocSymbols = this.encodeJavadocSymbols(formattedText);
        formattedText = _removeFrom = NL_MATCHER.removeFrom((CharSequence)formattedText);
        formattedText = _removeFrom_1 = TAB_MATCHER.removeFrom((CharSequence)formattedText);
        Matcher _matcher = SPACES_PATTERN.matcher(formattedText);
        formattedText = _replaceAll = _matcher.replaceAll(" ");
        StringTokenizer tokenizer = new StringTokenizer(formattedText, " ", true);
        while (tokenizer.hasMoreElements()) {
            boolean _greaterThan;
            int _length_1;
            Object _nextElement = tokenizer.nextElement();
            String nextElement = _nextElement.toString();
            int _length = lineBuilder.length();
            int _plus = _length + (_length_1 = nextElement.length());
            boolean bl = _greaterThan = _plus > 80;
            if (_greaterThan) {
                char _charAt_1;
                boolean _equals_2;
                int _length_2 = lineBuilder.length();
                int _minus = _length_2 - 1;
                char _charAt = lineBuilder.charAt(_minus);
                boolean _equals_1 = Objects.equal((Object)Character.valueOf(_charAt), (Object)" ");
                if (_equals_1) {
                    lineBuilder.setLength(0);
                    int _length_3 = lineBuilder.length();
                    int _minus_1 = _length_3 - 1;
                    String _substring = lineBuilder.substring(0, _minus_1);
                    lineBuilder.append(_substring);
                }
                if (_equals_2 = Objects.equal((Object)Character.valueOf(_charAt_1 = lineBuilder.charAt(0)), (Object)" ")) {
                    lineBuilder.setLength(0);
                    String _substring_1 = lineBuilder.substring(1);
                    lineBuilder.append(_substring_1);
                }
                sb.append((CharSequence)lineBuilder);
                lineBuilder.setLength(0);
                sb.append('\n');
                String _string = nextElement.toString();
                boolean _equals_3 = Objects.equal((Object)_string, (Object)" ");
                if (_equals_3) {
                    boolean bl2 = isFirstElementOnNewLineEmptyChar = !isFirstElementOnNewLineEmptyChar;
                }
            }
            if (isFirstElementOnNewLineEmptyChar) {
                isFirstElementOnNewLineEmptyChar = !isFirstElementOnNewLineEmptyChar;
                continue;
            }
            lineBuilder.append(nextElement);
        }
        sb.append((CharSequence)lineBuilder);
        sb.append('\n');
        return sb.toString();
    }

    protected CharSequence generateToString(Collection<GeneratedProperty> properties) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = properties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"public ");
            String _importedName = this.importedName(String.class);
            _builder.append((Object)_importedName, "");
            _builder.append((Object)" toString() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            String _importedName_1 = this.importedName(StringBuilder.class);
            _builder.append((Object)_importedName_1, "    ");
            _builder.append((Object)" builder = new ");
            String _importedName_2 = this.importedName(StringBuilder.class);
            _builder.append((Object)_importedName_2, "    ");
            _builder.append((Object)"(");
            String _importedName_3 = this.importedName((Type)this.type);
            _builder.append((Object)_importedName_3, "    ");
            _builder.append((Object)".class.getSimpleName()).append(\" [\");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"boolean first = true;");
            _builder.newLine();
            _builder.newLine();
            for (GeneratedProperty property : properties) {
                _builder.append((Object)"    ");
                _builder.append((Object)"if (");
                CharSequence _fieldName = this.fieldName(property);
                _builder.append((Object)_fieldName, "    ");
                _builder.append((Object)" != null) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"if (first) {");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"        ");
                _builder.append((Object)"first = false;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"} else {");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"        ");
                _builder.append((Object)"builder.append(\", \");");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"builder.append(\"");
                CharSequence _fieldName_1 = this.fieldName(property);
                _builder.append((Object)_fieldName_1, "        ");
                _builder.append((Object)"=\");");
                _builder.newLineIfNotEmpty();
                Type _returnType = property.getReturnType();
                String _name = _returnType.getName();
                boolean _contains = _name.contains("[");
                if (_contains) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    _builder.append((Object)"builder.append(");
                    String _importedName_4 = this.importedName(Arrays.class);
                    _builder.append((Object)_importedName_4, "        ");
                    _builder.append((Object)".toString(");
                    CharSequence _fieldName_2 = this.fieldName(property);
                    _builder.append((Object)_fieldName_2, "        ");
                    _builder.append((Object)"));");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    _builder.append((Object)"builder.append(");
                    CharSequence _fieldName_3 = this.fieldName(property);
                    _builder.append((Object)_fieldName_3, "        ");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"    ");
                _builder.append((Object)" ");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"return builder.append(']').toString();");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public Restrictions getRestrictions(Type type) {
        Restrictions restrictions = null;
        if (type instanceof ConcreteType) {
            Restrictions _restrictions;
            restrictions = _restrictions = ((ConcreteType)type).getRestrictions();
        } else if (type instanceof GeneratedTransferObject) {
            Restrictions _restrictions_1;
            restrictions = _restrictions_1 = ((GeneratedTransferObject)type).getRestrictions();
        }
        return restrictions;
    }

    protected CharSequence generateParameters(List<MethodSignature.Parameter> parameters) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = parameters.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (MethodSignature.Parameter parameter : parameters) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                Type _type = parameter.getType();
                String _importedName = this.importedName(_type);
                _builder.append((Object)_importedName, "");
                _builder.append((Object)" ");
                String _name = parameter.getName();
                _builder.append((Object)_name, "");
            }
        }
        return _builder;
    }

    @Deprecated
    protected String importedNumber(Class<? extends Number> clazz) {
        boolean _equals = clazz.equals(BigDecimal.class);
        if (_equals) {
            return this.importedName(BigDecimal.class);
        }
        return this.importedName(BigInteger.class);
    }

    @Deprecated
    protected String importedNumber(Type clazz) {
        String _canonicalName;
        String _fullyQualifiedName = clazz.getFullyQualifiedName();
        boolean _equals = _fullyQualifiedName.equals(_canonicalName = BigDecimal.class.getCanonicalName());
        if (_equals) {
            return this.importedName(BigDecimal.class);
        }
        return this.importedName(BigInteger.class);
    }

    @Deprecated
    protected String numericValue(Class<? extends Number> clazz, Object numberValue) {
        String value;
        String number;
        block10: {
            boolean _equals_1;
            number = this.importedName(clazz);
            value = numberValue.toString();
            boolean _or = false;
            boolean _equals = clazz.equals(BigInteger.class);
            _or = _equals ? true : (_equals_1 = clazz.equals(BigDecimal.class));
            if (_or) {
                boolean _equals_2 = value.equals("0");
                if (_equals_2) {
                    return number + ".ZERO";
                }
                boolean _equals_3 = value.equals("1");
                if (_equals_3) {
                    return number + ".ONE";
                }
                boolean _equals_4 = value.equals("10");
                if (_equals_4) {
                    return number + ".TEN";
                }
                try {
                    Long longVal = Long.valueOf(value);
                    return number + ".valueOf(" + longVal + "L)";
                }
                catch (Throwable _t) {
                    if (_t instanceof NumberFormatException) {
                        NumberFormatException e = (NumberFormatException)_t;
                        boolean _equals_5 = clazz.equals(BigDecimal.class);
                        if (!_equals_5) break block10;
                        try {
                            Double doubleVal = Double.valueOf(value);
                            return number + ".valueOf(" + doubleVal + ")";
                        }
                        catch (Throwable _t_1) {
                            if (_t_1 instanceof NumberFormatException) {
                                NumberFormatException e2 = (NumberFormatException)_t_1;
                                break block10;
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t_1);
                        }
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
        return "new " + number + "(\"" + value + "\")";
    }

    protected GeneratedProperty findProperty(GeneratedTransferObject gto, String name) {
        boolean _notEquals;
        List props = gto.getProperties();
        for (GeneratedProperty prop : props) {
            String _name = prop.getName();
            boolean _equals = _name.equals(name);
            if (!_equals) continue;
            return prop;
        }
        GeneratedTransferObject parent = gto.getSuperType();
        boolean bl = _notEquals = !Objects.equal((Object)parent, null);
        if (_notEquals) {
            return this.findProperty(parent, name);
        }
        return null;
    }
}

