/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.sal.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.java.api.generator.BigDecimalRangeGenerator;
import org.opendaylight.yangtools.sal.java.api.generator.BigIntegerRangeGenerator;
import org.opendaylight.yangtools.sal.java.api.generator.ByteRangeGenerator;
import org.opendaylight.yangtools.sal.java.api.generator.IntegerRangeGenerator;
import org.opendaylight.yangtools.sal.java.api.generator.LongRangeGenerator;
import org.opendaylight.yangtools.sal.java.api.generator.ShortRangeGenerator;
import org.opendaylight.yangtools.sal.java.api.generator.TypeUtils;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRangeGenerator<T extends Number> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRangeGenerator.class);
    private static final Map<String, AbstractRangeGenerator<?>> GENERATORS;
    private final Class<T> type;

    private static void addGenerator(ImmutableMap.Builder<String, AbstractRangeGenerator<?>> b, AbstractRangeGenerator<?> generator) {
        b.put((Object)generator.getTypeClass().getCanonicalName(), generator);
    }

    protected AbstractRangeGenerator(Class<T> typeClass) {
        this.type = (Class)Preconditions.checkNotNull(typeClass);
    }

    static AbstractRangeGenerator<?> forType(@Nonnull Type type) {
        ConcreteType javaType = TypeUtils.getBaseYangType(type);
        return GENERATORS.get(javaType.getFullyQualifiedName());
    }

    @Nonnull
    protected final Class<T> getTypeClass() {
        return this.type;
    }

    @Nonnull
    protected final String getTypeName() {
        return this.type.getName();
    }

    @Nonnull
    protected final T getValue(Number value) {
        if (this.type.isInstance(value)) {
            return (T)((Number)this.type.cast(value));
        }
        LOG.debug("Converting value {} from {} to {}", new Object[]{value, value.getClass(), this.type});
        T ret = this.convert(value);
        AbstractRangeGenerator<?> gen = GENERATORS.get(value.getClass().getName());
        Object check = gen.convert((Number)ret);
        if (!value.equals(check)) {
            LOG.warn("Number class conversion from {} to {} truncated value {} to {}", new Object[]{value.getClass(), this.type, value, ret});
        }
        return ret;
    }

    @Deprecated
    protected abstract T convert(Number var1);

    @Nonnull
    protected abstract String format(T var1);

    @Nonnull
    protected abstract String generateRangeCheckerImplementation(@Nonnull String var1, @Nonnull Collection<RangeConstraint> var2);

    private static String rangeCheckerName(String member) {
        return "check" + member + "Range";
    }

    String generateRangeChecker(@Nonnull String member, @Nonnull Collection<RangeConstraint> constraints) {
        Preconditions.checkArgument((!constraints.isEmpty() ? 1 : 0) != 0, (Object)"Restrictions may not be empty");
        return this.generateRangeCheckerImplementation(AbstractRangeGenerator.rangeCheckerName(member), constraints);
    }

    String generateRangeCheckerCall(@Nonnull String member, @Nonnull String valueReference) {
        return AbstractRangeGenerator.rangeCheckerName(member) + '(' + valueReference + ");\n";
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        AbstractRangeGenerator.addGenerator(b, new ByteRangeGenerator());
        AbstractRangeGenerator.addGenerator(b, new ShortRangeGenerator());
        AbstractRangeGenerator.addGenerator(b, new IntegerRangeGenerator());
        AbstractRangeGenerator.addGenerator(b, new LongRangeGenerator());
        AbstractRangeGenerator.addGenerator(b, new BigDecimalRangeGenerator());
        AbstractRangeGenerator.addGenerator(b, new BigIntegerRangeGenerator());
        GENERATORS = b.build();
    }
}

