/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.sal.java.api.generator.AbstractRangeGenerator;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractPrimitiveRangeGenerator<T extends Number>
extends AbstractRangeGenerator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPrimitiveRangeGenerator.class);
    private final String primitiveName;
    private final T minValue;
    private final T maxValue;

    protected AbstractPrimitiveRangeGenerator(Class<T> typeClass, String primitiveName, T minValue, T maxValue) {
        super(typeClass);
        this.primitiveName = (String)Preconditions.checkNotNull((Object)primitiveName);
        this.minValue = (Number)Preconditions.checkNotNull(minValue);
        this.maxValue = (Number)Preconditions.checkNotNull(maxValue);
    }

    @Nonnull
    protected final String getPrimitiveName() {
        return this.primitiveName;
    }

    private boolean needsMaximumEnforcement(T maxToEnforce) {
        return ((Comparable)this.maxValue).compareTo(maxToEnforce) > 0;
    }

    private boolean needsMinimumEnforcement(T minToEnforce) {
        return ((Comparable)this.minValue).compareTo(minToEnforce) < 0;
    }

    private final Collection<String> createExpressions(Collection<RangeConstraint> constraints) {
        ArrayList<String> ret = new ArrayList<String>(constraints.size());
        for (RangeConstraint r : constraints) {
            Object min = this.getValue(r.getMin());
            boolean needMin = this.needsMinimumEnforcement(min);
            Object max = this.getValue(r.getMax());
            boolean needMax = this.needsMaximumEnforcement(max);
            if (!needMin && !needMax) {
                LOG.debug("Type {} indicates [{}, {}] does not require enforcement", new Object[]{this.getTypeName(), min, max});
                continue;
            }
            StringBuilder sb = new StringBuilder();
            if (needMin) {
                sb.append("value >= ").append(this.format(min));
            }
            if (needMax) {
                if (needMin) {
                    sb.append(" && ");
                }
                sb.append("value <= ").append(this.format(max));
            }
            ret.add(sb.toString());
        }
        return ret;
    }

    private String createRangeString(Collection<RangeConstraint> constraints) {
        ArrayList<Range> ranges = new ArrayList<Range>(constraints.size());
        for (RangeConstraint c : constraints) {
            ranges.add(Range.closed((Comparable)((Comparable)this.getValue(c.getMin())), (Comparable)((Comparable)this.getValue(c.getMax()))));
        }
        return ((Object)ranges).toString();
    }

    @Override
    protected final String generateRangeCheckerImplementation(String checkerName, Collection<RangeConstraint> constraints) {
        StringBuilder sb = new StringBuilder();
        Collection<String> expressions = this.createExpressions(constraints);
        sb.append("private static void ").append(checkerName).append("(final ").append(this.primitiveName).append(" value) {\n");
        if (!expressions.isEmpty()) {
            for (String exp : expressions) {
                sb.append("    if (").append(exp).append(") {\n");
                sb.append("        return;\n");
                sb.append("    }\n");
            }
            sb.append("    throw new IllegalArgumentException(String.format(\"Invalid range: %s, expected: ").append(this.createRangeString(constraints)).append(".\", value));\n");
        }
        sb.append("}\n");
        return sb.toString();
    }
}

