/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.java.api.generator;

import com.google.common.collect.Range;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.sal.java.api.generator.AbstractRangeGenerator;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;

abstract class AbstractBigRangeGenerator<T extends Number>
extends AbstractRangeGenerator<T> {
    private static final String RANGE = Range.class.getName();

    protected AbstractBigRangeGenerator(Class<T> typeClass) {
        super(typeClass);
    }

    private StringBuilder itemType() {
        return new StringBuilder(RANGE).append('<').append(this.getTypeName()).append('>');
    }

    private StringBuilder arrayType() {
        return new StringBuilder(this.itemType()).append("[]");
    }

    @Override
    protected final String generateRangeCheckerImplementation(String checkerName, @Nonnull Collection<RangeConstraint> constraints) {
        String fieldName = checkerName.toUpperCase() + "_RANGES";
        StringBuilder sb = new StringBuilder();
        sb.append("private static final ").append((CharSequence)this.arrayType()).append(' ').append(fieldName).append(";\n");
        sb.append("static {\n");
        sb.append("    @SuppressWarnings(\"unchecked\")\n");
        sb.append("    final ").append((CharSequence)this.arrayType()).append(" a = (").append((CharSequence)this.arrayType()).append(") java.lang.reflect.Array.newInstance(").append(RANGE).append(".class, ").append(constraints.size()).append(");\n");
        int i = 0;
        for (RangeConstraint r : constraints) {
            String min = this.format(this.getValue(r.getMin()));
            String max = this.format(this.getValue(r.getMax()));
            sb.append("    a[").append(i++).append("] = ").append(RANGE).append(".closed(").append(min).append(", ").append(max).append(");\n");
        }
        sb.append("    ").append(fieldName).append(" = a;\n");
        sb.append("}\n");
        sb.append("private static void ").append(checkerName).append("(final ").append(this.getTypeName()).append(" value) {\n");
        sb.append("    for (").append((CharSequence)this.itemType()).append(" r : ").append(fieldName).append(") {\n");
        sb.append("        if (r.contains(value)) {\n");
        sb.append("            return;\n");
        sb.append("        }\n");
        sb.append("    }\n");
        sb.append("    throw new IllegalArgumentException(String.format(\"Invalid range: %s, expected: %s.\", value, java.util.Arrays.asList(").append(fieldName).append(")));\n");
        sb.append("}\n");
        return sb.toString();
    }
}

