/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.vpnservice;

import java.math.BigInteger;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.opendaylight.bgpmanager.api.IBgpManager;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareProvider;
import org.opendaylight.fibmanager.api.IFibManager;
import org.opendaylight.vpnmanager.api.IVpnManager;
import org.opendaylight.vpnservice.InterfaceChangeListener;
import org.opendaylight.vpnservice.VpnInterfaceManager;
import org.opendaylight.vpnservice.VpnManager;
import org.opendaylight.vpnservice.interfacemgr.interfaces.IInterfaceManager;
import org.opendaylight.vpnservice.mdsalutil.interfaces.IMdsalApiManager;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.idmanager.rev150403.CreateIdPoolInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.idmanager.rev150403.CreateIdPoolInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.idmanager.rev150403.IdManagerService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VpnserviceProvider
implements BindingAwareProvider,
IVpnManager,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(VpnserviceProvider.class);
    private VpnInterfaceManager vpnInterfaceManager;
    private VpnManager vpnManager;
    private IBgpManager bgpManager;
    private IFibManager fibManager;
    private IMdsalApiManager mdsalManager;
    private IInterfaceManager interfaceManager;
    private IdManagerService idManager;
    private InterfaceChangeListener interfaceListener;

    public void onSessionInitiated(BindingAwareBroker.ProviderContext session) {
        LOG.info("VpnserviceProvider Session Initiated");
        try {
            DataBroker dataBroker = (DataBroker)session.getSALService(DataBroker.class);
            this.vpnManager = new VpnManager(dataBroker, this.bgpManager);
            this.vpnManager.setIdManager(this.idManager);
            this.vpnInterfaceManager = new VpnInterfaceManager(dataBroker, this.bgpManager);
            this.vpnInterfaceManager.setMdsalManager(this.mdsalManager);
            this.vpnInterfaceManager.setInterfaceManager(this.interfaceManager);
            this.vpnInterfaceManager.setIdManager(this.idManager);
            this.vpnManager.setVpnInterfaceManager(this.vpnInterfaceManager);
            this.interfaceListener = new InterfaceChangeListener(dataBroker, this.vpnInterfaceManager);
            this.interfaceListener.setInterfaceManager(this.interfaceManager);
            this.createIdPool();
        }
        catch (Exception e) {
            LOG.error("Error initializing services", (Throwable)e);
        }
    }

    public void setBgpManager(IBgpManager bgpManager) {
        LOG.debug("BGP Manager reference initialized");
        this.bgpManager = bgpManager;
    }

    public void setMdsalManager(IMdsalApiManager mdsalManager) {
        this.mdsalManager = mdsalManager;
    }

    public void setFibManager(IFibManager fibManager) {
        this.fibManager = fibManager;
    }

    public void setInterfaceManager(IInterfaceManager interfaceManager) {
        this.interfaceManager = interfaceManager;
    }

    public void setIdManager(IdManagerService idManager) {
        this.idManager = idManager;
    }

    private void createIdPool() {
        CreateIdPoolInput createPool = new CreateIdPoolInputBuilder().setPoolName("vpnservices").setIdStart(Long.valueOf(1L)).setPoolSize(new BigInteger("65535")).build();
        try {
            Future result = this.idManager.createIdPool(createPool);
            if (result != null && ((RpcResult)result.get()).isSuccessful()) {
                LOG.debug("Created IdPool for VPN Service");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Failed to create idPool for VPN Service", (Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        this.vpnManager.close();
        this.vpnInterfaceManager.close();
        this.interfaceListener.close();
    }

    public Collection<BigInteger> getDpnsForVpn(long vpnId) {
        return this.vpnInterfaceManager.getDpnsForVpn(vpnId);
    }

    public void setFibService(IFibManager fibManager) {
        LOG.debug("Fib service reference is initialized in VPN Manager");
        this.fibManager = fibManager;
        this.vpnInterfaceManager.setFibManager(fibManager);
    }
}

