/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.vpnservice;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.opendaylight.bgpmanager.api.IBgpManager;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.vpnservice.AbstractDataChangeListener;
import org.opendaylight.vpnservice.VpnInterfaceManager;
import org.opendaylight.vpnservice.VpnUtil;
import org.opendaylight.yang.gen.v1.urn.huawei.params.xml.ns.yang.l3vpn.rev140815.VpnInstances;
import org.opendaylight.yang.gen.v1.urn.huawei.params.xml.ns.yang.l3vpn.rev140815.VpnInterfaces;
import org.opendaylight.yang.gen.v1.urn.huawei.params.xml.ns.yang.l3vpn.rev140815.vpn.instances.VpnInstance;
import org.opendaylight.yang.gen.v1.urn.huawei.params.xml.ns.yang.l3vpn.rev140815.vpn.instances.VpnInstanceBuilder;
import org.opendaylight.yang.gen.v1.urn.huawei.params.xml.ns.yang.l3vpn.rev140815.vpn.instances.vpn.instance.Ipv4Family;
import org.opendaylight.yang.gen.v1.urn.huawei.params.xml.ns.yang.l3vpn.rev140815.vpn.interfaces.VpnInterface;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l3vpn.rev130911.VpnInstance1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l3vpn.rev130911.VpnInstance1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.fibmanager.rev150330.FibEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.fibmanager.rev150330.fibentries.VrfTables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.fibmanager.rev150330.fibentries.VrfTablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.fibmanager.rev150330.vrfentries.VrfEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.idmanager.rev150403.GetUniqueIdInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.idmanager.rev150403.GetUniqueIdInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.idmanager.rev150403.GetUniqueIdOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.idmanager.rev150403.IdManagerService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VpnManager
extends AbstractDataChangeListener<VpnInstance>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(VpnManager.class);
    private ListenerRegistration<DataChangeListener> listenerRegistration;
    private ListenerRegistration<DataChangeListener> fibListenerRegistration;
    private final DataBroker broker;
    private final IBgpManager bgpManager;
    private IdManagerService idManager;
    private VpnInterfaceManager vpnInterfaceManager;
    private final FibEntriesListener fibListener;
    private static final FutureCallback<Void> DEFAULT_CALLBACK = new FutureCallback<Void>(){

        public void onSuccess(Void result) {
            LOG.debug("Success in Datastore operation");
        }

        public void onFailure(Throwable error) {
            LOG.error("Error in Datastore operation", error);
        }
    };

    public VpnManager(DataBroker db, IBgpManager bgpManager) {
        super(VpnInstance.class);
        this.broker = db;
        this.bgpManager = bgpManager;
        this.fibListener = new FibEntriesListener();
        this.registerListener(db);
    }

    private void registerListener(DataBroker db) {
        try {
            this.listenerRegistration = db.registerDataChangeListener(LogicalDatastoreType.CONFIGURATION, this.getWildCardPath(), (DataChangeListener)this, AsyncDataBroker.DataChangeScope.SUBTREE);
            this.fibListenerRegistration = db.registerDataChangeListener(LogicalDatastoreType.OPERATIONAL, this.getFibEntryListenerPath(), (DataChangeListener)this.fibListener, AsyncDataBroker.DataChangeScope.BASE);
        }
        catch (Exception e) {
            LOG.error("VPN Service DataChange listener registration fail !", (Throwable)e);
            throw new IllegalStateException("VPN Service registration Listener failed.", e);
        }
    }

    public void setIdManager(IdManagerService idManager) {
        this.idManager = idManager;
    }

    public void setVpnInterfaceManager(VpnInterfaceManager vpnInterfaceManager) {
        this.vpnInterfaceManager = vpnInterfaceManager;
    }

    @Override
    protected void remove(InstanceIdentifier<VpnInstance> identifier, VpnInstance del) {
        LOG.trace("Remove VPN event - Key: {}, value: {}", identifier, (Object)del);
        String vpnName = del.getVpnInstanceName();
        InstanceIdentifier<VpnInstance> vpnIdentifier = VpnUtil.getVpnInstanceIdentifier(vpnName);
        InstanceIdentifier vpnInterfacesId = InstanceIdentifier.builder(VpnInterfaces.class).build();
        Optional optionalVpnInterfaces = this.read(LogicalDatastoreType.OPERATIONAL, vpnInterfacesId);
        if (optionalVpnInterfaces.isPresent()) {
            List vpnInterfaces = ((VpnInterfaces)optionalVpnInterfaces.get()).getVpnInterface();
            for (VpnInterface vpnInterface : vpnInterfaces) {
                if (!vpnInterface.getVpnInstanceName().equals(vpnName)) continue;
                LOG.debug("VpnInterface {} will be removed from VPN {}", (Object)vpnInterface.getName(), (Object)vpnName);
                this.vpnInterfaceManager.remove(VpnUtil.getVpnInterfaceIdentifier(vpnInterface.getName()), vpnInterface);
            }
        }
        this.delete(LogicalDatastoreType.OPERATIONAL, vpnIdentifier);
        String rd = del.getIpv4Family().getRouteDistinguisher();
        try {
            this.bgpManager.deleteVrf(rd);
        }
        catch (Exception e) {
            LOG.error("Exception when removing VRF from BGP", (Throwable)e);
        }
    }

    @Override
    protected void update(InstanceIdentifier<VpnInstance> identifier, VpnInstance original, VpnInstance update) {
        LOG.trace("Update event - Key: {}, value: {}", identifier, (Object)update);
    }

    @Override
    protected void add(InstanceIdentifier<VpnInstance> identifier, VpnInstance value) {
        LOG.trace("key: {}, value: {}", identifier, (Object)value);
        long vpnId = this.getUniqueId(value.getVpnInstanceName()).intValue();
        VpnInstance opValue = new VpnInstanceBuilder(value).addAugmentation(VpnInstance1.class, (Augmentation)new VpnInstance1Builder().setVpnId(Long.valueOf(vpnId)).build()).build();
        this.asyncWrite(LogicalDatastoreType.OPERATIONAL, identifier, opValue, DEFAULT_CALLBACK);
        Ipv4Family config = value.getIpv4Family();
        String rd = config.getRouteDistinguisher();
        List<String> importRts = Arrays.asList(config.getImportRoutePolicy().split(","));
        List<String> exportRts = Arrays.asList(config.getExportRoutePolicy().split(","));
        try {
            this.bgpManager.addVrf(rd, importRts, exportRts);
        }
        catch (Exception e) {
            LOG.error("Exception when adding VRF to BGP", (Throwable)e);
        }
    }

    private InstanceIdentifier<?> getWildCardPath() {
        return InstanceIdentifier.create(VpnInstances.class).child(VpnInstance.class);
    }

    private InstanceIdentifier<?> getFibEntryListenerPath() {
        return InstanceIdentifier.create(FibEntries.class).child(VrfTables.class).child(VrfEntry.class);
    }

    @Override
    public void close() throws Exception {
        if (this.listenerRegistration != null) {
            try {
                this.listenerRegistration.close();
            }
            catch (Exception e) {
                LOG.error("Error when cleaning up Vpn DataChangeListener.", (Throwable)e);
            }
            this.listenerRegistration = null;
        }
        if (this.fibListenerRegistration != null) {
            try {
                this.fibListenerRegistration.close();
            }
            catch (Exception e) {
                LOG.error("Error when cleaning up Fib entries DataChangeListener.", (Throwable)e);
            }
            this.fibListenerRegistration = null;
        }
        LOG.trace("VPN Manager Closed");
    }

    private <T extends DataObject> Optional<T> read(LogicalDatastoreType datastoreType, InstanceIdentifier<T> path) {
        ReadOnlyTransaction tx = this.broker.newReadOnlyTransaction();
        Optional result = Optional.absent();
        try {
            result = (Optional)tx.read(datastoreType, path).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private <T extends DataObject> void asyncWrite(LogicalDatastoreType datastoreType, InstanceIdentifier<T> path, T data, FutureCallback<Void> callback) {
        WriteTransaction tx = this.broker.newWriteOnlyTransaction();
        tx.put(datastoreType, path, data, true);
        Futures.addCallback((ListenableFuture)tx.submit(), callback);
    }

    private VpnInstance getVpnForRD(String rd) {
        InstanceIdentifier id = InstanceIdentifier.create(VpnInstances.class);
        Optional vpnInstances = this.read(LogicalDatastoreType.OPERATIONAL, id);
        if (vpnInstances.isPresent()) {
            List vpns = ((VpnInstances)vpnInstances.get()).getVpnInstance();
            for (VpnInstance vpn : vpns) {
                if (!vpn.getIpv4Family().getRouteDistinguisher().equals(rd)) continue;
                return vpn;
            }
        }
        return null;
    }

    private Integer getUniqueId(String idKey) {
        GetUniqueIdInput getIdInput = new GetUniqueIdInputBuilder().setPoolName("vpnservices").setIdKey(idKey).build();
        try {
            Future result = this.idManager.getUniqueId(getIdInput);
            RpcResult rpcResult = (RpcResult)result.get();
            if (rpcResult.isSuccessful()) {
                return ((GetUniqueIdOutput)rpcResult.getResult()).getIdValue().intValue();
            }
            LOG.warn("RPC Call to Get Unique Id returned with Errors {}", (Object)rpcResult.getErrors());
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Exception when getting Unique Id", (Throwable)e);
        }
        return 0;
    }

    private <T extends DataObject> void delete(LogicalDatastoreType datastoreType, InstanceIdentifier<T> path) {
        WriteTransaction tx = this.broker.newWriteOnlyTransaction();
        tx.delete(datastoreType, path);
        Futures.addCallback((ListenableFuture)tx.submit(), DEFAULT_CALLBACK);
    }

    private class FibEntriesListener
    extends AbstractDataChangeListener<VrfEntry> {
        public FibEntriesListener() {
            super(VrfEntry.class);
        }

        @Override
        protected void remove(InstanceIdentifier<VrfEntry> identifier, VrfEntry del) {
            LOG.trace("Remove Fib event - Key : {}, value : {} ", identifier, (Object)del);
            VrfTablesKey key = (VrfTablesKey)identifier.firstKeyOf(VrfTables.class, VrfTablesKey.class);
            String rd = key.getRouteDistinguisher();
            Long label = del.getLabel();
            VpnInstance vpn = VpnManager.this.getVpnForRD(rd);
            if (vpn != null) {
                InstanceIdentifier<VpnInstance> id = VpnUtil.getVpnInstanceIdentifier(vpn.getVpnInstanceName());
                InstanceIdentifier augId = id.augmentation(VpnInstance1.class);
                Optional vpnAugmenation = VpnManager.this.read(LogicalDatastoreType.OPERATIONAL, augId);
                if (vpnAugmenation.isPresent()) {
                    VpnInstance1 vpnAug = (VpnInstance1)vpnAugmenation.get();
                    List routeIds = vpnAug.getRouteEntryId();
                    if (routeIds == null) {
                        LOG.debug("Fib Route entry is empty.");
                        return;
                    }
                    LOG.debug("Removing label from vpn info - {}", (Object)label);
                    routeIds.remove(label);
                    VpnManager.this.asyncWrite(LogicalDatastoreType.OPERATIONAL, augId, (DataObject)new VpnInstance1Builder(vpnAug).setRouteEntryId(routeIds).build(), (FutureCallback<Void>)DEFAULT_CALLBACK);
                } else {
                    LOG.warn("VPN Augmentation not found for vpn instance {}", (Object)vpn.getVpnInstanceName());
                }
            } else {
                LOG.warn("No VPN Instance found for RD: {}", (Object)rd);
            }
        }

        @Override
        protected void update(InstanceIdentifier<VrfEntry> identifier, VrfEntry original, VrfEntry update) {
        }

        @Override
        protected void add(InstanceIdentifier<VrfEntry> identifier, VrfEntry add) {
            LOG.trace("Add Vrf Entry event - Key : {}, value : {}", identifier, (Object)add);
            VrfTablesKey key = (VrfTablesKey)identifier.firstKeyOf(VrfTables.class, VrfTablesKey.class);
            String rd = key.getRouteDistinguisher();
            Long label = add.getLabel();
            VpnInstance vpn = VpnManager.this.getVpnForRD(rd);
            if (vpn != null) {
                InstanceIdentifier<VpnInstance> id = VpnUtil.getVpnInstanceIdentifier(vpn.getVpnInstanceName());
                InstanceIdentifier augId = id.augmentation(VpnInstance1.class);
                Optional vpnAugmenation = VpnManager.this.read(LogicalDatastoreType.OPERATIONAL, augId);
                if (vpnAugmenation.isPresent()) {
                    VpnInstance1 vpnAug = (VpnInstance1)vpnAugmenation.get();
                    ArrayList<Long> routeIds = vpnAug.getRouteEntryId();
                    if (routeIds == null) {
                        routeIds = new ArrayList<Long>();
                    }
                    LOG.debug("Adding label to vpn info - {}", (Object)label);
                    routeIds.add(label);
                    VpnManager.this.asyncWrite(LogicalDatastoreType.OPERATIONAL, augId, (DataObject)new VpnInstance1Builder(vpnAug).setRouteEntryId(routeIds).build(), (FutureCallback<Void>)DEFAULT_CALLBACK);
                } else {
                    LOG.warn("VPN Augmentation not found for vpn instance {}", (Object)vpn.getVpnInstanceName());
                }
            } else {
                LOG.warn("No VPN Instance found for RD: {}", (Object)rd);
            }
        }
    }
}

