/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.vpnservice;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.opendaylight.bgpmanager.api.IBgpManager;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.fibmanager.api.IFibManager;
import org.opendaylight.vpnservice.AbstractDataChangeListener;
import org.opendaylight.vpnservice.VpnUtil;
import org.opendaylight.vpnservice.interfacemgr.interfaces.IInterfaceManager;
import org.opendaylight.vpnservice.mdsalutil.FlowEntity;
import org.opendaylight.vpnservice.mdsalutil.InstructionInfo;
import org.opendaylight.vpnservice.mdsalutil.InstructionType;
import org.opendaylight.vpnservice.mdsalutil.MDSALUtil;
import org.opendaylight.vpnservice.mdsalutil.MatchFieldType;
import org.opendaylight.vpnservice.mdsalutil.MatchInfo;
import org.opendaylight.vpnservice.mdsalutil.MetaDataUtil;
import org.opendaylight.vpnservice.mdsalutil.interfaces.IMdsalApiManager;
import org.opendaylight.yang.gen.v1.urn.huawei.params.xml.ns.yang.l3vpn.rev140815.VpnInstances;
import org.opendaylight.yang.gen.v1.urn.huawei.params.xml.ns.yang.l3vpn.rev140815.VpnInterfaces;
import org.opendaylight.yang.gen.v1.urn.huawei.params.xml.ns.yang.l3vpn.rev140815.vpn.instances.VpnInstance;
import org.opendaylight.yang.gen.v1.urn.huawei.params.xml.ns.yang.l3vpn.rev140815.vpn.instances.VpnInstanceKey;
import org.opendaylight.yang.gen.v1.urn.huawei.params.xml.ns.yang.l3vpn.rev140815.vpn.instances.vpn.instance.Ipv4Family;
import org.opendaylight.yang.gen.v1.urn.huawei.params.xml.ns.yang.l3vpn.rev140815.vpn.interfaces.VpnInterface;
import org.opendaylight.yang.gen.v1.urn.huawei.params.xml.ns.yang.l3vpn.rev140815.vpn.interfaces.VpnInterfaceKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.Interfaces;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.InterfacesState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.Interface;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.InterfaceKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.Interface;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l3vpn.rev130911.Adjacencies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l3vpn.rev130911.VpnInstance1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l3vpn.rev130911.adjacency.list.Adjacency;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l3vpn.rev130911.adjacency.list.AdjacencyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.idmanager.rev150403.GetUniqueIdInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.idmanager.rev150403.GetUniqueIdInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.idmanager.rev150403.GetUniqueIdOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.idmanager.rev150403.IdManagerService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.L3tunnel;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VpnInterfaceManager
extends AbstractDataChangeListener<VpnInterface>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(VpnInterfaceManager.class);
    private ListenerRegistration<DataChangeListener> listenerRegistration;
    private ListenerRegistration<DataChangeListener> interfaceListenerRegistration;
    private final DataBroker broker;
    private final IBgpManager bgpManager;
    private IFibManager fibManager;
    private IMdsalApiManager mdsalManager;
    private IInterfaceManager interfaceManager;
    private IdManagerService idManager;
    private Map<Long, Collection<BigInteger>> vpnToDpnsDb;
    private Map<BigInteger, Collection<String>> dpnToInterfaceDb;
    private InterfaceListener interfaceListener;
    private static final FutureCallback<Void> DEFAULT_CALLBACK = new FutureCallback<Void>(){

        public void onSuccess(Void result) {
            LOG.debug("Success in Datastore operation");
        }

        public void onFailure(Throwable error) {
            LOG.error("Error in Datastore operation", error);
        }
    };

    public VpnInterfaceManager(DataBroker db, IBgpManager bgpManager) {
        super(VpnInterface.class);
        this.broker = db;
        this.bgpManager = bgpManager;
        this.vpnToDpnsDb = new ConcurrentHashMap<Long, Collection<BigInteger>>();
        this.dpnToInterfaceDb = new ConcurrentHashMap<BigInteger, Collection<String>>();
        this.interfaceListener = new InterfaceListener();
        this.registerListener(db);
    }

    public void setMdsalManager(IMdsalApiManager mdsalManager) {
        this.mdsalManager = mdsalManager;
    }

    public void setInterfaceManager(IInterfaceManager interfaceManager) {
        this.interfaceManager = interfaceManager;
    }

    public void setFibManager(IFibManager fibManager) {
        this.fibManager = fibManager;
    }

    public void setIdManager(IdManagerService idManager) {
        this.idManager = idManager;
    }

    @Override
    public void close() throws Exception {
        if (this.listenerRegistration != null) {
            try {
                this.listenerRegistration.close();
                this.interfaceListenerRegistration.close();
            }
            catch (Exception e) {
                LOG.error("Error when cleaning up DataChangeListener.", (Throwable)e);
            }
            this.listenerRegistration = null;
            this.interfaceListenerRegistration = null;
        }
        LOG.info("VPN Interface Manager Closed");
    }

    private void registerListener(DataBroker db) {
        try {
            this.listenerRegistration = db.registerDataChangeListener(LogicalDatastoreType.CONFIGURATION, this.getWildCardPath(), (DataChangeListener)this, AsyncDataBroker.DataChangeScope.SUBTREE);
            this.interfaceListenerRegistration = db.registerDataChangeListener(LogicalDatastoreType.OPERATIONAL, this.getInterfaceListenerPath(), (DataChangeListener)this.interfaceListener, AsyncDataBroker.DataChangeScope.SUBTREE);
        }
        catch (Exception e) {
            LOG.error("VPN Service DataChange listener registration fail!", (Throwable)e);
            throw new IllegalStateException("VPN Service registration Listener failed.", e);
        }
    }

    private InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.Interface> getInterfaceListenerPath() {
        return InstanceIdentifier.create(InterfacesState.class).child(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.Interface.class);
    }

    @Override
    protected void add(InstanceIdentifier<VpnInterface> identifier, VpnInterface vpnInterface) {
        LOG.trace("key: {} , value: {}", identifier, (Object)vpnInterface);
        this.addInterface(identifier, vpnInterface);
    }

    private void addInterface(InstanceIdentifier<VpnInterface> identifier, VpnInterface vpnInterface) {
        VpnInterfaceKey key = (VpnInterfaceKey)identifier.firstKeyOf(VpnInterface.class, VpnInterfaceKey.class);
        String interfaceName = key.getName();
        InstanceIdentifier.InstanceIdentifierBuilder idBuilder = InstanceIdentifier.builder(Interfaces.class).child(Interface.class, (Identifier)new InterfaceKey(interfaceName));
        InstanceIdentifier id = idBuilder.build();
        Optional port = this.read(LogicalDatastoreType.CONFIGURATION, id);
        if (port.isPresent()) {
            Interface interf = (Interface)port.get();
            this.bindServiceOnInterface(interf, vpnInterface.getVpnInstanceName());
            this.updateNextHops(identifier, vpnInterface);
        }
    }

    private void updateNextHops(InstanceIdentifier<VpnInterface> identifier, VpnInterface intf) {
        InstanceIdentifier path = identifier.augmentation(Adjacencies.class);
        Optional adjacencies = this.read(LogicalDatastoreType.CONFIGURATION, path);
        String intfName = intf.getName();
        if (adjacencies.isPresent()) {
            List nextHops = ((Adjacencies)adjacencies.get()).getAdjacency();
            ArrayList<Adjacency> value = new ArrayList<Adjacency>();
            String rd = this.getRouteDistinguisher(intf.getVpnInstanceName());
            BigInteger dpnId = this.interfaceManager.getDpnForInterface(intfName);
            String nextHopIp = this.interfaceManager.getEndpointIpForDpn(dpnId);
            LOG.trace("NextHops are {}", (Object)nextHops);
            for (Adjacency nextHop : nextHops) {
                String key = rd + "." + nextHop.getIpAddress();
                long label = this.getUniqueId(key).intValue();
                value.add(new AdjacencyBuilder(nextHop).setLabel(Long.valueOf(label)).build());
            }
            Adjacencies aug = VpnUtil.getVpnInterfaceAugmentation(value);
            VpnInterface opInterface = VpnUtil.getVpnInterface(intfName, intf.getVpnInstanceName(), aug);
            InstanceIdentifier<VpnInterface> interfaceId = VpnUtil.getVpnInterfaceIdentifier(intfName);
            this.syncWrite(LogicalDatastoreType.OPERATIONAL, interfaceId, opInterface, DEFAULT_CALLBACK);
            for (Adjacency nextHop : nextHops) {
                String key = rd + "." + nextHop.getIpAddress();
                long label = this.getUniqueId(key).intValue();
                this.updatePrefixToBGP(rd, nextHop, nextHopIp, label);
            }
        }
    }

    private Integer getUniqueId(String idKey) {
        GetUniqueIdInput getIdInput = new GetUniqueIdInputBuilder().setPoolName("vpnservices").setIdKey(idKey).build();
        try {
            Future result = this.idManager.getUniqueId(getIdInput);
            RpcResult rpcResult = (RpcResult)result.get();
            if (rpcResult.isSuccessful()) {
                return ((GetUniqueIdOutput)rpcResult.getResult()).getIdValue().intValue();
            }
            LOG.warn("RPC Call to Get Unique Id returned with Errors {}", (Object)rpcResult.getErrors());
        }
        catch (InterruptedException | NullPointerException | ExecutionException e) {
            LOG.warn("Exception when getting Unique Id", (Throwable)e);
        }
        return 0;
    }

    private long getVpnId(String vpnName) {
        InstanceIdentifier id = InstanceIdentifier.builder(VpnInstances.class).child(VpnInstance.class, (Identifier)new VpnInstanceKey(vpnName)).augmentation(VpnInstance1.class).build();
        Optional vpnInstance = this.read(LogicalDatastoreType.OPERATIONAL, id);
        long vpnId = -1L;
        if (vpnInstance.isPresent()) {
            vpnId = ((VpnInstance1)vpnInstance.get()).getVpnId();
        }
        return vpnId;
    }

    private String getRouteDistinguisher(String vpnName) {
        InstanceIdentifier id = InstanceIdentifier.builder(VpnInstances.class).child(VpnInstance.class, (Identifier)new VpnInstanceKey(vpnName)).build();
        Optional vpnInstance = this.read(LogicalDatastoreType.CONFIGURATION, id);
        String rd = "";
        if (vpnInstance.isPresent()) {
            VpnInstance instance = (VpnInstance)vpnInstance.get();
            Ipv4Family config = instance.getIpv4Family();
            rd = config.getRouteDistinguisher();
        }
        return rd;
    }

    private synchronized void updateMappingDbs(long vpnId, BigInteger dpnId, String intfName, String rd) {
        Collection<String> intfNames;
        Collection<BigInteger> dpnIds = this.vpnToDpnsDb.get(vpnId);
        if (dpnIds == null) {
            dpnIds = new HashSet<BigInteger>();
        }
        if (dpnIds.add(dpnId)) {
            this.vpnToDpnsDb.put(vpnId, dpnIds);
            this.fibManager.populateFibOnNewDpn(dpnId, vpnId, rd);
        }
        if ((intfNames = this.dpnToInterfaceDb.get(dpnId)) == null) {
            intfNames = new ArrayList<String>();
        }
        intfNames.add(intfName);
        this.dpnToInterfaceDb.put(dpnId, intfNames);
    }

    private synchronized void remoteFromMappingDbs(long vpnId, BigInteger dpnId, String inftName, String rd) {
        Collection<String> intfNames = this.dpnToInterfaceDb.get(dpnId);
        if (intfNames == null) {
            return;
        }
        intfNames.remove(inftName);
        this.dpnToInterfaceDb.put(dpnId, intfNames);
        if (intfNames.isEmpty()) {
            Collection<BigInteger> dpnIds = this.vpnToDpnsDb.get(vpnId);
            if (dpnIds == null) {
                return;
            }
            dpnIds.remove(dpnId);
            this.vpnToDpnsDb.put(vpnId, dpnIds);
            this.fibManager.cleanUpDpnForVpn(dpnId, vpnId, rd);
        }
    }

    private void bindServiceOnInterface(Interface intf, String vpnName) {
        LOG.trace("Bind service on interface {} for VPN: {}", (Object)intf, (Object)vpnName);
        long vpnId = this.getVpnId(vpnName);
        BigInteger dpId = this.interfaceManager.getDpnForInterface(intf.getName());
        if (dpId.equals(BigInteger.ZERO)) {
            LOG.warn("DPN for interface {} not found. Bind service on this interface aborted.", (Object)intf.getName());
            return;
        }
        String rd = this.getRouteDistinguisher(vpnName);
        this.updateMappingDbs(vpnId, dpId, intf.getName(), rd);
        long portNo = this.interfaceManager.getPortForInterface(intf.getName());
        String flowRef = this.getVpnInterfaceFlowRef(dpId, (short)0, vpnId, portNo);
        String flowName = intf.getName();
        BigInteger COOKIE_VM_INGRESS_TABLE = new BigInteger("8000001", 16);
        int priority = 10;
        int gotoTableId = 21;
        if (intf.getType().equals(L3tunnel.class)) {
            gotoTableId = 20;
        }
        ArrayList<InstructionInfo> mkInstructions = new ArrayList<InstructionInfo>();
        mkInstructions.add(new InstructionInfo(InstructionType.write_metadata, new BigInteger[]{BigInteger.valueOf(vpnId), MetaDataUtil.METADATA_MASK_VRFID}));
        mkInstructions.add(new InstructionInfo(InstructionType.goto_table, new long[]{gotoTableId}));
        ArrayList<MatchInfo> matches = new ArrayList<MatchInfo>();
        matches.add(new MatchInfo(MatchFieldType.in_port, new BigInteger[]{dpId, BigInteger.valueOf(portNo)}));
        FlowEntity flowEntity = MDSALUtil.buildFlowEntity((BigInteger)dpId, (short)0, (String)flowRef, (int)priority, (String)flowName, (int)0, (int)0, (BigInteger)COOKIE_VM_INGRESS_TABLE, matches, mkInstructions);
        this.mdsalManager.installFlow(flowEntity);
    }

    private String getVpnInterfaceFlowRef(BigInteger dpId, short tableId, long vpnId, long portNo) {
        return "" + dpId + tableId + vpnId + portNo;
    }

    private void updatePrefixToBGP(String rd, Adjacency nextHop, String nextHopIp, long label) {
        try {
            this.bgpManager.addPrefix(rd, nextHop.getIpAddress(), nextHopIp, (int)label);
        }
        catch (Exception e) {
            LOG.error("Add prefix failed", (Throwable)e);
        }
    }

    private <T extends DataObject> Optional<T> read(LogicalDatastoreType datastoreType, InstanceIdentifier<T> path) {
        ReadOnlyTransaction tx = this.broker.newReadOnlyTransaction();
        Optional result = Optional.absent();
        try {
            result = (Optional)tx.read(datastoreType, path).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private InstanceIdentifier<VpnInterface> getWildCardPath() {
        return InstanceIdentifier.create(VpnInterfaces.class).child(VpnInterface.class);
    }

    @Override
    protected void remove(InstanceIdentifier<VpnInterface> identifier, VpnInterface vpnInterface) {
        LOG.trace("Remove event - key: {}, value: {}", identifier, (Object)vpnInterface);
        VpnInterfaceKey key = (VpnInterfaceKey)identifier.firstKeyOf(VpnInterface.class, VpnInterfaceKey.class);
        String interfaceName = key.getName();
        InstanceIdentifier.InstanceIdentifierBuilder idBuilder = InstanceIdentifier.builder(Interfaces.class).child(Interface.class, (Identifier)new InterfaceKey(interfaceName));
        InstanceIdentifier id = idBuilder.build();
        Optional port = this.read(LogicalDatastoreType.CONFIGURATION, id);
        if (port.isPresent()) {
            Interface interf = (Interface)port.get();
            this.removeNextHops(identifier, vpnInterface);
            this.unbindServiceOnInterface(interf, vpnInterface.getVpnInstanceName());
            this.delete(LogicalDatastoreType.OPERATIONAL, identifier);
        } else {
            LOG.warn("No nexthops were available to handle remove event {}", (Object)interfaceName);
        }
    }

    private void removeNextHops(InstanceIdentifier<VpnInterface> identifier, VpnInterface intf) {
        List nextHops;
        InstanceIdentifier path = identifier.augmentation(Adjacencies.class);
        Optional adjacencies = this.read(LogicalDatastoreType.OPERATIONAL, path);
        String intfName = intf.getName();
        String rd = this.getRouteDistinguisher(intf.getVpnInstanceName());
        if (adjacencies.isPresent() && !(nextHops = ((Adjacencies)adjacencies.get()).getAdjacency()).isEmpty()) {
            LOG.trace("NextHops are " + nextHops);
            for (Adjacency nextHop : nextHops) {
                this.removePrefixFromBGP(rd, nextHop);
            }
        }
    }

    private <T extends DataObject> void delete(LogicalDatastoreType datastoreType, InstanceIdentifier<T> path) {
        WriteTransaction tx = this.broker.newWriteOnlyTransaction();
        tx.delete(datastoreType, path);
        Futures.addCallback((ListenableFuture)tx.submit(), DEFAULT_CALLBACK);
    }

    private void unbindServiceOnInterface(Interface intf, String vpnName) {
        LOG.trace("Unbind service on interface {} for VPN: {}", (Object)intf, (Object)vpnName);
        long vpnId = this.getVpnId(vpnName);
        BigInteger dpId = this.interfaceManager.getDpnForInterface(intf);
        if (dpId.equals(BigInteger.ZERO)) {
            LOG.warn("DPN for interface {} not found. Unbind service on this interface aborted.", (Object)intf.getName());
            return;
        }
        String rd = this.getRouteDistinguisher(vpnName);
        this.remoteFromMappingDbs(vpnId, dpId, intf.getName(), rd);
        LOG.debug("removed vpn mapping for interface {} from VPN RD {}", (Object)intf.getName(), (Object)rd);
        long portNo = this.interfaceManager.getPortForInterface(intf);
        String flowRef = this.getVpnInterfaceFlowRef(dpId, (short)0, vpnId, portNo);
        String flowName = intf.getName();
        int priority = 10;
        ArrayList<MatchInfo> matches = new ArrayList<MatchInfo>();
        matches.add(new MatchInfo(MatchFieldType.in_port, new BigInteger[]{dpId, BigInteger.valueOf(portNo)}));
        FlowEntity flowEntity = MDSALUtil.buildFlowEntity((BigInteger)dpId, (short)0, (String)flowRef, (int)priority, (String)flowName, (int)0, (int)0, null, matches, null);
        LOG.debug("Remove ingress flow for port {} in dpn {}", (Object)portNo, (Object)dpId.intValue());
        this.mdsalManager.removeFlow(flowEntity);
    }

    private void removePrefixFromBGP(String rd, Adjacency nextHop) {
        try {
            this.bgpManager.deletePrefix(rd, nextHop.getIpAddress());
        }
        catch (Exception e) {
            LOG.error("Delete prefix failed", (Throwable)e);
        }
    }

    @Override
    protected void update(InstanceIdentifier<VpnInterface> identifier, VpnInterface original, VpnInterface update) {
        String rd;
        LOG.trace("Update VPN Interface {} , original {}, update {}", new Object[]{identifier, original, update});
        String vpnName = original.getVpnInstanceName();
        boolean vpnNameChanged = false;
        String newRd = rd = this.getRouteDistinguisher(vpnName);
        if (!vpnName.equals(update.getVpnInstanceName())) {
            String newVpnName = update.getVpnInstanceName();
            newRd = this.getRouteDistinguisher(newVpnName);
            if (newRd.equals("")) {
                LOG.warn("VPN Instance {} not found. Update operation aborted", (Object)newVpnName);
                return;
            }
            vpnNameChanged = true;
            LOG.debug("New VPN Name for the interface {} is {}", (Object)newVpnName, (Object)original.getName());
        }
        BigInteger dpnId = this.interfaceManager.getDpnForInterface(original.getName());
        String nextHopIp = this.interfaceManager.getEndpointIpForDpn(dpnId);
        List newAdjs = ((Adjacencies)update.getAugmentation(Adjacencies.class)).getAdjacency();
        if (vpnNameChanged && newAdjs != null && !newAdjs.isEmpty()) {
            long label = -1L;
            InstanceIdentifier path = identifier.augmentation(Adjacencies.class);
            Optional adjacencies = this.read(LogicalDatastoreType.OPERATIONAL, path);
            if (adjacencies.isPresent()) {
                List nextHops = ((Adjacencies)adjacencies.get()).getAdjacency();
                for (Adjacency nextHop : nextHops) {
                    label = nextHop.getLabel();
                    if (label == -1L) {
                        String key = newRd + "." + nextHop.getIpAddress();
                        label = this.getUniqueId(key).intValue();
                    }
                    this.removePrefixFromBGP(rd, nextHop);
                }
                this.updateNextHops(identifier, update);
                this.asyncUpdate(LogicalDatastoreType.OPERATIONAL, identifier, update, DEFAULT_CALLBACK);
            }
        } else {
            LOG.debug("No Update information is available for VPN Interface to proceed");
        }
    }

    protected <T extends DataObject> void asyncUpdate(LogicalDatastoreType datastoreType, InstanceIdentifier<T> path, T data, FutureCallback<Void> callback) {
        WriteTransaction tx = this.broker.newWriteOnlyTransaction();
        tx.merge(datastoreType, path, data, true);
        Futures.addCallback((ListenableFuture)tx.submit(), callback);
    }

    private <T extends DataObject> void asyncWrite(LogicalDatastoreType datastoreType, InstanceIdentifier<T> path, T data, FutureCallback<Void> callback) {
        WriteTransaction tx = this.broker.newWriteOnlyTransaction();
        tx.put(datastoreType, path, data, true);
        Futures.addCallback((ListenableFuture)tx.submit(), callback);
    }

    private <T extends DataObject> void syncWrite(LogicalDatastoreType datastoreType, InstanceIdentifier<T> path, T data, FutureCallback<Void> callback) {
        WriteTransaction tx = this.broker.newWriteOnlyTransaction();
        tx.put(datastoreType, path, data, true);
        tx.submit();
    }

    synchronized Collection<BigInteger> getDpnsForVpn(long vpnId) {
        Collection<BigInteger> dpnIds = this.vpnToDpnsDb.get(vpnId);
        if (dpnIds != null) {
            return ImmutableList.copyOf(dpnIds);
        }
        return Collections.emptyList();
    }

    VpnInterface getVpnInterface(String interfaceName) {
        Optional<VpnInterfaces> optVpnInterfaces = this.read(LogicalDatastoreType.CONFIGURATION, VpnUtil.getVpnInterfacesIdentifier());
        if (optVpnInterfaces.isPresent()) {
            List interfaces = ((VpnInterfaces)optVpnInterfaces.get()).getVpnInterface();
            for (VpnInterface intf : interfaces) {
                if (!intf.getName().equals(interfaceName)) continue;
                return intf;
            }
        }
        return null;
    }

    private Interface getInterface(String interfaceName) {
        Optional<Interface> optInterface = this.read(LogicalDatastoreType.CONFIGURATION, VpnUtil.getInterfaceIdentifier(interfaceName));
        if (optInterface.isPresent()) {
            return (Interface)optInterface.get();
        }
        return null;
    }

    private String getTunnelInterfaceFlowRef(BigInteger dpnId, short tableId, String ifName) {
        return dpnId + tableId + ifName;
    }

    protected void makeTunnelIngressFlow(BigInteger dpnId, String ifName, int addOrRemoveFlow) {
        long portNo = 0L;
        String flowName = ifName;
        String flowRef = this.getTunnelInterfaceFlowRef(dpnId, (short)0, ifName);
        ArrayList<MatchInfo> matches = new ArrayList<MatchInfo>();
        ArrayList<InstructionInfo> mkInstructions = new ArrayList<InstructionInfo>();
        if (0 == addOrRemoveFlow) {
            portNo = this.interfaceManager.getPortForInterface(ifName);
            matches.add(new MatchInfo(MatchFieldType.in_port, new BigInteger[]{dpnId, BigInteger.valueOf(portNo)}));
            mkInstructions.add(new InstructionInfo(InstructionType.goto_table, new long[]{20L}));
        }
        BigInteger COOKIE_VM_INGRESS_TABLE = new BigInteger("8000001", 16);
        FlowEntity flowEntity = MDSALUtil.buildFlowEntity((BigInteger)dpnId, (short)0, (String)flowRef, (int)10, (String)flowName, (int)0, (int)0, (BigInteger)COOKIE_VM_INGRESS_TABLE, matches, mkInstructions);
        if (0 == addOrRemoveFlow) {
            this.mdsalManager.installFlow(flowEntity);
        } else {
            this.mdsalManager.removeFlow(flowEntity);
        }
    }

    private class InterfaceListener
    extends AbstractDataChangeListener<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.Interface> {
        public InterfaceListener() {
            super(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.Interface.class);
        }

        @Override
        protected void remove(InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.Interface> identifier, org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.Interface del) {
            LOG.trace("Operational Interface remove event - {}", (Object)del);
        }

        @Override
        protected void update(InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.Interface> identifier, org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.Interface original, org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.Interface update) {
            LOG.trace("Operation Interface update event - Old: {}, New: {}", (Object)original, (Object)update);
            String interfaceName = update.getName();
            Interface intf = VpnInterfaceManager.this.getInterface(interfaceName);
            if (intf != null && intf.getType().equals(L3tunnel.class)) {
                BigInteger dpnId = VpnInterfaceManager.this.interfaceManager.getDpnForInterface(interfaceName);
                if (update.getOperStatus().equals((Object)Interface.OperStatus.Up)) {
                    LOG.debug("Installing Ingress for tunnel interface {}", (Object)interfaceName);
                    VpnInterfaceManager.this.makeTunnelIngressFlow(dpnId, interfaceName, 0);
                } else if (update.getOperStatus().equals((Object)Interface.OperStatus.Down)) {
                    LOG.debug("Removing Ingress flow for tunnel interface {}", (Object)interfaceName);
                    VpnInterfaceManager.this.makeTunnelIngressFlow(dpnId, interfaceName, 1);
                }
            } else {
                VpnInterface vpnInterface = VpnInterfaceManager.this.getVpnInterface(interfaceName);
                if (vpnInterface != null) {
                    if (update.getOperStatus().equals((Object)Interface.OperStatus.Up)) {
                        LOG.debug("Installing VPN related rules for interface {}", (Object)interfaceName);
                        VpnInterfaceManager.this.addInterface((InstanceIdentifier<VpnInterface>)VpnUtil.getVpnInterfaceIdentifier(vpnInterface.getName()), vpnInterface);
                    } else if (update.getOperStatus().equals((Object)Interface.OperStatus.Down)) {
                        LOG.debug("Removing VPN related rules for interface {}", (Object)interfaceName);
                        VpnInterfaceManager.this.remove(VpnUtil.getVpnInterfaceIdentifier(vpnInterface.getName()), vpnInterface);
                    }
                } else {
                    LOG.debug("No VPN Interface associated with interface {} to handle Update Operation", (Object)interfaceName);
                }
            }
        }

        @Override
        protected void add(InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.Interface> identifier, org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.Interface add) {
            LOG.trace("Operational Interface add event - {}", (Object)add);
            String interfaceName = add.getName();
            Interface intf = VpnInterfaceManager.this.getInterface(interfaceName);
            if (intf != null && intf.getType().equals(L3tunnel.class)) {
                BigInteger dpnId = VpnInterfaceManager.this.interfaceManager.getDpnForInterface(interfaceName);
                if (add.getOperStatus().equals((Object)Interface.OperStatus.Up)) {
                    LOG.debug("Installing Ingress for tunnel interface {}", (Object)interfaceName);
                    VpnInterfaceManager.this.makeTunnelIngressFlow(dpnId, interfaceName, 0);
                }
            } else {
                VpnInterface vpnInterface = VpnInterfaceManager.this.getVpnInterface(interfaceName);
                if (vpnInterface != null) {
                    if (add.getOperStatus().equals((Object)Interface.OperStatus.Up)) {
                        LOG.debug("Installing VPN related rules for interface {}", (Object)interfaceName);
                        VpnInterfaceManager.this.addInterface((InstanceIdentifier<VpnInterface>)VpnUtil.getVpnInterfaceIdentifier(vpnInterface.getName()), vpnInterface);
                    }
                } else {
                    LOG.debug("No VPN Interface associated with interface {} to handle add Operation", (Object)interfaceName);
                }
            }
        }
    }
}

