/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.vpnservice;

import java.math.BigInteger;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.vpnservice.AbstractDataChangeListener;
import org.opendaylight.vpnservice.VpnInterfaceManager;
import org.opendaylight.vpnservice.VpnUtil;
import org.opendaylight.vpnservice.interfacemgr.interfaces.IInterfaceManager;
import org.opendaylight.yang.gen.v1.urn.huawei.params.xml.ns.yang.l3vpn.rev140815.vpn.interfaces.VpnInterface;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.Interfaces;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.Interface;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.L3tunnel;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceChangeListener
extends AbstractDataChangeListener<Interface>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(InterfaceChangeListener.class);
    private ListenerRegistration<DataChangeListener> listenerRegistration;
    private final DataBroker broker;
    private VpnInterfaceManager vpnInterfaceManager;
    private IInterfaceManager interfaceManager;

    public InterfaceChangeListener(DataBroker db, VpnInterfaceManager vpnInterfaceManager) {
        super(Interface.class);
        this.broker = db;
        this.vpnInterfaceManager = vpnInterfaceManager;
        this.registerListener(db);
    }

    public void setInterfaceManager(IInterfaceManager interfaceManager) {
        this.interfaceManager = interfaceManager;
    }

    @Override
    public void close() throws Exception {
        if (this.listenerRegistration != null) {
            try {
                this.listenerRegistration.close();
            }
            catch (Exception e) {
                LOG.error("Error when cleaning up DataChangeListener.", (Throwable)e);
            }
            this.listenerRegistration = null;
        }
        LOG.info("Interface listener Closed");
    }

    private void registerListener(DataBroker db) {
        try {
            this.listenerRegistration = db.registerDataChangeListener(LogicalDatastoreType.CONFIGURATION, this.getWildCardPath(), (DataChangeListener)this, AsyncDataBroker.DataChangeScope.SUBTREE);
        }
        catch (Exception e) {
            LOG.error("Interface DataChange listener registration failed", (Throwable)e);
            throw new IllegalStateException("Nexthop Manager registration Listener failed.", e);
        }
    }

    @Override
    protected void add(InstanceIdentifier<Interface> identifier, Interface intrf) {
        LOG.trace("Adding Interface : key: " + identifier + ", value=" + intrf);
    }

    private InstanceIdentifier<Interface> getWildCardPath() {
        return InstanceIdentifier.create(Interfaces.class).child(Interface.class);
    }

    @Override
    protected void remove(InstanceIdentifier<Interface> identifier, Interface intrf) {
        LOG.trace("Remove interface event - key: {}, value: {}", identifier, (Object)intrf);
        if (intrf.getType().equals(L3tunnel.class)) {
            BigInteger dpnId = this.interfaceManager.getDpnForInterface(intrf);
            String ifName = intrf.getName();
            LOG.debug("Removing tunnel interface associated with Interface {}", (Object)intrf.getName());
            this.vpnInterfaceManager.makeTunnelIngressFlow(dpnId, ifName, 1);
        } else {
            VpnInterface vpnInterface = this.vpnInterfaceManager.getVpnInterface(intrf.getName());
            if (vpnInterface != null) {
                InstanceIdentifier<VpnInterface> id = VpnUtil.getVpnInterfaceIdentifier(intrf.getName());
                LOG.debug("Removing VPN Interface associated with Interface {}", (Object)intrf.getName());
                this.vpnInterfaceManager.remove(id, vpnInterface);
            } else {
                LOG.debug("No VPN Interface associated with Interface {}", (Object)intrf.getName());
            }
        }
    }

    @Override
    protected void update(InstanceIdentifier<Interface> identifier, Interface original, Interface update) {
    }
}

