/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.vpnservice;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public abstract class AbstractDataChangeListener<T extends DataObject>
implements DataChangeListener {
    protected final Class<T> clazz;

    public AbstractDataChangeListener(Class<T> clazz) {
        this.clazz = (Class)Preconditions.checkNotNull(clazz, (Object)"Class can not be null!");
    }

    public void onDataChanged(AsyncDataChangeEvent<InstanceIdentifier<?>, DataObject> changeEvent) {
        Preconditions.checkNotNull(changeEvent, (Object)"Async ChangeEvent can not be null!");
        Map createdData = changeEvent.getCreatedData() != null ? changeEvent.getCreatedData() : Collections.emptyMap();
        Set removeData = changeEvent.getRemovedPaths() != null ? changeEvent.getRemovedPaths() : Collections.emptySet();
        Map updateData = changeEvent.getUpdatedData() != null ? changeEvent.getUpdatedData() : Collections.emptyMap();
        Map originalData = changeEvent.getOriginalData() != null ? changeEvent.getOriginalData() : Collections.emptyMap();
        this.createData(createdData);
        this.updateData(updateData, originalData);
        this.removeData(removeData, originalData);
    }

    private void createData(Map<InstanceIdentifier<?>, DataObject> createdData) {
        Set<Object> keys = createdData.keySet() != null ? createdData.keySet() : Collections.emptySet();
        for (InstanceIdentifier instanceIdentifier : keys) {
            if (!this.clazz.equals(instanceIdentifier.getTargetType())) continue;
            InstanceIdentifier createKeyIdent = instanceIdentifier.firstIdentifierOf(this.clazz);
            Optional value = Optional.of((Object)createdData.get(instanceIdentifier));
            if (!value.isPresent()) continue;
            this.add(createKeyIdent, (DataObject)value.get());
        }
    }

    private void updateData(Map<InstanceIdentifier<?>, DataObject> updateData, Map<InstanceIdentifier<?>, DataObject> originalData) {
        Set<Object> keys = updateData.keySet() != null ? updateData.keySet() : Collections.emptySet();
        for (InstanceIdentifier instanceIdentifier : keys) {
            if (!this.clazz.equals(instanceIdentifier.getTargetType())) continue;
            InstanceIdentifier updateKeyIdent = instanceIdentifier.firstIdentifierOf(this.clazz);
            Optional value = Optional.of((Object)updateData.get(instanceIdentifier));
            Optional original = Optional.of((Object)originalData.get(instanceIdentifier));
            if (!value.isPresent() || !original.isPresent()) continue;
            this.update(updateKeyIdent, (DataObject)original.get(), (DataObject)value.get());
        }
    }

    private void removeData(Set<InstanceIdentifier<?>> removeData, Map<InstanceIdentifier<?>, DataObject> originalData) {
        for (InstanceIdentifier<?> key : removeData) {
            if (!this.clazz.equals(key.getTargetType())) continue;
            InstanceIdentifier ident = key.firstIdentifierOf(this.clazz);
            DataObject removeValue = originalData.get(key);
            this.remove(ident, removeValue);
        }
    }

    protected abstract void remove(InstanceIdentifier<T> var1, T var2);

    protected abstract void update(InstanceIdentifier<T> var1, T var2, T var3);

    protected abstract void add(InstanceIdentifier<T> var1, T var2);
}

