package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.vpns;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.VpnIntent;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.Vpns;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>vpnintent</b>
 * <br>(Source path: <i>META-INF/yang/vpnintent.yang</i>):
 * <pre>
 * list vpn-intents {
 *     key "vpn-name"
 *     leaf vpn-name {
 *         type string;
 *     }
 *     leaf path-protection {
 *         type boolean;
 *     }
 *     leaf failover-type {
 *         type failover-type;
 *     }
 *     list endpoint {
 *         key "site-name"
 *         leaf site-name {
 *             type string;
 *         }
 *         leaf ip-prefix {
 *             type ip-prefix;
 *         }
 *         leaf switch-port-id {
 *             type string;
 *         }
 *         leaf next-hop-mac {
 *             type mac-address;
 *         }
 *         uses endpoint-fields;
 *     }
 *     uses vpn-intent;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>vpnintent/vpns/vpn-intents</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.vpns.VpnIntentsBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.vpns.VpnIntentsBuilder
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.vpns.VpnIntentsKey
 *
 */
public interface VpnIntents
    extends
    ChildOf<Vpns>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.vpns.VpnIntents>,
    VpnIntent,
    Identifiable<VpnIntentsKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:vpnintent",
        "2015-01-05", "vpn-intents").intern();

    /**
     * Returns Primary Key of Yang List Type
     *
     */
    VpnIntentsKey getKey();

}

