package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.vpn.intent;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.VpnIntent;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.EndpointFields;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * List to keep track site name and endpoint.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>vpnintent</b>
 * <br>(Source path: <i>META-INF/yang/vpnintent.yang</i>):
 * <pre>
 * list endpoint {
 *     key "site-name"
 *     leaf site-name {
 *         type string;
 *     }
 *     leaf ip-prefix {
 *         type ip-prefix;
 *     }
 *     leaf switch-port-id {
 *         type string;
 *     }
 *     leaf next-hop-mac {
 *         type mac-address;
 *     }
 *     uses endpoint-fields;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>vpnintent/vpn-intent/endpoint</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.vpn.intent.EndpointBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.vpn.intent.EndpointBuilder
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.vpn.intent.EndpointKey
 *
 */
public interface Endpoint
    extends
    ChildOf<VpnIntent>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.vpn.intent.Endpoint>,
    EndpointFields,
    Identifiable<EndpointKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:vpnintent",
        "2015-01-05", "endpoint").intern();

    /**
     * Returns Primary Key of Yang List Type
     *
     */
    EndpointKey getKey();

}

