package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import java.util.Collections;
import java.util.Objects;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpPrefix;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label
 *
 */
public class LabelBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label> {

    private IpPrefix _ipPrefix;
    private LabelKey _key;
    private java.lang.Long _labelId;
    private MacAddress _nextHopMac;
    private java.lang.String _siteName;
    private java.lang.String _switchPortId;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label>> augmentation = Collections.emptyMap();

    public LabelBuilder() {
    }
    public LabelBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.EndpointFields arg) {
        this._siteName = arg.getSiteName();
        this._ipPrefix = arg.getIpPrefix();
        this._switchPortId = arg.getSwitchPortId();
        this._nextHopMac = arg.getNextHopMac();
    }

    public LabelBuilder(Label base) {
        if (base.getKey() == null) {
            this._key = new LabelKey(
                base.getLabelId()
            );
            this._labelId = base.getLabelId();
        } else {
            this._key = base.getKey();
            this._labelId = _key.getLabelId();
        }
        this._ipPrefix = base.getIpPrefix();
        this._nextHopMac = base.getNextHopMac();
        this._siteName = base.getSiteName();
        this._switchPortId = base.getSwitchPortId();
        if (base instanceof LabelImpl) {
            LabelImpl impl = (LabelImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.EndpointFields</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.EndpointFields) {
            this._siteName = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.EndpointFields)arg).getSiteName();
            this._ipPrefix = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.EndpointFields)arg).getIpPrefix();
            this._switchPortId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.EndpointFields)arg).getSwitchPortId();
            this._nextHopMac = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.EndpointFields)arg).getNextHopMac();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.EndpointFields] \n" +
              "but was: " + arg
            );
        }
    }

    public IpPrefix getIpPrefix() {
        return _ipPrefix;
    }
    
    public LabelKey getKey() {
        return _key;
    }
    
    public java.lang.Long getLabelId() {
        return _labelId;
    }
    
    public MacAddress getNextHopMac() {
        return _nextHopMac;
    }
    
    public java.lang.String getSiteName() {
        return _siteName;
    }
    
    public java.lang.String getSwitchPortId() {
        return _switchPortId;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public LabelBuilder setIpPrefix(final IpPrefix value) {
        this._ipPrefix = value;
        return this;
    }
    
     
    public LabelBuilder setKey(final LabelKey value) {
        this._key = value;
        return this;
    }
    
     
     private static void checkLabelIdRange(final long value) {
         if (value >= 0L && value <= 524288L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥524288]].", value));
     }
    
    public LabelBuilder setLabelId(final java.lang.Long value) {
    if (value != null) {
        checkLabelIdRange(value);
    }
        this._labelId = value;
        return this;
    }
    
     
    public LabelBuilder setNextHopMac(final MacAddress value) {
        this._nextHopMac = value;
        return this;
    }
    
     
    public LabelBuilder setSiteName(final java.lang.String value) {
        this._siteName = value;
        return this;
    }
    
     
    public LabelBuilder setSwitchPortId(final java.lang.String value) {
        this._switchPortId = value;
        return this;
    }
    
    public LabelBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public LabelBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Label build() {
        return new LabelImpl(this);
    }

    private static final class LabelImpl implements Label {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label.class;
        }

        private final IpPrefix _ipPrefix;
        private final LabelKey _key;
        private final java.lang.Long _labelId;
        private final MacAddress _nextHopMac;
        private final java.lang.String _siteName;
        private final java.lang.String _switchPortId;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label>> augmentation = Collections.emptyMap();

        private LabelImpl(LabelBuilder base) {
            if (base.getKey() == null) {
                this._key = new LabelKey(
                    base.getLabelId()
                );
                this._labelId = base.getLabelId();
            } else {
                this._key = base.getKey();
                this._labelId = _key.getLabelId();
            }
            this._ipPrefix = base.getIpPrefix();
            this._nextHopMac = base.getNextHopMac();
            this._siteName = base.getSiteName();
            this._switchPortId = base.getSwitchPortId();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public IpPrefix getIpPrefix() {
            return _ipPrefix;
        }
        
        @Override
        public LabelKey getKey() {
            return _key;
        }
        
        @Override
        public java.lang.Long getLabelId() {
            return _labelId;
        }
        
        @Override
        public MacAddress getNextHopMac() {
            return _nextHopMac;
        }
        
        @Override
        public java.lang.String getSiteName() {
            return _siteName;
        }
        
        @Override
        public java.lang.String getSwitchPortId() {
            return _switchPortId;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ipPrefix);
            result = prime * result + Objects.hashCode(_key);
            result = prime * result + Objects.hashCode(_labelId);
            result = prime * result + Objects.hashCode(_nextHopMac);
            result = prime * result + Objects.hashCode(_siteName);
            result = prime * result + Objects.hashCode(_switchPortId);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label)obj;
            if (!Objects.equals(_ipPrefix, other.getIpPrefix())) {
                return false;
            }
            if (!Objects.equals(_key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(_labelId, other.getLabelId())) {
                return false;
            }
            if (!Objects.equals(_nextHopMac, other.getNextHopMac())) {
                return false;
            }
            if (!Objects.equals(_siteName, other.getSiteName())) {
                return false;
            }
            if (!Objects.equals(_switchPortId, other.getSwitchPortId())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                LabelImpl otherImpl = (LabelImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Label [");
            boolean first = true;
        
            if (_ipPrefix != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipPrefix=");
                builder.append(_ipPrefix);
             }
            if (_key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(_key);
             }
            if (_labelId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_labelId=");
                builder.append(_labelId);
             }
            if (_nextHopMac != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nextHopMac=");
                builder.append(_nextHopMac);
             }
            if (_siteName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_siteName=");
                builder.append(_siteName);
             }
            if (_switchPortId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_switchPortId=");
                builder.append(_switchPortId);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
