package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.EndpointFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.Labels;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * Keep track of MPLS/other label endpoint relation.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>vpnintent</b>
 * <br>(Source path: <i>META-INF/yang/vpnintent.yang</i>):
 * <pre>
 * list label {
 *     key "label-id"
 *     leaf label-id {
 *         type uint32;
 *     }
 *     leaf site-name {
 *         type string;
 *     }
 *     leaf ip-prefix {
 *         type ip-prefix;
 *     }
 *     leaf switch-port-id {
 *         type string;
 *     }
 *     leaf next-hop-mac {
 *         type mac-address;
 *     }
 *     uses endpoint-fields;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>vpnintent/labels/label</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.LabelBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.LabelBuilder
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.LabelKey
 *
 */
public interface Label
    extends
    ChildOf<Labels>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.labels.Label>,
    EndpointFields,
    Identifiable<LabelKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:vpnintent",
        "2015-01-05", "label").intern();

    /**
     * 20 bit MPLS label ID
     *
     */
    java.lang.Long getLabelId();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     */
    LabelKey getKey();

}

