package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105;
import java.util.concurrent.Future;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;


/**
 * Interface for implementing the following YANG RPCs defined in module <b>vpnintent</b>
 * <br>(Source path: <i>META-INF/yang/vpnintent.yang</i>):
 * <pre>
 * rpc remove-vpn {
 *     "Remove VPN and its endpoints.";
 *     input {
 *         leaf vpn-name {
 *             type string;
 *         }
 *     }
 *     
 * }
 * rpc remove-vpn-endpoint {
 *     "Remove VPN endpoint.";
 *     input {
 *         leaf vpn-name {
 *             type string;
 *         }
 *         leaf site-name {
 *             type string;
 *         }
 *     }
 *     
 * }
 * rpc add-vpn-endpoint {
 *     "Add VPN endpoint.";
 *     input {
 *         leaf vpn-name {
 *             type string;
 *         }
 *         leaf site-name {
 *             type string;
 *         }
 *         leaf ip-prefix {
 *             type ip-prefix;
 *         }
 *         leaf switch-port-id {
 *             type string;
 *         }
 *         leaf next-hop-mac {
 *             type mac-address;
 *         }
 *     }
 *     
 * }
 * </pre>
 *
 */
public interface VpnintentService
    extends
    RpcService
{




    /**
     * Remove VPN and its endpoints.
     *
     */
    Future<RpcResult<java.lang.Void>> removeVpn(RemoveVpnInput input);
    
    /**
     * Remove VPN endpoint.
     *
     */
    Future<RpcResult<java.lang.Void>> removeVpnEndpoint(RemoveVpnEndpointInput input);
    
    /**
     * Add VPN endpoint.
     *
     */
    Future<RpcResult<java.lang.Void>> addVpnEndpoint(AddVpnEndpointInput input);

}

