package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105;
import org.opendaylight.yangtools.yang.binding.DataRoot;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>vpnintent</b>
 * <br>Source path: <i>META-INF/yang/vpnintent.yang</i>):
 * <pre>
 * module vpnintent {
 *     yang-version 1;
 *     namespace "urn:opendaylight:params:xml:ns:yang:vpnintent";
 *     prefix "vpnintent";
 *
 *     import ietf-inet-types { prefix "inet"; }
 *     
 *     import ietf-yang-types { prefix "yang"; }
 *     revision 2015-01-05 {
 *         description "";
 *     }
 *
 *     container vpns {
 *         list vpn-intents {
 *             key "vpn-name"
 *             leaf vpn-name {
 *                 type string;
 *             }
 *             leaf path-protection {
 *                 type boolean;
 *             }
 *             leaf failover-type {
 *                 type failover-type;
 *             }
 *             list endpoint {
 *                 key "site-name"
 *                 leaf site-name {
 *                     type string;
 *                 }
 *                 leaf ip-prefix {
 *                     type ip-prefix;
 *                 }
 *                 leaf switch-port-id {
 *                     type string;
 *                 }
 *                 leaf next-hop-mac {
 *                     type mac-address;
 *                 }
 *                 uses endpoint-fields;
 *             }
 *             uses vpn-intent;
 *         }
 *     }
 *     container mpls-labels {
 *         list label {
 *             key "label-id"
 *             leaf label-id {
 *                 type uint32;
 *             }
 *             leaf site-name {
 *                 type string;
 *             }
 *             leaf ip-prefix {
 *                 type ip-prefix;
 *             }
 *             leaf switch-port-id {
 *                 type string;
 *             }
 *             leaf next-hop-mac {
 *                 type mac-address;
 *             }
 *             uses endpoint-fields;
 *         }
 *         uses labels;
 *     }
 *
 *     grouping labels {
 *         list label {
 *             key "label-id"
 *             leaf label-id {
 *                 type uint32;
 *             }
 *             leaf site-name {
 *                 type string;
 *             }
 *             leaf ip-prefix {
 *                 type ip-prefix;
 *             }
 *             leaf switch-port-id {
 *                 type string;
 *             }
 *             leaf next-hop-mac {
 *                 type mac-address;
 *             }
 *             uses endpoint-fields;
 *         }
 *     }
 *     grouping endpoint-fields {
 *         leaf site-name {
 *             type string;
 *         }
 *         leaf ip-prefix {
 *             type ip-prefix;
 *         }
 *         leaf switch-port-id {
 *             type string;
 *         }
 *         leaf next-hop-mac {
 *             type mac-address;
 *         }
 *     }
 *     grouping vpn-intent {
 *         leaf vpn-name {
 *             type string;
 *         }
 *         leaf path-protection {
 *             type boolean;
 *         }
 *         leaf failover-type {
 *             type failover-type;
 *         }
 *         list endpoint {
 *             key "site-name"
 *             leaf site-name {
 *                 type string;
 *             }
 *             leaf ip-prefix {
 *                 type ip-prefix;
 *             }
 *             leaf switch-port-id {
 *                 type string;
 *             }
 *             leaf next-hop-mac {
 *                 type mac-address;
 *             }
 *             uses endpoint-fields;
 *         }
 *     }
 *
 *     rpc remove-vpn {
 *         "Remove VPN and its endpoints.";
 *         input {
 *             leaf vpn-name {
 *                 type string;
 *             }
 *         }
 *         
 *     }
 *     rpc remove-vpn-endpoint {
 *         "Remove VPN endpoint.";
 *         input {
 *             leaf vpn-name {
 *                 type string;
 *             }
 *             leaf site-name {
 *                 type string;
 *             }
 *         }
 *         
 *     }
 *     rpc add-vpn-endpoint {
 *         "Add VPN endpoint.";
 *         input {
 *             leaf vpn-name {
 *                 type string;
 *             }
 *             leaf site-name {
 *                 type string;
 *             }
 *             leaf ip-prefix {
 *                 type ip-prefix;
 *             }
 *             leaf switch-port-id {
 *                 type string;
 *             }
 *             leaf next-hop-mac {
 *                 type mac-address;
 *             }
 *         }
 *         
 *     }
 * }
 * </pre>
 *
 */
public interface VpnintentData
    extends
    DataRoot
{




    Vpns getVpns();
    
    MplsLabels getMplsLabels();

}

