package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.vpn.intent.Endpoint;
import java.util.List;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>vpnintent</b>
 * <br>(Source path: <i>META-INF/yang/vpnintent.yang</i>):
 * <pre>
 * grouping vpn-intent {
 *     leaf vpn-name {
 *         type string;
 *     }
 *     leaf path-protection {
 *         type boolean;
 *     }
 *     leaf failover-type {
 *         type failover-type;
 *     }
 *     list endpoint {
 *         key "site-name"
 *         leaf site-name {
 *             type string;
 *         }
 *         leaf ip-prefix {
 *             type ip-prefix;
 *         }
 *         leaf switch-port-id {
 *             type string;
 *         }
 *         uses endpoint-fields;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>vpnintent/vpn-intent</i>
 *
 */
public interface VpnIntent
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:vpnintent",
        "2015-01-05", "vpn-intent").intern();

    /**
     * VPN name
     *
     */
    java.lang.String getVpnName();
    
    java.lang.Boolean isPathProtection();
    
    FailoverType getFailoverType();
    
    /**
     * List to keep track site name and endpoint.
     *
     */
    List<Endpoint> getEndpoint();

}

