package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>vpnintent</b>
 * <br>(Source path: <i>META-INF/yang/vpnintent.yang</i>):
 * <pre>
 * container mpls-labels {
 *     list label {
 *         key "label-id"
 *         leaf label-id {
 *             type uint32;
 *         }
 *         leaf site-name {
 *             type string;
 *         }
 *         leaf ip-prefix {
 *             type ip-prefix;
 *         }
 *         leaf switch-port-id {
 *             type string;
 *         }
 *         uses endpoint-fields;
 *     }
 *     uses labels;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>vpnintent/mpls-labels</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.MplsLabelsBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.MplsLabelsBuilder
 *
 */
public interface MplsLabels
    extends
    ChildOf<VpnintentData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105.MplsLabels>,
    Labels
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:vpnintent",
        "2015-01-05", "mpls-labels").intern();


}

