package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpnintent.rev150105;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpPrefix;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>vpnintent</b>
 * <br>(Source path: <i>META-INF/yang/vpnintent.yang</i>):
 * <pre>
 * grouping endpoint-fields {
 *     leaf site-name {
 *         type string;
 *     }
 *     leaf ip-prefix {
 *         type ip-prefix;
 *     }
 *     leaf switch-port-id {
 *         type string;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>vpnintent/endpoint-fields</i>
 *
 */
public interface EndpointFields
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:vpnintent",
        "2015-01-05", "endpoint-fields").intern();

    /**
     * VPN member site name.
     *
     */
    java.lang.String getSiteName();
    
    /**
     * VPN member IP prefix.
     *
     */
    IpPrefix getIpPrefix();
    
    /**
     * Switch and port ID that VPN member is connected to.
     *
     */
    java.lang.String getSwitchPortId();

}

