package org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331;
import com.google.common.collect.Range;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.List;
import java.math.BigInteger;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfStackedVlan} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfStackedVlan
 *
 */
public class IfStackedVlanBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfStackedVlan> {

    private java.lang.Integer _stackedVlanId;


    public IfStackedVlanBuilder() {
    }

    public IfStackedVlanBuilder(IfStackedVlan base) {
        this._stackedVlanId = base.getStackedVlanId();
    }


    public java.lang.Integer getStackedVlanId() {
        return _stackedVlanId;
    }

    private static void checkStackedVlanIdRange(final int value) {
        if (value >= 1 && value <= 4094) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1‥4094]].", value));
    }
    
    public IfStackedVlanBuilder setStackedVlanId(java.lang.Integer value) {
        if (value != null) {
            checkStackedVlanIdRange(value);
        }
        this._stackedVlanId = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _stackedVlanId_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ONE, BigInteger.valueOf(4094L)));
        return ret;
    }

    public IfStackedVlan build() {
        return new IfStackedVlanImpl(this);
    }

    private static final class IfStackedVlanImpl implements IfStackedVlan {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfStackedVlan> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfStackedVlan.class;
        }

        private final java.lang.Integer _stackedVlanId;


        private IfStackedVlanImpl(IfStackedVlanBuilder base) {
            this._stackedVlanId = base.getStackedVlanId();
        }

        @Override
        public java.lang.Integer getStackedVlanId() {
            return _stackedVlanId;
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_stackedVlanId == null) ? 0 : _stackedVlanId.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfStackedVlan.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfStackedVlan other = (org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfStackedVlan)obj;
            if (_stackedVlanId == null) {
                if (other.getStackedVlanId() != null) {
                    return false;
                }
            } else if(!_stackedVlanId.equals(other.getStackedVlanId())) {
                return false;
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("IfStackedVlan [");
            boolean first = true;
        
            if (_stackedVlanId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_stackedVlanId=");
                builder.append(_stackedVlanId);
             }
            return builder.append(']').toString();
        }
    }

}
