package org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331;
import com.google.common.collect.Range;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;
import java.math.BigInteger;
import java.util.List;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfMpls} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfMpls
 *
 */
public class IfMplsBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfMpls> {

    private List<java.lang.Long> _labelStack;
    private java.lang.Short _numLabels;


    public IfMplsBuilder() {
    }

    public IfMplsBuilder(IfMpls base) {
        this._labelStack = base.getLabelStack();
        this._numLabels = base.getNumLabels();
    }


    public List<java.lang.Long> getLabelStack() {
        return _labelStack;
    }
    
    public java.lang.Short getNumLabels() {
        return _numLabels;
    }

    public IfMplsBuilder setLabelStack(List<java.lang.Long> value) {
        this._labelStack = value;
        return this;
    }
    
    private static void checkNumLabelsRange(final short value) {
        if (value >= (short)1 && value <= (short)7) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1‥7]].", value));
    }
    
    public IfMplsBuilder setNumLabels(java.lang.Short value) {
        if (value != null) {
            checkNumLabelsRange(value);
        }
        this._numLabels = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _numLabels_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ONE, BigInteger.valueOf(7L)));
        return ret;
    }

    public IfMpls build() {
        return new IfMplsImpl(this);
    }

    private static final class IfMplsImpl implements IfMpls {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfMpls> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfMpls.class;
        }

        private final List<java.lang.Long> _labelStack;
        private final java.lang.Short _numLabels;


        private IfMplsImpl(IfMplsBuilder base) {
            this._labelStack = base.getLabelStack();
            this._numLabels = base.getNumLabels();
        }

        @Override
        public List<java.lang.Long> getLabelStack() {
            return _labelStack;
        }
        
        @Override
        public java.lang.Short getNumLabels() {
            return _numLabels;
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_labelStack == null) ? 0 : _labelStack.hashCode());
            result = prime * result + ((_numLabels == null) ? 0 : _numLabels.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfMpls.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfMpls other = (org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfMpls)obj;
            if (_labelStack == null) {
                if (other.getLabelStack() != null) {
                    return false;
                }
            } else if(!_labelStack.equals(other.getLabelStack())) {
                return false;
            }
            if (_numLabels == null) {
                if (other.getNumLabels() != null) {
                    return false;
                }
            } else if(!_numLabels.equals(other.getNumLabels())) {
                return false;
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("IfMpls [");
            boolean first = true;
        
            if (_labelStack != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_labelStack=");
                builder.append(_labelStack);
             }
            if (_numLabels != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_numLabels=");
                builder.append(_numLabels);
             }
            return builder.append(']').toString();
        }
    }

}
