package org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfL3tunnel} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfL3tunnel
 *
 */
public class IfL3tunnelBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfL3tunnel> {

    private IpAddress _gatewayIp;
    private IpAddress _localIp;
    private IpAddress _remoteIp;
    private java.lang.Class<? extends org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.TunnelTypeBase> _tunnelType;


    public IfL3tunnelBuilder() {
    }

    public IfL3tunnelBuilder(IfL3tunnel base) {
        this._gatewayIp = base.getGatewayIp();
        this._localIp = base.getLocalIp();
        this._remoteIp = base.getRemoteIp();
        this._tunnelType = base.getTunnelType();
    }


    public IpAddress getGatewayIp() {
        return _gatewayIp;
    }
    
    public IpAddress getLocalIp() {
        return _localIp;
    }
    
    public IpAddress getRemoteIp() {
        return _remoteIp;
    }
    
    public java.lang.Class<? extends org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.TunnelTypeBase> getTunnelType() {
        return _tunnelType;
    }

    public IfL3tunnelBuilder setGatewayIp(IpAddress value) {
        if (value != null) {
        }
        this._gatewayIp = value;
        return this;
    }
    
    public IfL3tunnelBuilder setLocalIp(IpAddress value) {
        if (value != null) {
        }
        this._localIp = value;
        return this;
    }
    
    public IfL3tunnelBuilder setRemoteIp(IpAddress value) {
        if (value != null) {
        }
        this._remoteIp = value;
        return this;
    }
    
    public IfL3tunnelBuilder setTunnelType(java.lang.Class<? extends org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.TunnelTypeBase> value) {
        this._tunnelType = value;
        return this;
    }

    public IfL3tunnel build() {
        return new IfL3tunnelImpl(this);
    }

    private static final class IfL3tunnelImpl implements IfL3tunnel {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfL3tunnel> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfL3tunnel.class;
        }

        private final IpAddress _gatewayIp;
        private final IpAddress _localIp;
        private final IpAddress _remoteIp;
        private final java.lang.Class<? extends org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.TunnelTypeBase> _tunnelType;


        private IfL3tunnelImpl(IfL3tunnelBuilder base) {
            this._gatewayIp = base.getGatewayIp();
            this._localIp = base.getLocalIp();
            this._remoteIp = base.getRemoteIp();
            this._tunnelType = base.getTunnelType();
        }

        @Override
        public IpAddress getGatewayIp() {
            return _gatewayIp;
        }
        
        @Override
        public IpAddress getLocalIp() {
            return _localIp;
        }
        
        @Override
        public IpAddress getRemoteIp() {
            return _remoteIp;
        }
        
        @Override
        public java.lang.Class<? extends org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.TunnelTypeBase> getTunnelType() {
            return _tunnelType;
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_gatewayIp == null) ? 0 : _gatewayIp.hashCode());
            result = prime * result + ((_localIp == null) ? 0 : _localIp.hashCode());
            result = prime * result + ((_remoteIp == null) ? 0 : _remoteIp.hashCode());
            result = prime * result + ((_tunnelType == null) ? 0 : _tunnelType.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfL3tunnel.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfL3tunnel other = (org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfL3tunnel)obj;
            if (_gatewayIp == null) {
                if (other.getGatewayIp() != null) {
                    return false;
                }
            } else if(!_gatewayIp.equals(other.getGatewayIp())) {
                return false;
            }
            if (_localIp == null) {
                if (other.getLocalIp() != null) {
                    return false;
                }
            } else if(!_localIp.equals(other.getLocalIp())) {
                return false;
            }
            if (_remoteIp == null) {
                if (other.getRemoteIp() != null) {
                    return false;
                }
            } else if(!_remoteIp.equals(other.getRemoteIp())) {
                return false;
            }
            if (_tunnelType == null) {
                if (other.getTunnelType() != null) {
                    return false;
                }
            } else if(!_tunnelType.equals(other.getTunnelType())) {
                return false;
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("IfL3tunnel [");
            boolean first = true;
        
            if (_gatewayIp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_gatewayIp=");
                builder.append(_gatewayIp);
             }
            if (_localIp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_localIp=");
                builder.append(_localIp);
             }
            if (_remoteIp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_remoteIp=");
                builder.append(_remoteIp);
             }
            if (_tunnelType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tunnelType=");
                builder.append(_tunnelType);
             }
            return builder.append(']').toString();
        }
    }

}
