package org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.BaseIds} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.BaseIds
 *
 */
public class BaseIdsBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.BaseIds> {

    private java.lang.String _baseInterface;
    private NodeConnectorId _ofPortId;
    private java.lang.String _tenantId;


    public BaseIdsBuilder() {
    }

    public BaseIdsBuilder(BaseIds base) {
        this._baseInterface = base.getBaseInterface();
        this._ofPortId = base.getOfPortId();
        this._tenantId = base.getTenantId();
    }


    public java.lang.String getBaseInterface() {
        return _baseInterface;
    }
    
    public NodeConnectorId getOfPortId() {
        return _ofPortId;
    }
    
    public java.lang.String getTenantId() {
        return _tenantId;
    }

    public BaseIdsBuilder setBaseInterface(java.lang.String value) {
        this._baseInterface = value;
        return this;
    }
    
    public BaseIdsBuilder setOfPortId(NodeConnectorId value) {
        if (value != null) {
        }
        this._ofPortId = value;
        return this;
    }
    
    public BaseIdsBuilder setTenantId(java.lang.String value) {
        this._tenantId = value;
        return this;
    }

    public BaseIds build() {
        return new BaseIdsImpl(this);
    }

    private static final class BaseIdsImpl implements BaseIds {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.BaseIds> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.BaseIds.class;
        }

        private final java.lang.String _baseInterface;
        private final NodeConnectorId _ofPortId;
        private final java.lang.String _tenantId;


        private BaseIdsImpl(BaseIdsBuilder base) {
            this._baseInterface = base.getBaseInterface();
            this._ofPortId = base.getOfPortId();
            this._tenantId = base.getTenantId();
        }

        @Override
        public java.lang.String getBaseInterface() {
            return _baseInterface;
        }
        
        @Override
        public NodeConnectorId getOfPortId() {
            return _ofPortId;
        }
        
        @Override
        public java.lang.String getTenantId() {
            return _tenantId;
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_baseInterface == null) ? 0 : _baseInterface.hashCode());
            result = prime * result + ((_ofPortId == null) ? 0 : _ofPortId.hashCode());
            result = prime * result + ((_tenantId == null) ? 0 : _tenantId.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.BaseIds.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.BaseIds other = (org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.BaseIds)obj;
            if (_baseInterface == null) {
                if (other.getBaseInterface() != null) {
                    return false;
                }
            } else if(!_baseInterface.equals(other.getBaseInterface())) {
                return false;
            }
            if (_ofPortId == null) {
                if (other.getOfPortId() != null) {
                    return false;
                }
            } else if(!_ofPortId.equals(other.getOfPortId())) {
                return false;
            }
            if (_tenantId == null) {
                if (other.getTenantId() != null) {
                    return false;
                }
            } else if(!_tenantId.equals(other.getTenantId())) {
                return false;
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("BaseIds [");
            boolean first = true;
        
            if (_baseInterface != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_baseInterface=");
                builder.append(_baseInterface);
             }
            if (_ofPortId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ofPortId=");
                builder.append(_ofPortId);
             }
            if (_tenantId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tenantId=");
                builder.append(_tenantId);
             }
            return builder.append(']').toString();
        }
    }

}
