package org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331;
import com.google.common.collect.Range;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.List;
import java.math.BigInteger;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfL2vlan} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfL2vlan
 *
 */
public class IfL2vlanBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfL2vlan> {

    private java.lang.Integer _vlanId;


    public IfL2vlanBuilder() {
    }

    public IfL2vlanBuilder(IfL2vlan base) {
        this._vlanId = base.getVlanId();
    }


    public java.lang.Integer getVlanId() {
        return _vlanId;
    }

    private static void checkVlanIdRange(final int value) {
        if (value >= 1 && value <= 4094) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1‥4094]].", value));
    }
    
    public IfL2vlanBuilder setVlanId(java.lang.Integer value) {
        if (value != null) {
            checkVlanIdRange(value);
        }
        this._vlanId = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _vlanId_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ONE, BigInteger.valueOf(4094L)));
        return ret;
    }

    public IfL2vlan build() {
        return new IfL2vlanImpl(this);
    }

    private static final class IfL2vlanImpl implements IfL2vlan {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfL2vlan> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfL2vlan.class;
        }

        private final java.lang.Integer _vlanId;


        private IfL2vlanImpl(IfL2vlanBuilder base) {
            this._vlanId = base.getVlanId();
        }

        @Override
        public java.lang.Integer getVlanId() {
            return _vlanId;
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_vlanId == null) ? 0 : _vlanId.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfL2vlan.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfL2vlan other = (org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.interfacemgr.rev150331.IfL2vlan)obj;
            if (_vlanId == null) {
                if (other.getVlanId() != null) {
                    return false;
                }
            } else if(!_vlanId.equals(other.getVlanId())) {
                return false;
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("IfL2vlan [");
            boolean first = true;
        
            if (_vlanId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_vlanId=");
                builder.append(_vlanId);
             }
            return builder.append(']').toString();
        }
    }

}
