/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.vpnservice.fibmanager;

import java.math.BigInteger;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.vpnservice.AbstractDataChangeListener;
import org.opendaylight.vpnservice.fibmanager.FibManager;
import org.opendaylight.vpnservice.mdsalutil.MDSALUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FibNodeCapableListener
extends AbstractDataChangeListener<FlowCapableNode>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(FibNodeCapableListener.class);
    private ListenerRegistration<DataChangeListener> listenerRegistration;
    private FibManager fibManager;

    public FibNodeCapableListener(DataBroker dataBroker, FibManager fibManager) {
        super(FlowCapableNode.class);
        this.registerListener(dataBroker);
        this.fibManager = fibManager;
    }

    private void registerListener(DataBroker db) {
        try {
            this.listenerRegistration = db.registerDataChangeListener(LogicalDatastoreType.OPERATIONAL, this.getWildCardPath(), (DataChangeListener)this, AsyncDataBroker.DataChangeScope.ONE);
        }
        catch (Exception e) {
            LOG.error("FibNodeConnectorListener: DataChange listener registration fail!", (Throwable)e);
            throw new IllegalStateException("FibNodeConnectorListener: registration Listener failed.", e);
        }
    }

    private InstanceIdentifier<FlowCapableNode> getWildCardPath() {
        return InstanceIdentifier.create(Nodes.class).child(Node.class).augmentation(FlowCapableNode.class);
    }

    @Override
    public void close() throws Exception {
        if (this.listenerRegistration != null) {
            try {
                this.listenerRegistration.close();
            }
            catch (Exception e) {
                LOG.error("Error when cleaning up DataChangeListener.", (Throwable)e);
            }
            this.listenerRegistration = null;
        }
        LOG.info("FibNodeConnectorListener Closed");
    }

    protected void add(InstanceIdentifier<FlowCapableNode> identifier, FlowCapableNode node) {
        LOG.trace("FlowCapableNode Added: key: " + identifier + ", value=" + node);
        NodeKey nodeKey = (NodeKey)identifier.firstKeyOf(Node.class, NodeKey.class);
        BigInteger dpnId = MDSALUtil.getDpnIdFromNodeName((NodeId)nodeKey.getId());
        this.fibManager.processNodeAdd(dpnId);
    }

    protected void remove(InstanceIdentifier<FlowCapableNode> identifier, FlowCapableNode del) {
    }

    protected void update(InstanceIdentifier<FlowCapableNode> identifier, FlowCapableNode original, FlowCapableNode update) {
    }
}

