/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.vpnservice.fibmanager;

import java.math.BigInteger;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareProvider;
import org.opendaylight.fibmanager.api.IFibManager;
import org.opendaylight.vpnmanager.api.IVpnManager;
import org.opendaylight.vpnservice.fibmanager.FibManager;
import org.opendaylight.vpnservice.mdsalutil.interfaces.IMdsalApiManager;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.l3nexthop.rev150409.L3nexthopService;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FibManagerProvider
implements BindingAwareProvider,
IFibManager,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(FibManagerProvider.class);
    private FibManager fibManager;
    private IMdsalApiManager mdsalManager;
    private IVpnManager vpnmanager;

    public void onSessionInitiated(BindingAwareBroker.ProviderContext session) {
        LOG.info("FibManagerProvider Session Initiated");
        try {
            DataBroker dataBroker = (DataBroker)session.getSALService(DataBroker.class);
            RpcService nexthopService = session.getRpcService(L3nexthopService.class);
            this.fibManager = new FibManager(dataBroker, nexthopService);
            this.fibManager.setMdsalManager(this.mdsalManager);
            this.fibManager.setVpnmanager(this.vpnmanager);
        }
        catch (Exception e) {
            LOG.error("Error initializing services", (Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        LOG.info("FibManagerProvider Closed");
        this.fibManager.close();
    }

    public void setMdsalManager(IMdsalApiManager mdsalManager) {
        this.mdsalManager = mdsalManager;
    }

    public void setVpnmanager(IVpnManager vpnmanager) {
        this.vpnmanager = vpnmanager;
        vpnmanager.setFibService((IFibManager)this);
    }

    public void populateFibOnNewDpn(BigInteger dpnId, long vpnId, String rd) {
        this.fibManager.populateFibOnNewDpn(dpnId, vpnId, rd);
    }

    public void cleanUpDpnForVpn(BigInteger dpnId, long vpnId, String rd) {
        this.fibManager.cleanUpDpnForVpn(dpnId, vpnId, rd);
    }
}

